/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.osgi.framework.Bundle;

public class BundleUtil {
    public static Bundle getBundle(IConfigurationElement configElement) {
        Bundle bundle;
        IContributor contributor = configElement.getContributor();
        if (contributor instanceof RegistryContributor && (bundle = Platform.getBundle((String)((RegistryContributor)contributor).getActualName())) != null) {
            return bundle;
        }
        return Platform.getBundle((String)contributor.getName());
    }

    public static File getFile(Bundle bundle, String path) throws IOException {
        URL url = FileLocator.toFileURL((URL)bundle.getEntry(path));
        try {
            return BundleUtil.toFile(url);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public static File toFile(URL url) throws URISyntaxException {
        URI u = new URI(url.toString().replace(" ", "%20"));
        return new File(u);
    }
}

