/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshSessionRequest
extends CDOClientRequest<CDOSessionProtocol.RefreshSessionResult> {
    private long lastUpdateTime;
    private Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions;
    private int initialChunkSize;
    private boolean enablePassiveUpdates;

    public RefreshSessionRequest(CDOClientProtocol protocol, long lastUpdateTime, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions, int initialChunkSize, boolean enablePassiveUpdates) {
        this(protocol, 19, lastUpdateTime, viewedRevisions, initialChunkSize, enablePassiveUpdates);
    }

    protected RefreshSessionRequest(CDOClientProtocol protocol, short signalID, long lastUpdateTime, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions, int initialChunkSize, boolean enablePassiveUpdates) {
        super(protocol, signalID);
        this.lastUpdateTime = lastUpdateTime;
        this.viewedRevisions = viewedRevisions;
        this.initialChunkSize = initialChunkSize;
        this.enablePassiveUpdates = enablePassiveUpdates;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXLong(this.lastUpdateTime);
        out.writeXInt(this.initialChunkSize);
        out.writeBoolean(this.enablePassiveUpdates);
        out.writeXInt(this.viewedRevisions.size());
        for (Map.Entry<CDOBranch, Map<CDOID, InternalCDORevision>> entry : this.viewedRevisions.entrySet()) {
            CDOBranch branch = entry.getKey();
            Map<CDOID, InternalCDORevision> revisions = entry.getValue();
            out.writeCDOBranch(branch);
            out.writeXInt(revisions.size());
            for (InternalCDORevision revision : revisions.values()) {
                out.writeCDORevisionKey((CDORevisionKey)revision);
            }
        }
    }

    @Override
    protected CDOSessionProtocol.RefreshSessionResult confirming(CDODataInput in) throws IOException {
        byte type;
        this.lastUpdateTime = in.readXLong();
        CDOSessionProtocol.RefreshSessionResult result = new CDOSessionProtocol.RefreshSessionResult(this.lastUpdateTime);
        ResourceSet resourceSet = EMFUtil.newEcoreResourceSet();
        block6: while (true) {
            type = in.readByte();
            switch (type) {
                case 1: {
                    CDOPackageUnit packageUnit = in.readCDOPackageUnit(resourceSet);
                    result.addPackageUnit(packageUnit);
                    continue block6;
                }
                case 2: {
                    InternalCDORevision revision = (InternalCDORevision)in.readCDORevision();
                    result.addChangedObject(revision);
                    continue block6;
                }
                case 3: {
                    CDORevisionKey key = in.readCDORevisionKey();
                    result.addDetachedObject(key);
                    continue block6;
                }
                case 0: {
                    return result;
                }
            }
            break;
        }
        throw new IOException("Invalid refresh type: " + type);
    }
}

