/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ui.generators.common;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.codegen.EEFCodegenPlugin;
import org.eclipse.emf.eef.codegen.ui.generators.callback.EEFGenerationCallback;
import org.eclipse.emf.eef.codegen.ui.generators.common.GenerateAll;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationHelper {
    private List<EEFGenModel> eefGenModels;
    private List<EEFGenerationCallback> callbacks;

    public GenerationHelper(List<EEFGenModel> eefgen, List<EEFGenerationCallback> callbacks) {
        this.eefGenModels = eefgen;
        this.callbacks = callbacks;
    }

    public void generate(IProgressMonitor monitor) {
        try {
            try {
                if (this.eefGenModels != null) {
                    for (EEFGenModel eefGenModel : this.eefGenModels) {
                        IContainer target = this.getGenContainer(eefGenModel);
                        if (target == null) continue;
                        int count = 2;
                        if (eefGenModel.getEditionContexts() != null) {
                            count += eefGenModel.getEditionContexts().size() * 11;
                        }
                        if (eefGenModel.getViewsRepositories() != null) {
                            count += eefGenModel.getViewsRepositories().size() * 5;
                        }
                        monitor.beginTask("Generating EEF Architecture", count);
                        GenerateAll generator = new GenerateAll(target, eefGenModel);
                        generator.doGenerate(monitor);
                        for (IContainer nextContainer : generator.getGenerationTargets()) {
                            nextContainer.refreshLocal(2, monitor);
                        }
                        monitor.worked(1);
                        for (EEFGenerationCallback callback : this.callbacks) {
                            callback.execute(generator.getGenerationTargets(), monitor);
                        }
                    }
                }
            }
            catch (IOException e) {
                EEFCodegenPlugin.getDefault().logError(e);
                monitor.done();
            }
            catch (CoreException e) {
                EEFCodegenPlugin.getDefault().logError((Exception)((Object)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public IContainer getGenContainer(EEFGenModel eefGenModel) throws IOException {
        if (eefGenModel != null && eefGenModel.getGenDirectory() != null) {
            IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(eefGenModel.getGenDirectory()));
            return target;
        }
        return null;
    }
}

