/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.ui.internal.view;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.efacet.ui.internal.ImageProvider;
import org.eclipse.emf.facet.efacet.ui.internal.view.EditableContext;
import org.eclipse.emf.facet.efacet.ui.internal.view.NavigationView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class ContextPaneMenuManager
extends MenuManager
implements IMenuListener {
    private final EditableContext context;
    private final NavigationView queryExecutionView;
    private final IAction removeAllAction = new Action("Remove all"){
        {
            this.setImageDescriptor(ImageProvider.getInstance().getRemoveAllImageDescriptor());
        }

        public void run() {
            ContextPaneMenuManager.this.context.clear();
            ContextPaneMenuManager.this.context.done();
        }
    };
    private final IAction removeSelectedElementsAction = new Action("Remove"){
        {
            this.setImageDescriptor(ImageProvider.getInstance().getRemoveImageDescriptor());
        }

        public void run() {
            NavigationView.ContextInfo contextInfo = ContextPaneMenuManager.this.queryExecutionView.getContextInfo();
            for (EObject eObject : contextInfo.getSelectedEObjects()) {
                ContextPaneMenuManager.this.context.remove(eObject);
            }
            ContextPaneMenuManager.this.context.done();
        }
    };

    public ContextPaneMenuManager(NavigationView queryExecutionView, EditableContext context, TreeViewer treeViewer) {
        this.queryExecutionView = queryExecutionView;
        this.context = context;
        this.addMenuActions();
        this.addMenuListener(this);
        this.addKeyShortcuts(treeViewer);
    }

    private void addKeyShortcuts(TreeViewer treeViewer) {
        treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    ContextPaneMenuManager.this.removeSelectedElementsAction.run();
                }
            }
        });
    }

    private void addMenuActions() {
        this.add(this.removeSelectedElementsAction);
        this.add(this.removeAllAction);
    }

    public void menuAboutToShow(IMenuManager manager) {
        NavigationView.ContextInfo contextInfo = this.queryExecutionView.getContextInfo();
        this.removeAllAction.setEnabled(contextInfo.getEObjects().size() > 0);
        this.removeSelectedElementsAction.setEnabled(contextInfo.getSelectedEObjects().size() > 0);
    }
}

