/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.junit4.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LogAppenderTestRule
implements TestRule {
    protected Logger logger;
    private Class<?> clazz;
    private LogListener logListener;

    public LogAppenderTestRule(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LogAppenderTestRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    LogAppenderTestRule.this.after();
                }
            }
        };
    }

    protected void before() {
        this.logger = Logger.getLogger(this.clazz);
        this.logger.removeAllAppenders();
        this.logger.setAdditivity(false);
        this.logListener = new LogListener();
        this.logger.addAppender((Appender)this.logListener);
    }

    protected void after() {
        this.logger.removeAppender((Appender)this.logListener);
        this.logger.setAdditivity(true);
    }

    public void assertContainsMessage(String messagePart) {
        String eventsToString = this.eventsToString();
        Assert.assertTrue((String)("No messagePart found in " + eventsToString), (boolean)eventsToString.contains(messagePart));
    }

    protected String eventsToString() {
        String eventsToString = IterableExtensions.join((Iterable)IterableExtensions.map(this.logListener.getEvents(), (Functions.Function1)new Functions.Function1<LoggingEvent, String>(){

            public String apply(LoggingEvent it) {
                return it.getMessage().toString();
            }
        }), (CharSequence)",");
        return eventsToString;
    }

    public void assertEmpty() {
        Assert.assertTrue((String)("Found messages: " + this.eventsToString()), (this.logListener.getEvents().size() == 0 ? 1 : 0) != 0);
    }

    public Logger getLogger() {
        return this.logger;
    }

    static class LogListener
    extends NullAppender {
        private List<LoggingEvent> events = new ArrayList<LoggingEvent>();

        LogListener() {
        }

        public List<LoggingEvent> getEvents() {
            return this.events;
        }

        public void doAppend(LoggingEvent event) {
            this.events.add(event);
        }
    }
}

