/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import org.eclipse.gef.common.activate.ActivatableSupport;
import org.eclipse.gef.common.activate.IActivatable;
import org.eclipse.gef.common.adapt.AdaptableSupport;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.common.adapt.inject.InjectAdapters;
import org.eclipse.gef.common.beans.property.ReadOnlyListWrapperEx;
import org.eclipse.gef.common.beans.property.ReadOnlyMultisetProperty;
import org.eclipse.gef.common.beans.property.ReadOnlyMultisetWrapper;
import org.eclipse.gef.common.beans.property.ReadOnlySetMultimapProperty;
import org.eclipse.gef.common.beans.property.ReadOnlySetMultimapWrapper;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.common.collections.ObservableMultiset;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.mvc.fx.behaviors.IBehavior;
import org.eclipse.gef.mvc.fx.handlers.IHandler;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public abstract class AbstractVisualPart<V extends Node>
implements IVisualPart<V> {
    private static final String DEFAULT_ANCHORAGE_ROLE = "default";
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private AdaptableSupport<IVisualPart<V>> ads = new AdaptableSupport((IAdaptable)this);
    private ReadOnlyObjectWrapper<IVisualPart<? extends Node>> parentProperty = new ReadOnlyObjectWrapper();
    private ObservableList<IVisualPart<? extends Node>> children = CollectionUtils.observableArrayList();
    private ObservableList<IVisualPart<? extends Node>> childrenUnmodifiable;
    private ReadOnlyListWrapperEx<IVisualPart<? extends Node>> childrenUnmodifiableProperty;
    private ObservableSetMultimap<IVisualPart<? extends Node>, String> anchorages = CollectionUtils.observableHashMultimap();
    private ObservableSetMultimap<IVisualPart<? extends Node>, String> anchoragesUnmodifiable;
    private ReadOnlySetMultimapWrapper<IVisualPart<? extends Node>, String> anchoragesUnmodifiableProperty;
    private ObservableMultiset<IVisualPart<? extends Node>> anchoreds = CollectionUtils.observableHashMultiset();
    private ObservableMultiset<IVisualPart<? extends Node>> anchoredsUnmodifiable;
    private ReadOnlyMultisetWrapper<IVisualPart<? extends Node>> anchoredsUnmodifiableProperty;
    private BooleanProperty refreshVisualProperty = new SimpleBooleanProperty((Object)this, "refreshVisual", true);
    private V visual;
    private ReadOnlyObjectWrapper<IViewer> viewerProperty = new ReadOnlyObjectWrapper();

    public final void activate() {
        this.acs.activate(null, this::doActivate);
    }

    protected void activateAdapters() {
        new TreeMap(this.ads.getAdapters()).values().forEach(adapter -> {
            if (adapter instanceof IActivatable) {
                ((IActivatable)adapter).activate();
            }
        });
    }

    protected void activateChildren() {
        for (IVisualPart child : this.children) {
            child.activate();
        }
    }

    public ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyObjectProperty<IViewer> adaptableProperty() {
        return this.viewerProperty.getReadOnlyProperty();
    }

    public ReadOnlyMapProperty<AdapterKey<?>, Object> adaptersProperty() {
        return this.ads.adaptersProperty();
    }

    @Override
    public void addChild(IVisualPart<? extends Node> child) {
        this.addChild(child, this.children.size());
    }

    @Override
    public void addChild(IVisualPart<? extends Node> child, int index) {
        if (this.children.contains(child)) {
            throw new IllegalArgumentException("Cannot add " + child + " as child of " + this + " because its already a child.");
        }
        this.children.add(index, child);
        child.setParent(this);
        this.refreshVisual();
        this.doAddChildVisual(child, index);
        child.refreshVisual();
        if (this.isActive()) {
            child.activate();
        }
    }

    @Override
    public void addChildren(List<? extends IVisualPart<? extends Node>> children) {
        this.addChildren(children, this.children.size());
    }

    @Override
    public void addChildren(List<? extends IVisualPart<? extends Node>> children, int index) {
        if (!Collections.disjoint(this.children, children)) {
            ArrayList<? extends IVisualPart<? extends Node>> alreadyContainedChildren = new ArrayList<IVisualPart<? extends Node>>(children);
            children.retainAll((Collection<?>)this.children);
            throw new IllegalArgumentException("Cannot add " + children + " as children of " + this + " because the following are already children: " + alreadyContainedChildren + ".");
        }
        int i = 0;
        while (i < children.size()) {
            this.addChild(children.get(i), index + i);
            ++i;
        }
    }

    @Override
    public ReadOnlySetMultimapProperty<IVisualPart<? extends Node>, String> anchoragesUnmodifiableProperty() {
        if (this.anchoragesUnmodifiableProperty == null) {
            this.anchoragesUnmodifiableProperty = new ReadOnlySetMultimapWrapper(this.getAnchoragesUnmodifiable());
        }
        return this.anchoragesUnmodifiableProperty.getReadOnlyProperty();
    }

    @Override
    public ReadOnlyMultisetProperty<IVisualPart<? extends Node>> anchoredsUnmodifiableProperty() {
        if (this.anchoredsUnmodifiableProperty == null) {
            this.anchoredsUnmodifiableProperty = new ReadOnlyMultisetWrapper(this.getAnchoredsUnmodifiable());
        }
        return this.anchoredsUnmodifiableProperty.getReadOnlyProperty();
    }

    @Override
    public void attachAnchored(IVisualPart<? extends Node> anchored) {
        IViewer oldViewer = this.getViewer();
        HashMultiset newAnchoreds = HashMultiset.create(this.anchoreds);
        newAnchoreds.add(anchored);
        IViewer newViewer = this.determineViewer(this.getParent(), (Multiset<IVisualPart<Node>>)newAnchoreds);
        if (oldViewer != null && newViewer != oldViewer) {
            oldViewer.unsetAdapter(this);
        }
        this.anchoreds.add(anchored);
        if (newViewer != null && newViewer != oldViewer) {
            newViewer.setAdapter(this, String.valueOf(System.identityHashCode(this)));
        }
    }

    @Override
    public void attachToAnchorage(IVisualPart<? extends Node> anchorage) {
        this.attachToAnchorage(anchorage, DEFAULT_ANCHORAGE_ROLE);
    }

    @Override
    public void attachToAnchorage(IVisualPart<? extends Node> anchorage, String role) {
        if (anchorage == null) {
            throw new IllegalArgumentException("Anchorage may not be null.");
        }
        if (role == null) {
            throw new IllegalArgumentException("Role may not be null.");
        }
        if (this.anchorages.containsEntry(anchorage, (Object)role)) {
            throw new IllegalArgumentException("Already attached to anchorage " + anchorage + " with role '" + role + "'.");
        }
        this.anchorages.put(anchorage, (Object)role);
        anchorage.attachAnchored(this);
        anchorage.refreshVisual();
        this.doAttachToAnchorageVisual(anchorage, role);
        this.refreshVisual();
    }

    @Override
    public ReadOnlyListProperty<IVisualPart<? extends Node>> childrenUnmodifiableProperty() {
        if (this.childrenUnmodifiableProperty == null) {
            this.childrenUnmodifiableProperty = new ReadOnlyListWrapperEx((Object)this, "children", this.getChildrenUnmodifiable());
        }
        return this.childrenUnmodifiableProperty.getReadOnlyProperty();
    }

    public final void deactivate() {
        this.acs.deactivate(this::doDeactivate, null);
    }

    protected void deactivateAdapters() {
        new TreeMap(this.ads.getAdapters()).values().forEach(adapter -> {
            if (adapter instanceof IActivatable) {
                ((IActivatable)adapter).deactivate();
            }
        });
    }

    protected void deactivateChildren() {
        for (IVisualPart child : this.children) {
            child.deactivate();
        }
    }

    @Override
    public void detachAnchored(IVisualPart<? extends Node> anchored) {
        IViewer oldViewer = this.getViewer();
        HashMultiset oldAnchoreds = HashMultiset.create(this.anchoreds);
        oldAnchoreds.remove(anchored);
        IViewer newViewer = this.determineViewer(this.getParent(), (Multiset<IVisualPart<Node>>)oldAnchoreds);
        if (oldViewer != null && newViewer != oldViewer) {
            oldViewer.unsetAdapter(this);
        }
        this.anchoreds.remove(anchored);
        if (newViewer != null && newViewer != oldViewer) {
            newViewer.setAdapter(this, String.valueOf(System.identityHashCode(this)));
        }
    }

    @Override
    public void detachFromAnchorage(IVisualPart<? extends Node> anchorage) {
        this.detachFromAnchorage(anchorage, DEFAULT_ANCHORAGE_ROLE);
    }

    @Override
    public void detachFromAnchorage(IVisualPart<? extends Node> anchorage, String role) {
        if (anchorage == null) {
            throw new IllegalArgumentException("Anchorage may not be null.");
        }
        if (role == null) {
            throw new IllegalArgumentException("Role may not be null.");
        }
        if (!this.anchorages.containsEntry(anchorage, (Object)role)) {
            throw new IllegalArgumentException("Not attached to anchorage " + anchorage + " with role '" + role + "'.");
        }
        this.doDetachFromAnchorageVisual(anchorage, role);
        anchorage.detachAnchored(this);
        this.anchorages.remove(anchorage, (Object)role);
    }

    protected IViewer determineViewer(IVisualPart<? extends Node> parent, Multiset<IVisualPart<? extends Node>> anchoreds) {
        if (parent != null && parent.getRoot() != null) {
            return parent.getRoot().getViewer();
        }
        return null;
    }

    public void dispose() {
        this.ads.dispose();
    }

    protected void doActivate() {
        this.activateAdapters();
        this.activateChildren();
    }

    protected void doAddChildVisual(IVisualPart<? extends Node> child, int index) {
        throw new UnsupportedOperationException("Need to properly implement addChildVisual(IVisualPart, int) for " + this.getClass());
    }

    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        throw new UnsupportedOperationException("Need to implement attachToAnchorageVisual(IVisualPart, String) for " + this.getClass());
    }

    protected abstract V doCreateVisual();

    protected void doDeactivate() {
        this.deactivateChildren();
        this.deactivateAdapters();
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        throw new UnsupportedOperationException("Need to implement detachFromAnchorageVisual(IVisualPart, String) for " + this.getClass());
    }

    protected abstract void doRefreshVisual(V var1);

    protected void doRemoveChildVisual(IVisualPart<? extends Node> child, int index) {
        throw new UnsupportedOperationException("Need to implement removeChildVisual(IVisualPart, int) for " + this.getClass());
    }

    public IViewer getAdaptable() {
        return (IViewer)this.viewerProperty.get();
    }

    public <T> T getAdapter(AdapterKey<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> T getAdapter(Class<T> classKey) {
        return (T)this.ads.getAdapter(classKey);
    }

    public <T> T getAdapter(TypeToken<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> AdapterKey<T> getAdapterKey(T adapter) {
        return this.ads.getAdapterKey(adapter);
    }

    public ObservableMap<AdapterKey<?>, Object> getAdapters() {
        return this.ads.getAdapters();
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> classKey) {
        return this.ads.getAdapters(classKey);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    @Override
    public ObservableSetMultimap<IVisualPart<? extends Node>, String> getAnchoragesUnmodifiable() {
        if (this.anchoragesUnmodifiable == null) {
            this.anchoragesUnmodifiable = CollectionUtils.unmodifiableObservableSetMultimap(this.anchorages);
        }
        return this.anchoragesUnmodifiable;
    }

    @Override
    public ObservableMultiset<IVisualPart<? extends Node>> getAnchoredsUnmodifiable() {
        if (this.anchoredsUnmodifiable == null) {
            this.anchoredsUnmodifiable = CollectionUtils.unmodifiableObservableMultiset(this.anchoreds);
        }
        return this.anchoredsUnmodifiable;
    }

    @Override
    public Map<AdapterKey<? extends IBehavior>, IBehavior> getBehaviors() {
        return this.ads.getAdapters(IBehavior.class);
    }

    @Override
    public ObservableList<IVisualPart<? extends Node>> getChildrenUnmodifiable() {
        if (this.childrenUnmodifiable == null) {
            this.childrenUnmodifiable = FXCollections.unmodifiableObservableList(this.children);
        }
        return this.childrenUnmodifiable;
    }

    @Override
    public Map<AdapterKey<? extends IHandler>, IHandler> getHandlers() {
        return this.ads.getAdapters(IHandler.class);
    }

    @Override
    public IVisualPart<? extends Node> getParent() {
        return (IVisualPart)this.parentProperty.get();
    }

    @Override
    public Map<AdapterKey<? extends IPolicy>, IPolicy> getPolicies() {
        return this.ads.getAdapters(IPolicy.class);
    }

    @Override
    public IRootPart<? extends Node> getRoot() {
        IVisualPart<Node> parent = this.getParent();
        while (parent != null && parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (parent instanceof IRootPart) {
            return (IRootPart)parent;
        }
        return null;
    }

    @Override
    public V getVisual() {
        if (this.visual == null) {
            this.visual = this.doCreateVisual();
        }
        return this.visual;
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    @Override
    public boolean isRefreshVisual() {
        return this.refreshVisualProperty.get();
    }

    @Override
    public ReadOnlyObjectProperty<IVisualPart<? extends Node>> parentProperty() {
        return this.parentProperty.getReadOnlyProperty();
    }

    @Override
    public final void refreshVisual() {
        if (this.visual != null && this.isRefreshVisual()) {
            this.doRefreshVisual(this.visual);
        }
    }

    @Override
    public BooleanProperty refreshVisualProperty() {
        return this.refreshVisualProperty;
    }

    protected void register(IViewer viewer) {
        this.registerAtVisualPartMap(viewer, this.getVisual());
    }

    protected void registerAtVisualPartMap(IViewer viewer, V visual) {
        viewer.getVisualPartMap().put((Node)visual, this);
    }

    @Override
    public void removeChild(IVisualPart<? extends Node> child) {
        if (!this.children.contains(child)) {
            throw new IllegalArgumentException("Cannot remove " + child + " as child of " + this + " because it is no child.");
        }
        if (this.isActive()) {
            child.deactivate();
        }
        this.doRemoveChildVisual(child, this.children.indexOf(child));
        child.setParent(null);
        this.children.remove(child);
    }

    @Override
    public void removeChildren(List<? extends IVisualPart<? extends Node>> children) {
        if (!this.children.containsAll(children)) {
            ArrayList<? extends IVisualPart<? extends Node>> arrayList = new ArrayList<IVisualPart<? extends Node>>(children);
            arrayList.removeAll((Collection<?>)this.children);
            throw new IllegalArgumentException("Cannot remove " + children + " as children of " + this + " because the following are no children: " + arrayList + ".");
        }
        for (IVisualPart<? extends Node> iVisualPart : children) {
            this.removeChild(iVisualPart);
        }
    }

    @Override
    public void reorderChild(IVisualPart<? extends Node> child, int index) {
        int oldIndex = this.getChildrenUnmodifiable().indexOf(child);
        if (oldIndex < 0) {
            throw new IllegalArgumentException("Cannot reorder child " + child + " because it is no child.");
        }
        this.removeChild(child);
        this.addChild(child, index);
    }

    public void setAdaptable(IViewer viewer) {
        IViewer oldViewer = (IViewer)this.viewerProperty.get();
        if (oldViewer != null && viewer != oldViewer) {
            this.unregister(oldViewer);
        }
        this.viewerProperty.set((Object)viewer);
        if (viewer != null && viewer != oldViewer) {
            this.register(viewer);
        }
    }

    public <T> void setAdapter(T adapter) {
        this.ads.setAdapter(adapter);
    }

    public <T> void setAdapter(T adapter, String role) {
        this.ads.setAdapter(adapter, role);
    }

    public <T> void setAdapter(TypeToken<T> adapterType, T adapter) {
        this.ads.setAdapter(adapterType, adapter);
    }

    @InjectAdapters
    public <T> void setAdapter(TypeToken<T> adapterType, T adapter, String role) {
        this.ads.setAdapter(adapterType, adapter, role);
    }

    @Override
    public void setParent(IVisualPart<? extends Node> newParent) {
        IVisualPart oldParent = (IVisualPart)this.parentProperty.get();
        if (oldParent == newParent) {
            return;
        }
        IViewer oldViewer = this.getViewer();
        IViewer newViewer = this.determineViewer(newParent, (Multiset<IVisualPart<? extends Node>>)this.getAnchoredsUnmodifiable());
        if (oldViewer != null && newViewer != oldViewer) {
            oldViewer.unsetAdapter(this);
        }
        this.parentProperty.set(newParent);
        if (newViewer != null && newViewer != oldViewer) {
            newViewer.setAdapter(this, String.valueOf(System.identityHashCode(this)));
        }
    }

    @Override
    public void setRefreshVisual(boolean isRefreshVisual) {
        this.refreshVisualProperty.set(isRefreshVisual);
    }

    protected void unregister(IViewer viewer) {
        this.unregisterFromVisualPartMap(viewer, this.getVisual());
    }

    protected void unregisterFromVisualPartMap(IViewer viewer, V visual) {
        Map<Node, IVisualPart<? extends Node>> registry = viewer.getVisualPartMap();
        if (registry.get(visual) != this) {
            throw new IllegalArgumentException("Not registered under visual");
        }
        registry.remove(visual);
    }

    public <T> void unsetAdapter(T adapter) {
        this.ads.unsetAdapter(adapter);
    }
}

