/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;

public class CommandRef {
    private final Class<? extends TextBuiltin> impl;
    private final String name;
    private String usage;
    boolean common;

    CommandRef(Class<? extends TextBuiltin> clazz) {
        this(clazz, CommandRef.guessName(clazz));
    }

    CommandRef(Class<? extends TextBuiltin> clazz, Command cmd) {
        this(clazz, cmd.name().length() > 0 ? cmd.name() : CommandRef.guessName(clazz));
        this.usage = cmd.usage();
        this.common = cmd.common();
    }

    private CommandRef(Class<? extends TextBuiltin> clazz, String cn) {
        this.impl = clazz;
        this.name = cn;
        this.usage = "";
    }

    private static String guessName(Class<? extends TextBuiltin> clazz) {
        StringBuilder s = new StringBuilder();
        if (clazz.getName().startsWith("org.eclipse.jgit.pgm.debug.")) {
            s.append("debug-");
        }
        boolean lastWasDash = true;
        char[] cArray = clazz.getSimpleName().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c)) {
                if (!lastWasDash) {
                    s.append('-');
                }
                lastWasDash = !lastWasDash;
                s.append(Character.toLowerCase(c));
            } else {
                s.append(c);
                lastWasDash = false;
            }
            ++n2;
        }
        return s.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.usage;
    }

    public boolean isCommon() {
        return this.common;
    }

    public String getImplementationClassName() {
        return this.impl.getName();
    }

    public ClassLoader getImplementationClassLoader() {
        return this.impl.getClassLoader();
    }

    public TextBuiltin create() {
        TextBuiltin r;
        Constructor<? extends TextBuiltin> c;
        try {
            c = this.impl.getDeclaredConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(MessageFormat.format(CLIText.get().cannotCreateCommand, this.getName(), e));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(MessageFormat.format(CLIText.get().cannotCreateCommand, this.getName(), e));
        }
        c.setAccessible(true);
        try {
            r = c.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(MessageFormat.format(CLIText.get().cannotCreateCommand, this.getName(), e));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(MessageFormat.format(CLIText.get().cannotCreateCommand, this.getName(), e));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(MessageFormat.format(CLIText.get().cannotCreateCommand, this.getName(), e));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(MessageFormat.format(CLIText.get().cannotCreateCommand, this.getName(), e));
        }
        r.setCommandName(this.getName());
        return r;
    }

    public String toString() {
        return "CommandRef [impl=" + this.impl + ", name=" + this.name + ", usage=" + CLIText.get().resourceBundle().getString(this.usage) + ", common=" + this.common + "]";
    }
}

