/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.common.commands;

import java.io.File;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.SendDirectoryMessage;
import org.eclipse.jubula.communication.internal.message.SendDirectoryResponseMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendDirectoryCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(SendDirectoryCommand.class);
    private SendDirectoryMessage m_message;

    public Message execute() {
        SendDirectoryResponseMessage resp = new SendDirectoryResponseMessage();
        resp.setBase(this.m_message.getDirname());
        File workDir = new File(this.m_message.getDirname());
        if (!workDir.isDirectory()) {
            return resp;
        }
        File[] entries = workDir.listFiles();
        if (entries == null) {
            resp.setError(2);
            return resp;
        }
        int i = 0;
        while (i < entries.length) {
            File entry = entries[i];
            if (!entry.isHidden() && entry.canRead()) {
                if (entry.isDirectory()) {
                    resp.addDir(entry.getPath());
                } else {
                    resp.addFile(entry.getPath());
                }
            }
            ++i;
        }
        File[] roots = File.listRoots();
        if (roots != null) {
            int i2 = 0;
            while (i2 < roots.length) {
                resp.addRoot(roots[i2].getAbsolutePath());
                ++i2;
            }
        }
        return resp;
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (SendDirectoryMessage)message;
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

