/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.ui.bridge.listener;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.TreeViewContainerGUIController;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskActivationListener
implements ITaskActivationListener,
DataEventDispatcher.IProjectStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(DataEventDispatcher.class);

    public void preTaskActivated(ITask task) {
    }

    public void preTaskDeactivated(ITask task) {
    }

    public void taskActivated(ITask task) {
        this.closeAllEditors();
        if (GeneralStorage.getInstance().getProject() != null) {
            this.restoreOpenEditors(task);
        }
    }

    private void restoreOpenEditors(ITask task) {
        List interesting = ContextCore.getContextManager().getActiveContext().getInteresting();
        ArrayList<String> handles = new ArrayList<String>();
        for (IInteractionElement element : interesting) {
            handles.add(element.getHandleIdentifier());
            IProjectPO project = GeneralStorage.getInstance().getProject();
            if (project == null) continue;
            if (element.getContentType().equals("org.eclipse.jubula.client.alm.mylyn.ui.bridge.content.type.editor.ctd")) {
                IEditorPart editor;
                ITestDataCategoryPO centralTestData = project.getTestDataCubeCont();
                if (centralTestData == null || (editor = AbstractOpenHandler.openEditor((IPersistentObject)centralTestData)) == null) continue;
                editor.getSite().getPage().activate((IWorkbenchPart)editor);
                continue;
            }
            if (!element.getContentType().equals("org.eclipse.jubula.client.alm.mylyn.ui.bridge.content.type.editor.ome")) continue;
            for (IAUTMainPO po : project.getAutMainList()) {
                IEditorPart editor;
                if (po == null || !po.getGuid().equals(element.getHandleIdentifier()) || (editor = AbstractOpenHandler.openEditor((IPersistentObject)po)) == null) continue;
                editor.getSite().getPage().activate((IWorkbenchPart)editor);
            }
        }
        for (String id : handles) {
            AbstractContextStructureBridge bridge;
            Object objForHandle;
            if (!id.endsWith("editor") || !((objForHandle = (bridge = ContextCore.getStructureBridge((String)"org.eclipse.jubula.client.alm.mylyn.ui.bridge.content.type.editor")).getObjectForHandle(id)) instanceof INodePO)) continue;
            AbstractOpenHandler.openEditor((IPersistentObject)((INodePO)objForHandle));
        }
    }

    public void taskDeactivated(ITask task) {
        this.collapseTree((ITreeViewerContainer)Plugin.getView((String)"org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser"));
        for (TestCaseBrowser tcb : MultipleTCBTracker.getInstance().getOpenTCBs()) {
            this.collapseTree((ITreeViewerContainer)tcb);
        }
    }

    private void collapseTree(ITreeViewerContainer tvc) {
        if (tvc != null) {
            TreeViewContainerGUIController.collapseExpandTree((ITreeViewerContainer)tvc);
        }
    }

    public void handleProjectStateChanged(DataEventDispatcher.ProjectState state) {
        ITask currentTask;
        if (DataEventDispatcher.ProjectState.opened.equals((Object)state) && (currentTask = TasksUi.getTaskActivityManager().getActiveTask()) != null) {
            this.restoreOpenEditors(currentTask);
        }
    }

    public void closeAllEditors() {
        try {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            for (IWorkbenchWindow window : MonitorUi.getMonitoredWindows()) {
                IWorkbenchPage page = window.getActivePage();
                if (page == null) continue;
                IEditorReference[] references = page.getEditorReferences();
                ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    toClose.add(reference);
                    ++n2;
                }
                page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
            }
        }
        catch (Throwable t) {
            LOG.error("Unhandled exception while closing all editors", t);
        }
    }
}

