/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.io.File;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ClassPathDialog
extends InputDialog {
    private Button m_addFileButton;
    private Button m_addDirButton;
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private boolean m_buttonsEnabled;
    private String[] m_fileFilterExtensions;
    private boolean m_fileSelectionAllowed;

    public ClassPathDialog(Shell parentShell, String title, String oldName, String message, String label, String wrongNameError, String doubleNameError, String image, String shell, boolean browseable, int maxLength, boolean browseButtonsEnabled, String[] fileExtensionFilters, boolean fileSelectionAllowed) {
        super(parentShell, title, oldName, message, label, wrongNameError, doubleNameError, image, shell, browseable, maxLength);
        this.m_buttonsEnabled = browseButtonsEnabled;
        this.m_fileFilterExtensions = fileExtensionFilters;
        this.m_fileSelectionAllowed = fileSelectionAllowed;
    }

    private void installListeners() {
        this.m_addDirButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        if (this.m_addFileButton != null) {
            this.m_addFileButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        }
    }

    @Override
    protected void createAdditionalComponents(Composite parent) {
        new Label(parent, 0);
        GridData data = new GridData();
        if (this.m_fileSelectionAllowed) {
            this.m_addFileButton = new Button(parent, 8);
            this.m_addFileButton.setText(Messages.ClassPathDialogFile);
            data.horizontalAlignment = 3;
            data.grabExcessHorizontalSpace = true;
            this.m_addFileButton.setLayoutData((Object)data);
            this.m_addFileButton.setEnabled(this.m_buttonsEnabled);
        }
        this.m_addDirButton = new Button(parent, 8);
        this.m_addDirButton.setText(Messages.ClassPathDialogDir);
        data = new GridData();
        data.horizontalAlignment = 3;
        if (!this.m_fileSelectionAllowed) {
            data.grabExcessHorizontalSpace = true;
        }
        this.m_addDirButton.setLayoutData((Object)data);
        this.m_addDirButton.setEnabled(this.m_buttonsEnabled);
        this.installListeners();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control area = super.createDialogArea(parent);
        return area;
    }

    void handleAddDirButtonEvent(DirectoryDialog directoryDialog) {
        directoryDialog.setMessage(Messages.ClassPathDialogAddDir);
        directoryDialog.setFilterPath(Utils.getLastDirPath());
        String directory = directoryDialog.open();
        if (directory != null) {
            Utils.storeLastDirPath(directoryDialog.getFilterPath());
            this.setInputFieldText(directory);
        }
    }

    void handleAddFileButtonEvent(FileDialog fileDialog) {
        String directory;
        fileDialog.setFilterExtensions(new String[]{"*.*"});
        fileDialog.setText(Messages.ClassPathDialogFileDialogMessage);
        fileDialog.setFilterPath(Utils.getLastDirPath());
        if (this.m_fileFilterExtensions != null) {
            fileDialog.setFilterExtensions(this.m_fileFilterExtensions);
        }
        if ((directory = fileDialog.open()) != null) {
            Utils.storeLastDirPath(fileDialog.getFilterPath());
            String concatFiles = "";
            String[] stringArray = fileDialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                file = String.valueOf(fileDialog.getFilterPath()) + File.separator + file + File.pathSeparator;
                concatFiles = String.valueOf(concatFiles) + file;
                ++n2;
            }
            this.setInputFieldText(concatFiles);
        }
    }

    private class WidgetSelectionListener
    extends SelectionAdapter {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ClassPathDialog.this.m_addDirButton)) {
                ClassPathDialog.this.handleAddDirButtonEvent(new DirectoryDialog(ClassPathDialog.this.getShell(), 81920));
                return;
            }
            if (o.equals(ClassPathDialog.this.m_addFileButton)) {
                ClassPathDialog.this.handleAddFileButtonEvent(new FileDialog(ClassPathDialog.this.getShell(), 81922));
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "(" + o + ")" + "."));
        }
    }
}

