/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.driver;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.WeakEventHandler;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.eclipse.jubula.rc.common.driver.IEventMatcher;
import org.eclipse.jubula.rc.common.driver.IRobotEventConfirmer;
import org.eclipse.jubula.rc.common.driver.InterceptorOptions;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.WorkaroundUtil;
import org.eclipse.jubula.rc.javafx.components.ParentGetter;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.util.JavaFXEventConverter;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

class RobotEventConfirmerJavaFXImpl
implements IRobotEventConfirmer,
EventHandler<Event> {
    private static AutServerLogger log = new AutServerLogger(RobotEventConfirmerJavaFXImpl.class);
    private volatile boolean m_enabled = false;
    private boolean m_waiting = false;
    private volatile InterceptorOptions m_options;
    private LinkedBlockingQueue<Event> m_eventList = new LinkedBlockingQueue();
    private LinkedBlockingQueue<ReadOnlyObjectProperty<? extends Window>> m_sceneGraphs;

    protected RobotEventConfirmerJavaFXImpl(InterceptorOptions options, LinkedBlockingQueue<ReadOnlyObjectProperty<? extends Window>> sceneGraphs) {
        this.m_options = options;
        this.m_sceneGraphs = sceneGraphs;
    }

    public void waitToConfirm(Object eventTarget, IEventMatcher matcher) throws RobotException {
        this.waitToConfirm(eventTarget, matcher, RobotTiming.getEventConfirmTimeout());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitToConfirm(Object eventTarget, IEventMatcher matcher, long pTimeout) throws RobotException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Waiting for EventID: " + String.valueOf(matcher) + " on Component: " + String.valueOf(eventTarget)));
        }
        ArrayList<Event> history = new ArrayList<Event>();
        try {
            this.m_waiting = true;
            try {
                long timeout = pTimeout;
                long done = System.currentTimeMillis() + timeout;
                do {
                    Event e = this.m_eventList.poll(timeout, TimeUnit.MILLISECONDS);
                    history.add(e);
                    if (this.isEventMatch(e, matcher, (EventTarget)eventTarget)) {
                        return;
                    }
                    long now = System.currentTimeMillis();
                    timeout = done - now;
                } while (this.m_waiting && timeout > 0L);
            }
            catch (InterruptedException e) {
                throw new RobotException((Throwable)e);
            }
            if (!this.m_waiting) return;
            boolean fallBackMatching = matcher.isFallBackEventMatching(history, eventTarget);
            if (fallBackMatching) return;
            if (WorkaroundUtil.isIgnoreTimeout()) return;
            throw new RobotException("Timeout received before confirming the posted event: " + matcher.getEventId(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
        }
        finally {
            this.setEnabled(false);
        }
    }

    private boolean isEventMatch(Event e, IEventMatcher matcher, EventTarget expectedTarget) {
        return e != null && this.isComponentMatch(expectedTarget, e.getTarget()) && matcher.isMatching((Object)e);
    }

    private boolean isComponentMatch(EventTarget expectedTarget, EventTarget actualTarget) {
        if (expectedTarget == null) {
            return true;
        }
        EventTarget currentExpectedTarget = expectedTarget;
        while (currentExpectedTarget != null) {
            if (currentExpectedTarget == actualTarget) {
                return true;
            }
            currentExpectedTarget = ParentGetter.get(currentExpectedTarget);
        }
        EventTarget currentActualTarget = actualTarget;
        while (currentActualTarget != null) {
            if (currentActualTarget == expectedTarget) {
                return true;
            }
            currentActualTarget = ParentGetter.get(currentActualTarget);
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        this.m_eventList.clear();
        if (this.m_enabled) {
            long[] masks = this.m_options.getEventMask();
            int i = 0;
            while (i < masks.length) {
                for (ReadOnlyObjectProperty<? extends Window> w : this.m_sceneGraphs) {
                    if (w.getValue() == null || !((Window)w.getValue()).isShowing()) {
                        this.m_sceneGraphs.remove(w);
                        continue;
                    }
                    final Window win = (Window)w.get();
                    final long mask = masks[i];
                    final RobotEventConfirmerJavaFXImpl me = this;
                    EventThreadQueuerJavaFXImpl.invokeAndWait("Add EventFilter for conforming", new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            win.addEventFilter(JavaFXEventConverter.awtToFX(mask), (EventHandler)new WeakEventHandler((EventHandler)me));
                            Scene s = win.getScene();
                            if (s != null && s.getFocusOwner() != null) {
                                s.getFocusOwner().addEventFilter(JavaFXEventConverter.awtToFX(mask), (EventHandler)new WeakEventHandler((EventHandler)me));
                            }
                            return null;
                        }
                    });
                }
                ++i;
            }
        } else {
            long[] masks = this.m_options.getEventMask();
            int i = 0;
            while (i < masks.length) {
                for (ReadOnlyObjectProperty<? extends Window> w : this.m_sceneGraphs) {
                    if (w.getValue() == null || !((Window)w.getValue()).isShowing()) {
                        this.m_sceneGraphs.remove(w);
                        continue;
                    }
                    final Window win = (Window)w.get();
                    final long mask = masks[i];
                    final RobotEventConfirmerJavaFXImpl me = this;
                    EventThreadQueuerJavaFXImpl.invokeAndWait("Remove EventFilter for conforming", new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            win.removeEventFilter(JavaFXEventConverter.awtToFX(mask), (EventHandler)new WeakEventHandler((EventHandler)me));
                            Scene s = win.getScene();
                            if (s != null && s.getFocusOwner() != null) {
                                s.getFocusOwner().removeEventFilter(JavaFXEventConverter.awtToFX(mask), (EventHandler)new WeakEventHandler((EventHandler)me));
                            }
                            return null;
                        }
                    });
                }
                ++i;
            }
        }
    }

    public void handle(Event event) {
        try {
            this.m_eventList.put(event);
        }
        catch (InterruptedException interruptedException) {
            log.error((Object)("InterruptedException: " + event));
        }
    }
}

