/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.util.emf.core.internal.allinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.modisco.util.emf.core.internal.Activator;
import org.eclipse.modisco.util.emf.core.internal.allinstances.MetaclassInstances;
import org.eclipse.modisco.util.emf.core.internal.allinstances.ModelChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassInstancesAdapter
extends AdapterImpl
implements MetaclassInstances {
    private final Resource resource;
    private Map<EClass, Set<EObject>> instancesByEClass;
    private Map<EClass, Set<EObject>> instancesByType;
    private boolean cacheInvalidated;
    private final List<ModelChangeListener> listeners = new ArrayList<ModelChangeListener>();
    private boolean resolved = false;

    protected MetaclassInstancesAdapter(Resource resource, boolean clearCache) {
        this.resource = resource;
        if (clearCache) {
            this.clearAndComputeCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAndComputeCache() {
        MetaclassInstancesAdapter metaclassInstancesAdapter = this;
        synchronized (metaclassInstancesAdapter) {
            this.instancesByEClass = new HashMap<EClass, Set<EObject>>();
            this.instancesByType = new HashMap<EClass, Set<EObject>>();
            TransactionalEditingDomain transactDomain = MetaclassInstancesAdapter.getTransactionalEditingDomain(this.resource);
            if (transactDomain == null) {
                this.computeCache();
            } else {
                try {
                    transactDomain.runExclusive(new Runnable(){

                        public void run() {
                            MetaclassInstancesAdapter.this.computeCache();
                        }
                    });
                }
                catch (InterruptedException e) {
                    Logger.logWarning((Throwable)e, (String)"InterruptedException during Model allOfClass computing.", (Plugin)Activator.getDefault());
                    this.computeCache();
                }
            }
            this.cacheInvalidated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        MetaclassInstancesAdapter metaclassInstancesAdapter = this;
        synchronized (metaclassInstancesAdapter) {
            this.instancesByEClass = new HashMap<EClass, Set<EObject>>();
            this.instancesByType = new HashMap<EClass, Set<EObject>>();
            this.cacheInvalidated = true;
        }
    }

    private void validateCache() {
        if (this.cacheInvalidated) {
            this.clearAndComputeCache();
        }
        this.cacheInvalidated = false;
    }

    private void computeCache() {
        TreeIterator allContents = this.resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            this.addModelElement(eObject, false);
        }
    }

    protected synchronized void addModelElement(EObject element, boolean recursively) {
        element.eAdapters().remove((Object)this);
        element.eAdapters().add((Object)this);
        List<EClass> eClasses = this.getEClasses(element);
        for (EClass eClass : eClasses) {
            if (eClass == null) {
                Logger.logWarning((String)("Element has null eClass: " + element), (Plugin)Activator.getDefault());
                continue;
            }
            this.associateToEClass(element, eClass);
            this.associateToType(element, eClass);
            EList allSuperTypes = eClass.getEAllSuperTypes();
            for (EClass superType : allSuperTypes) {
                this.associateToType(element, superType);
            }
            if (!recursively) continue;
            EList contents = element.eContents();
            for (EObject contained : contents) {
                this.addModelElement(contained, true);
            }
        }
    }

    protected synchronized void removeModelElement(EObject element, boolean recursively) {
        element.eAdapters().remove((Object)this);
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        for (Map.Entry<EClass, Set<EObject>> entry : this.instancesByEClass.entrySet()) {
            if (!entry.getValue().contains(element)) continue;
            eClasses.add(entry.getKey());
        }
        for (EClass eClass : eClasses) {
            this.disassociateFromEClass(element, eClass);
        }
        ArrayList<EClass> types = new ArrayList<EClass>();
        for (Map.Entry<EClass, Set<EObject>> entry : this.instancesByType.entrySet()) {
            if (!entry.getValue().contains(element)) continue;
            types.add(entry.getKey());
        }
        for (EClass eClass : types) {
            this.disassociateFromType(element, eClass);
        }
        if (recursively) {
            EList contents = element.eContents();
            for (EObject contained : contents) {
                this.removeModelElement(contained, true);
            }
        }
    }

    public synchronized void notifyChanged(Notification msg) {
        this.handleChanged(msg);
        this.notifyModelChanged(msg);
    }

    protected void handleChanged(Notification msg) {
        Iterator resourceImpl;
        EObject eObject;
        Resource eResource;
        ResourceImpl resourceImpl2;
        int eventType = msg.getEventType();
        Object feature = msg.getFeature();
        Object oldValue = msg.getOldValue();
        Object newValue = msg.getNewValue();
        Object notifier = msg.getNotifier();
        if (notifier instanceof ResourceImpl ? (resourceImpl2 = (ResourceImpl)notifier).isLoading() : notifier instanceof EObject && (eResource = (eObject = (EObject)notifier).eResource()) instanceof ResourceImpl && (resourceImpl = (ResourceImpl)eResource).isLoading()) {
            return;
        }
        switch (eventType) {
            case 3: {
                EReference reference;
                if (feature instanceof EReference && !(reference = (EReference)feature).isContainment()) {
                    return;
                }
                if (!(newValue instanceof EObject)) break;
                this.addModelElement((EObject)newValue, true);
                break;
            }
            case 4: {
                EReference reference;
                if (feature instanceof EReference && !(reference = (EReference)feature).isContainment()) {
                    return;
                }
                if (!(oldValue instanceof EObject)) break;
                if (notifier instanceof Resource && ((EObject)oldValue).eContainer() != null) {
                    return;
                }
                this.removeModelElement((EObject)oldValue, true);
                break;
            }
            case 5: {
                if (!(newValue instanceof EList)) break;
                EList eList = (EList)newValue;
                for (Object object : eList) {
                    if (!(object instanceof EObject)) continue;
                    this.addModelElement((EObject)object, true);
                }
                break;
            }
            case 6: {
                if (!(newValue instanceof EList)) break;
                EList eList = (EList)newValue;
                for (Object object : eList) {
                    if (!(object instanceof EObject)) continue;
                    this.removeModelElement((EObject)object, true);
                }
                break;
            }
            case 1: {
                EReference reference;
                if (!(feature instanceof EReference) || !(reference = (EReference)feature).isContainment()) break;
                if (oldValue != null && oldValue instanceof EObject) {
                    this.removeModelElement((EObject)oldValue, true);
                }
                if (newValue == null || !(newValue instanceof EObject)) break;
                this.addModelElement((EObject)newValue, true);
                break;
            }
            case 2: {
                EReference reference;
                if (feature instanceof EReference && !(reference = (EReference)feature).isContainment() || !(oldValue instanceof EObject)) break;
                this.removeModelElement((EObject)oldValue, true);
                break;
            }
            case 9: {
                if (!(newValue instanceof EObject)) break;
                EObject resolvedEObject = (EObject)newValue;
                eResource = resolvedEObject.eResource();
                EList eAdapters = eResource.eAdapters();
                for (Adapter adapter : eAdapters) {
                    if (!(adapter instanceof MetaclassInstancesAdapter)) continue;
                    MetaclassInstancesAdapter adapter2 = (MetaclassInstancesAdapter)adapter;
                    adapter2.resolved();
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolved() {
        MetaclassInstancesAdapter metaclassInstancesAdapter = this;
        synchronized (metaclassInstancesAdapter) {
            if (this.resolved) {
                return;
            }
            this.resolved = true;
        }
        this.clearCache();
    }

    protected List<EClass> getEClasses(EObject element) {
        return Collections.singletonList(element.eClass());
    }

    protected synchronized void associateToEClass(EObject element, EClass eClass) {
        Set<EObject> instancesForEClass = this.instancesByEClass.get(eClass);
        if (instancesForEClass == null) {
            instancesForEClass = new LinkedHashSet<EObject>();
            this.instancesByEClass.put(eClass, instancesForEClass);
        }
        instancesForEClass.add(element);
    }

    protected synchronized void associateToType(EObject element, EClass eClass) {
        Set<EObject> instancesForType = this.instancesByType.get(eClass);
        if (instancesForType == null) {
            instancesForType = new LinkedHashSet<EObject>();
            this.instancesByType.put(eClass, instancesForType);
        }
        instancesForType.add(element);
    }

    protected synchronized void disassociateFromEClass(EObject element, EClass eClass) {
        Set<EObject> instancesForEClass = this.instancesByEClass.get(eClass);
        if (instancesForEClass != null) {
            instancesForEClass.remove(element);
            if (instancesForEClass.isEmpty()) {
                this.instancesByEClass.remove(eClass);
            }
        }
    }

    protected synchronized void disassociateFromType(EObject element, EClass eClass) {
        Set<EObject> instancesForType = this.instancesByType.get(eClass);
        if (instancesForType != null) {
            instancesForType.remove(element);
            if (instancesForType.isEmpty()) {
                this.instancesByType.remove(eClass);
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == MetaclassInstances.class;
    }

    @Override
    public synchronized Collection<EObject> getInstances(EClass eClass, boolean includingSubclasses) {
        this.validateCache();
        Set<EObject> set = includingSubclasses ? this.instancesByType.get(eClass) : this.instancesByEClass.get(eClass);
        if (set == null) {
            return Collections.emptySet();
        }
        return new ArrayList<EObject>(set);
    }

    protected Map<EClass, Set<EObject>> getInstancesByEClass() {
        return this.instancesByEClass;
    }

    protected Map<EClass, Set<EObject>> getInstancesByType() {
        return this.instancesByType;
    }

    protected Resource getResource() {
        return this.resource;
    }

    @Override
    public void addListener(ModelChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(ModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyModelChanged(Notification msg) {
        for (ModelChangeListener listener : this.listeners) {
            listener.modelChanged(msg);
        }
    }

    private static TransactionalEditingDomain getTransactionalEditingDomain(Resource aResource) {
        EditingDomain editDomain;
        TransactionalEditingDomain transactDomain = null;
        if (aResource != null && aResource.getResourceSet() instanceof IEditingDomainProvider && (editDomain = ((IEditingDomainProvider)aResource.getResourceSet()).getEditingDomain()) instanceof TransactionalEditingDomain) {
            transactDomain = (TransactionalEditingDomain)editDomain;
        }
        return transactDomain;
    }
}

