/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.OrganizationService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.egit.ui.internal.components.CachedCheckboxTreeViewer;
import org.eclipse.egit.ui.internal.components.FilteredCheckboxTree;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.GitHubException;
import org.eclipse.mylyn.internal.github.ui.GitHubImages;
import org.eclipse.mylyn.internal.github.ui.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RepositorySelectionWizardPage
extends WizardPage {
    private Button addGistRepoButton;
    private Label selectedLabel;
    private FilteredCheckboxTree tree;
    private int repoCount = 0;
    private String user;
    private String password;

    public RepositorySelectionWizardPage() {
        super("repositoriesPage", Messages.RepositorySelectionWizardPage_Title, null);
        this.setDescription(Messages.RepositorySelectionWizardPage_Description);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean createGistRepository() {
        return this.addGistRepoButton.getSelection() && this.addGistRepoButton.isVisible();
    }

    public Repository[] getRepositories() {
        Object[] checked = this.tree.getCheckboxTreeViewer().getCheckedLeafElements();
        Repository[] repos = new Repository[checked.length];
        int i = 0;
        while (i < repos.length) {
            repos[i] = ((RepositoryAdapter)((Object)checked[i])).repo;
            ++i;
        }
        return repos;
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(displayArea);
        Label repoLabel = new Label(displayArea, 0);
        repoLabel.setText(Messages.RepositorySelectionWizardPage_LabelRepos);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)repoLabel);
        this.tree = new FilteredCheckboxTree(displayArea, null, 2816, new PatternFilter());
        CachedCheckboxTreeViewer viewer = this.tree.getCheckboxTreeViewer();
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof OrganizationAdapter) {
                    if (e2 instanceof OrganizationAdapter) {
                        return ((OrganizationAdapter)((Object)e1)).getLabel(e1).compareToIgnoreCase(((OrganizationAdapter)((Object)e2)).getLabel(e2));
                    }
                    if (e2 instanceof RepositoryAdapter) {
                        return 1;
                    }
                }
                if (e1 instanceof RepositoryAdapter) {
                    if (e2 instanceof RepositoryAdapter) {
                        return ((RepositoryAdapter)((Object)e1)).getLabel(e1).compareToIgnoreCase(((RepositoryAdapter)((Object)e2)).getLabel(e2));
                    }
                    if (e2 instanceof OrganizationAdapter) {
                        return -1;
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RepositorySelectionWizardPage.this.updateSelectionLabel();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tree);
        ToolBar toolbar = new ToolBar(displayArea, 0x800200);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)toolbar);
        ToolItem checkItem = new ToolItem(toolbar, 8);
        checkItem.setImage(GitHubImages.get("org.eclipse.mylyn.github.uiGITHUB_CHECKALL_OBJ"));
        checkItem.setToolTipText(Messages.RepositorySelectionWizardPage_TooltipCheckAll);
        checkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionWizardPage.this.tree.getCheckboxTreeViewer().setAllChecked(true);
                Object[] objectArray = RepositorySelectionWizardPage.this.tree.getCheckboxTreeViewer().getCheckedLeafElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object leaf = objectArray[n2];
                    RepositorySelectionWizardPage.this.tree.getCheckboxTreeViewer().setChecked(leaf, true);
                    ++n2;
                }
                RepositorySelectionWizardPage.this.updateSelectionLabel();
            }
        });
        ToolItem uncheckItem = new ToolItem(toolbar, 8);
        uncheckItem.setImage(GitHubImages.get("org.eclipse.mylyn.github.uiGITHUB_UNCHECKALL_OBJ"));
        uncheckItem.setToolTipText(Messages.RepositorySelectionWizardPage_TooltipUncheckAll);
        uncheckItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionWizardPage.this.tree.getCheckboxTreeViewer().setCheckedElements(new Object[0]);
                RepositorySelectionWizardPage.this.updateSelectionLabel();
            }
        });
        this.selectedLabel = new Label(displayArea, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.selectedLabel);
        this.addGistRepoButton = new Button(displayArea, 32);
        this.addGistRepoButton.setText(Messages.RepositorySelectionWizardPage_LabelAddGist);
        this.addGistRepoButton.setSelection(true);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.addGistRepoButton);
        this.addGistRepoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionWizardPage.this.validatePage();
            }
        });
        this.setControl((Control)displayArea);
        this.setPageComplete(false);
    }

    private void updateSelectionLabel() {
        this.selectedLabel.setText(MessageFormat.format(Messages.RepositorySelectionWizardPage_LabelSelectionCount, this.tree.getCheckboxTreeViewer().getCheckedLeafCount(), this.repoCount));
        this.selectedLabel.getParent().layout(true, true);
        this.validatePage();
    }

    private void validatePage() {
        this.setPageComplete(this.getRepositories().length > 0 || this.createGistRepository());
        if (this.isPageComplete()) {
            this.setErrorMessage(null);
        }
    }

    private void updateInput(final List<Object> repos) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (RepositorySelectionWizardPage.this.getControl().isDisposed()) {
                    return;
                }
                RepositorySelectionWizardPage.this.tree.getCheckboxTreeViewer().setCheckedElements(new Object[0]);
                RepositorySelectionWizardPage.this.tree.getViewer().setInput((Object)new WorkbenchAdapter(){

                    public Object[] getChildren(Object object) {
                        return repos.toArray();
                    }
                });
                RepositorySelectionWizardPage.this.updateSelectionLabel();
            }
        });
    }

    private void removeExisting(List<Repository> repos, List<String> existing) {
        Iterator<Repository> iter = repos.iterator();
        while (iter.hasNext()) {
            String id = iter.next().generateId();
            if (id != null && !existing.contains(id)) continue;
            iter.remove();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        this.addGistRepoButton.setVisible(TasksUi.getRepositoryManager().getRepositories("githubGists").isEmpty());
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    GitHubClient client = GitHub.configureClient((GitHubClient)new GitHubClient());
                    client.setCredentials(RepositorySelectionWizardPage.this.user, RepositorySelectionWizardPage.this.password);
                    RepositoryService service = new RepositoryService(client);
                    OrganizationService orgs = new OrganizationService(client);
                    RepositorySelectionWizardPage.this.repoCount = 0;
                    ArrayList<WorkbenchAdapter> repos = new ArrayList<WorkbenchAdapter>();
                    ArrayList<String> existing = new ArrayList<String>();
                    for (TaskRepository repo : TasksUi.getRepositoryManager().getRepositories("github")) {
                        String id = GitHub.getRepository((String)repo.getRepositoryUrl()).generateId();
                        if (id == null) continue;
                        existing.add(id);
                    }
                    try {
                        monitor.beginTask("", 2);
                        monitor.setTaskName(Messages.RepositorySelectionWizardPage_TaskFetchingRepositories);
                        List userRepos = service.getRepositories();
                        RepositorySelectionWizardPage.this.removeExisting(userRepos, existing);
                        RepositorySelectionWizardPage repositorySelectionWizardPage = RepositorySelectionWizardPage.this;
                        repositorySelectionWizardPage.repoCount = repositorySelectionWizardPage.repoCount + userRepos.size();
                        for (Repository repo : userRepos) {
                            repos.add(new RepositoryAdapter(repo));
                        }
                        monitor.worked(1);
                        monitor.setTaskName(Messages.RepositorySelectionWizardPage_TaskFetchingOrganizationRepositories);
                        for (User org : orgs.getOrganizations()) {
                            List orgRepos = service.getOrgRepositories(org.getLogin());
                            RepositorySelectionWizardPage.this.removeExisting(orgRepos, existing);
                            RepositorySelectionWizardPage repositorySelectionWizardPage2 = RepositorySelectionWizardPage.this;
                            repositorySelectionWizardPage2.repoCount = repositorySelectionWizardPage2.repoCount + orgRepos.size();
                            repos.add(new OrganizationAdapter(org, orgRepos));
                        }
                        RepositorySelectionWizardPage.this.updateInput(repos);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(GitHubException.wrap((IOException)e));
                    }
                }
            });
            this.setErrorMessage(null);
        }
        catch (InvocationTargetException e) {
            this.updateInput(Collections.emptyList());
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.setErrorMessage(MessageFormat.format(Messages.RepositorySelectionWizardPage_ErrorLoading, cause.getLocalizedMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class OrganizationAdapter
    extends WorkbenchAdapter {
        private final User org;
        private final RepositoryAdapter[] repos;

        OrganizationAdapter(User org, List<Repository> repos) {
            this.org = org;
            this.repos = new RepositoryAdapter[repos.size()];
            int length = this.repos.length;
            int i = 0;
            while (i < length) {
                this.repos[i] = new RepositoryAdapter(repos.get(i));
                ++i;
            }
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return GitHubImages.DESC_GITHUB_ORG;
        }

        public Object[] getChildren(Object object) {
            return this.repos;
        }

        public StyledString getStyledText(Object object) {
            StyledString styled = new StyledString(this.getLabel(object));
            styled.append(MessageFormat.format(" ({0})", this.repos.length), StyledString.COUNTER_STYLER);
            return styled;
        }

        public String getLabel(Object object) {
            return this.org.getLogin();
        }
    }

    private static class RepositoryAdapter
    extends WorkbenchAdapter {
        private final Repository repo;

        RepositoryAdapter(Repository repo) {
            this.repo = repo;
        }

        public String getLabel(Object object) {
            String label = this.repo.generateId();
            return label != null ? label : "";
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return TasksUiImages.REPOSITORY;
        }
    }

    private static class RepositoryLabelProvider
    extends DelegatingStyledCellLabelProvider
    implements ILabelProvider {
        private final RepositoryStyledLabelProvider wrapped = (RepositoryStyledLabelProvider)this.getStyledStringProvider();

        public RepositoryLabelProvider() {
            super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new RepositoryStyledLabelProvider());
        }

        public String getText(Object element) {
            return this.wrapped.getText(element);
        }

        public void dispose() {
            super.dispose();
            this.wrapped.dispose();
        }
    }

    private static class RepositoryStyledLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    ILabelProvider {
        private final WorkbenchLabelProvider wrapped = new WorkbenchLabelProvider();

        private RepositoryStyledLabelProvider() {
        }

        public String getText(Object element) {
            return this.wrapped.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.wrapped.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RepositoryAdapter) {
                return ((RepositoryAdapter)((Object)element)).getStyledText(element);
            }
            if (element instanceof OrganizationAdapter) {
                return ((OrganizationAdapter)((Object)element)).getStyledText(element);
            }
            return new StyledString(this.wrapped.getText(element));
        }

        public Image getImage(Object element) {
            return this.wrapped.getImage(element);
        }
    }
}

