/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ref;

import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.net4j.util.ref.KeyedReference;
import org.eclipse.net4j.util.ref.KeyedSoftReference;
import org.eclipse.net4j.util.ref.KeyedStrongReference;
import org.eclipse.net4j.util.ref.KeyedWeakReference;
import org.eclipse.net4j.util.ref.ReferenceValueMap2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceValueMap<K, V>
extends ReferenceValueMap2<K, V>
implements ConcurrentMap<K, V> {
    public ReferenceValueMap() {
        this(new ConcurrentHashMap());
    }

    public ReferenceValueMap(ConcurrentMap<K, KeyedReference<K, V>> map) {
        super(map);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        try {
            KeyedReference<K, V> ref = this.createReference(key, value, this.queue);
            KeyedReference<K, V> oldRef = ((ConcurrentMap)this.map).putIfAbsent(key, ref);
            V v = this.dereference(oldRef);
            return v;
        }
        finally {
            this.purgeQueue();
        }
    }

    @Override
    public V replace(K key, V value) {
        try {
            KeyedReference<K, V> ref = this.createReference(key, value, this.queue);
            KeyedReference<K, V> oldRef = ((ConcurrentMap)this.map).replace(key, ref);
            V v = this.dereference(oldRef);
            return v;
        }
        finally {
            this.purgeQueue();
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        try {
            KeyedReference<K, V> oldRef = this.createReference(key, oldValue, this.queue);
            KeyedReference<K, V> newRef = this.createReference(key, newValue, this.queue);
            boolean bl = ((ConcurrentMap)this.map).replace(key, oldRef, newRef);
            return bl;
        }
        finally {
            this.purgeQueue();
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        return ((ConcurrentMap)this.map).remove(key, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Soft<K, V>
    extends ReferenceValueMap<K, V> {
        public Soft() {
        }

        public Soft(ConcurrentMap<K, KeyedReference<K, V>> map) {
            super(map);
        }

        @Override
        protected KeyedReference<K, V> createReference(K key, V value, ReferenceQueue<V> queue) {
            return new KeyedSoftReference<K, V>(key, value, queue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Strong<K, V>
    extends ReferenceValueMap<K, V> {
        public Strong() {
        }

        public Strong(ConcurrentMap<K, KeyedReference<K, V>> map) {
            super(map);
        }

        @Override
        protected KeyedReference<K, V> createReference(K key, V value, ReferenceQueue<V> queue) {
            return new KeyedStrongReference<K, V>(key, value);
        }

        @Override
        protected ReferenceQueue<V> createQueue() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Weak<K, V>
    extends ReferenceValueMap<K, V> {
        public Weak() {
        }

        public Weak(ConcurrentMap<K, KeyedReference<K, V>> map) {
            super(map);
        }

        @Override
        protected KeyedReference<K, V> createReference(K key, V value, ReferenceQueue<V> queue) {
            return new KeyedWeakReference<K, V>(key, value, queue);
        }
    }
}

