/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.runtime;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.constraints.Activator;
import org.eclipse.papyrus.infra.constraints.environment.ConstraintEnvironment;
import org.eclipse.papyrus.infra.constraints.environment.ConstraintType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class ConstraintsManager {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.constraints.ConstraintEnvironment";
    private ResourceSet resourceSet;
    private final Set<ConstraintEnvironment> environments = new HashSet<ConstraintEnvironment>();
    public static final ConstraintsManager instance = new ConstraintsManager();

    private ConstraintsManager() {
        this.resourceSet = new ResourceSetImpl();
        this.loadExtensionPoint();
    }

    private void loadExtensionPoint() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String environmentResource = e.getAttribute("environmentModel");
            URI uri = URI.createPlatformPluginURI((String)(String.valueOf(e.getContributor().getName()) + "/" + environmentResource), (boolean)true);
            try {
                this.addEnvironment(uri);
            }
            catch (IOException ex) {
                Activator.log.error("The plugin " + e.getContributor() + " contributed an invalid extension for " + EXTENSION_ID, (Throwable)ex);
            }
            ++n2;
        }
    }

    public void addEnvironment(URI uri) throws IOException {
        EObject model = EMFHelper.loadEMFModel((ResourceSet)this.resourceSet, (URI)uri);
        if (model instanceof ConstraintEnvironment) {
            this.addEnvironment((ConstraintEnvironment)model);
        }
    }

    public void addEnvironment(ConstraintEnvironment environment) {
        this.environments.add(environment);
    }

    public Collection<ConstraintType> getConstraintTypes() {
        HashSet<ConstraintType> constraintTypes = new HashSet<ConstraintType>();
        for (ConstraintEnvironment environment : this.environments) {
            constraintTypes.addAll((Collection<ConstraintType>)environment.getConstraintTypes());
        }
        return constraintTypes;
    }
}

