/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import com.google.common.base.Objects;
import java.util.Collection;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.infra.ui.util.WorkbenchPartHelper;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramPropertyTester
extends PropertyTester {
    public static final String IS_DIAGRAM_EDITOR = "isDiagramEditor";
    public static final String IS_GMF_DIAGRAM_CONTEXT_ACTIVE = "isGmfDiagramContextActive";
    public static final String IS_TEXT_ZONE = "isTextZone";
    public static final String DIAGRAM_TYPE = "diagramType";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_DIAGRAM_EDITOR.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isDiagramEditor((IStructuredSelection)receiver);
            return Boolean.valueOf(answer).equals(expectedValue);
        }
        if (IS_GMF_DIAGRAM_CONTEXT_ACTIVE.equals(property) && receiver instanceof Collection) {
            boolean answer = this.isDiagramContextActive((Collection)receiver);
            return Boolean.valueOf(answer).equals(expectedValue);
        }
        if (IS_TEXT_ZONE.equals(property) && receiver instanceof Shell) {
            boolean answer = this.isTextZone((Shell)receiver);
            return Boolean.valueOf(answer).equals(expectedValue);
        }
        if (DIAGRAM_TYPE.equals(property)) {
            String type = this.diagramType(receiver);
            return Objects.equal((Object)type, (Object)expectedValue);
        }
        return false;
    }

    private boolean isTextZone(Shell shell) {
        Control focusControl;
        Display display = shell.getDisplay();
        return display != null && ((focusControl = display.getFocusControl()) instanceof StyledText || focusControl instanceof Text);
    }

    private boolean isDiagramEditor(IStructuredSelection selection) {
        IWorkbenchPart part = WorkbenchPartHelper.getCurrentActiveWorkbenchPart();
        if (part != null) {
            IDiagramWorkbenchPart diagramPart = (IDiagramWorkbenchPart)part.getAdapter(IDiagramWorkbenchPart.class);
            return diagramPart != null;
        }
        return false;
    }

    private boolean isDiagramContextActive(Collection<?> activeContextIds) {
        return activeContextIds.contains("org.eclipse.gmf.runtime.diagram.ui.diagramContext");
    }

    private final String diagramType(Object viewOrAdaptableToView) {
        Diagram diagram;
        String result = null;
        View view = (View)TypeUtils.as((Object)viewOrAdaptableToView, View.class);
        if (view == null) {
            AdapterUtils.adapt((Object)viewOrAdaptableToView, View.class, null);
        }
        if (view != null && (diagram = view.getDiagram()) != null) {
            result = diagram.getType();
        }
        return result;
    }
}

