/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.Theme;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.WorkspaceThemes;

public class WorkspaceThemesHelper {
    public Theme defineCSSStyleSheetFilesAsTheme(IStructuredSelection selection) {
        ArrayList<IFile> selectedCSSFilesList = new ArrayList<IFile>();
        for (Object next : selection) {
            if (!(next instanceof IFile)) continue;
            selectedCSSFilesList.add((IFile)next);
        }
        Theme theme = this.createThemeFromSelection(selectedCSSFilesList);
        theme.setId(EcoreUtil.generateUUID());
        return theme;
    }

    public void saveWorkspaceThemesPreferenceResource(Theme[] editedThemesArray, Theme[] deletedThemesArray) {
        Resource currentThemefile = this.findThemeFile();
        WorkspaceThemes workspaceThemes = this.getWorspaceThemesRoot(currentThemefile);
        Theme[] themeArray = editedThemesArray;
        int n = editedThemesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Theme editedTheme = themeArray[n2];
            boolean updateResult = this.updateWorkspaceTheme(editedTheme, workspaceThemes);
            if (!updateResult) {
                workspaceThemes.getThemes().add((Object)editedTheme);
            }
            ++n2;
        }
        themeArray = deletedThemesArray;
        n = deletedThemesArray.length;
        n2 = 0;
        while (n2 < n) {
            Theme deletedTheme = themeArray[n2];
            this.removeWorkspaceTheme(deletedTheme, workspaceThemes);
            ++n2;
        }
        this.saveResource(currentThemefile);
    }

    private void removeWorkspaceTheme(Theme deletedTheme, WorkspaceThemes workspaceThemes) {
        Iterator currentThemesIterator = workspaceThemes.getThemes().iterator();
        Theme themeId = null;
        boolean found = false;
        while (currentThemesIterator.hasNext() && !found) {
            themeId = (Theme)currentThemesIterator.next();
            found = themeId.getId().equals(deletedTheme.getId());
        }
        if (found) {
            EcoreUtil.remove((EObject)workspaceThemes, (EStructuralFeature)StylesheetsPackage.eINSTANCE.getWorkspaceThemes_Themes(), (Object)themeId);
        }
    }

    public void saveWorkspaceThemesPreferenceResource(Theme editedTheme) {
        Resource currentThemefile = this.findThemeFile();
        WorkspaceThemes workspaceThemes = this.getWorspaceThemesRoot(currentThemefile);
        this.updateWorkspaceTheme(editedTheme, workspaceThemes);
        this.saveResource(currentThemefile);
    }

    private boolean updateWorkspaceTheme(Theme editedTheme, WorkspaceThemes workspaceThemes) {
        Iterator currentThemesIterator = workspaceThemes.getThemes().iterator();
        Theme themeId = null;
        boolean found = false;
        while (currentThemesIterator.hasNext() && !found) {
            themeId = (Theme)currentThemesIterator.next();
            found = themeId.getId().equals(editedTheme.getId());
        }
        if (found) {
            EcoreUtil.replace((EObject)workspaceThemes, (EStructuralFeature)StylesheetsPackage.eINSTANCE.getWorkspaceThemes_Themes(), (Object)themeId, (Object)editedTheme);
        }
        return found;
    }

    private void saveResource(Resource styleSheetsResource) {
        if (styleSheetsResource != null) {
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("id", Boolean.TRUE);
                styleSheetsResource.save(options);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public void saveNewThemeWorkspacePreference(Theme theme) {
        Resource themeFile = theme.eResource();
        if (themeFile == null) {
            themeFile = this.findThemeFile();
        }
        WorkspaceThemes workspaceThemes = this.getWorspaceThemesRoot(themeFile);
        workspaceThemes.getThemes().add((Object)theme);
        this.saveResource(themeFile);
    }

    private Theme createThemeFromSelection(List<IFile> selectedCSSFilesList) {
        StylesheetsFactory styleSheetsFactory = StylesheetsFactory.eINSTANCE;
        Theme newTheme = styleSheetsFactory.createTheme();
        for (IFile cssFile : selectedCSSFilesList) {
            StyleSheetReference styleSheetsReference = styleSheetsFactory.createStyleSheetReference();
            styleSheetsReference.setPath(cssFile.getFullPath().toString());
            newTheme.getStylesheets().add((Object)styleSheetsReference);
        }
        return newTheme;
    }

    private Resource findThemeFile() {
        IPath themeFilePath = this.getThemeWorkspacePreferenceFilePath();
        URI resolvedURI = CommonPlugin.resolve((URI)URI.createFileURI((String)themeFilePath.toOSString()));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = null;
        resource = themeFilePath.toFile().exists() ? resourceSet.getResource(resolvedURI, true) : resourceSet.createResource(resolvedURI);
        return resource;
    }

    public IPath getThemeWorkspacePreferenceFilePath() {
        IPath pluginStatePath = Activator.getDefault().getStateLocation();
        IPath themeFilePath = pluginStatePath.append("theme.xmi");
        return themeFilePath;
    }

    private WorkspaceThemes getWorspaceThemesRoot(Resource workspaceThemesResource) {
        WorkspaceThemes workspaceThemesRoot = (WorkspaceThemes)EcoreUtil.getObjectByType((Collection)workspaceThemesResource.getContents(), (EClassifier)StylesheetsPackage.Literals.WORKSPACE_THEMES);
        if (workspaceThemesRoot == null) {
            workspaceThemesRoot = StylesheetsFactory.eINSTANCE.createWorkspaceThemes();
            workspaceThemesResource.getContents().add((Object)workspaceThemesRoot);
        }
        return workspaceThemesRoot;
    }
}

