/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.infra.tools.Activator;

public class FileUtils {
    public static final String PLATFORM_STRING = "platform";
    public static final String PLUGIN_STRING = "plugin";
    public static final String SLASH_STRING = "/";
    public static final String COLON_STRING = ":";
    public static final String DOT_STRING = ".";
    public static final String TEXT_EXTENSION = "txt";
    public static final String CSV_EXTENSIOn = "csv";
    public static final String UNDERSCORE = "_";
    public static final String LINE_SEPARATOR = "line.separator";

    private FileUtils() {
    }

    public static final String getSystemPropertyLineSeparator() {
        return System.getProperty(LINE_SEPARATOR);
    }

    public static final String getStringFromPlatformFile(String pluginName, String filePath, String fileNameWithExtension) {
        return FileUtils.getStringFromPlatformFile(pluginName, filePath, fileNameWithExtension, System.getProperty(LINE_SEPARATOR));
    }

    public static final String getStringFromPlatformFile(String pluginName, String filePath, String fileNameWithExtension, String lineSeparator) {
        Assert.isNotNull((Object)pluginName);
        Assert.isNotNull((Object)filePath);
        Assert.isNotNull((Object)fileNameWithExtension);
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(PLATFORM_STRING);
        pathBuilder.append(COLON_STRING);
        pathBuilder.append(SLASH_STRING);
        pathBuilder.append(PLUGIN_STRING);
        pathBuilder.append(SLASH_STRING);
        pathBuilder.append(pluginName);
        if (!filePath.startsWith(SLASH_STRING)) {
            pathBuilder.append(SLASH_STRING);
        }
        pathBuilder.append(filePath);
        if (!filePath.endsWith(SLASH_STRING)) {
            pathBuilder.append(SLASH_STRING);
        }
        pathBuilder.append(fileNameWithExtension);
        StringBuilder builder = new StringBuilder();
        try {
            URL url = new URL(pathBuilder.toString());
            InputStream inputStream = url.openConnection().getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            String inputLine = in.readLine();
            while (inputLine != null) {
                builder.append(inputLine);
                inputLine = in.readLine();
                if (inputLine == null) continue;
                builder.append(lineSeparator);
            }
            in.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return builder.toString();
    }
}

