/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.databinding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectionDialog;
import org.eclipse.papyrus.infra.widgets.selectors.UnlimitedNaturalSelector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MultipleCellEditor
extends DialogCellEditor {
    private Object context;
    private IElementSelector selector;
    private EStructuralFeature feature;

    public MultipleCellEditor(Composite composite, Object context, EStructuralFeature feature) {
        super(composite);
        this.context = context;
        this.feature = feature;
    }

    public void setSelector(IElementSelector selector) {
        this.selector = selector;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Collection coll;
        Object value;
        MultipleValueSelectionDialog multipleValueSelectionDialog = new MultipleValueSelectionDialog(cellEditorWindow.getShell(), this.selector);
        multipleValueSelectionDialog.setContextElement(this.context);
        List<Object> result = null;
        if (this.context instanceof EObject && (value = ((EObject)this.context).eGet(this.feature)) != null && value instanceof Collection && !(coll = (Collection)value).isEmpty()) {
            multipleValueSelectionDialog.setInitialSelections(coll.toArray());
            result = new ArrayList<Object>(coll);
        }
        if (this.selector instanceof UnlimitedNaturalSelector) {
            multipleValueSelectionDialog.setLabelProvider((ILabelProvider)new UnlimitedNaturalLabelProvider());
        }
        if (multipleValueSelectionDialog.open() == 0) {
            result = Arrays.asList(multipleValueSelectionDialog.getResult());
        }
        return result;
    }

    private class UnlimitedNaturalLabelProvider
    extends LabelProvider {
        private UnlimitedNaturalLabelProvider() {
        }

        public String getText(Object element) {
            String text = element.toString();
            if ("-1".equals(text)) {
                text = "*";
            }
            return text;
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

