/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.widgets.creation.StringEditionFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueDialog;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.StringCombo;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.TreeCollectionContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.StandardSelector;
import org.eclipse.papyrus.infra.widgets.selectors.StringSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class MultipleStringEditor<T extends StringSelector>
extends MultipleValueEditor<IElementSelector> {
    public MultipleStringEditor(Composite parent, int style) {
        super(parent, style, new StringSelector());
        this.init();
    }

    public MultipleStringEditor(Composite parent, boolean directCreation, boolean directCreatiuonWithTreeViewer, int style) {
        super(parent, style, new StringSelector());
        this.setDirectCreation(directCreation);
        this.setDirectCreationWithTreeViewer(directCreatiuonWithTreeViewer);
        this.init();
    }

    public MultipleStringEditor(Composite parent, int style, boolean multiline) {
        super(parent, style, new StringSelector(multiline), true, false, null);
        this.init();
    }

    public MultipleStringEditor(Composite parent, int style, boolean ordered, boolean unique) {
        super(parent, style, new StringSelector(), ordered, unique, null);
        this.init();
    }

    public MultipleStringEditor(Composite parent, int style, boolean ordered, boolean unique, String label) {
        super(parent, style, new StringSelector(), ordered, unique, label);
        this.init();
    }

    public MultipleStringEditor(Composite parent, int style, T selector, boolean ordered, boolean unique, String label) {
        super(parent, style, selector, ordered, unique, label);
        this.init();
    }

    public MultipleStringEditor(Composite parent, int style, T selector) {
        super(parent, style, selector);
        this.init();
    }

    public MultipleStringEditor(Composite parent, int style, T selector, boolean directCreation, boolean directCreationWithTreeViewer) {
        super(parent, style, selector);
        this.setDirectCreation(directCreation);
        this.setDirectCreationWithTreeViewer(directCreationWithTreeViewer);
        this.init();
    }

    public MultipleStringEditor(Composite parent, int style, T selector, String label) {
        super(parent, style, selector, label);
        this.init();
    }

    public MultipleStringEditor(Composite parent, int style, String label) {
        super(parent, style, new StringSelector(), label);
        this.init();
    }

    @Override
    protected MultipleValueDialog createMultipleValueDialog(Composite parent, IElementSelector selector, boolean ordered, boolean unique, String label) {
        return new MultipleValueDialog(parent.getShell(), selector, label, unique, ordered);
    }

    private void init() {
        this.setFactory(new StringEditionFactory());
    }

    public void setContentProvider(final IStaticContentProvider provider) {
        StandardSelector selector = new StandardSelector(StringCombo.class){

            @Override
            public void createControls(Composite parent) {
                super.createControls(parent);
                ((StringCombo)this.editor).setProviders(provider, null);
            }
        };
        this.setSelector(selector);
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        this.edit.setVisible(!this.isDirectCreationWithTreeViewer());
    }

    @Override
    protected void directCreateObject(Object context) {
        if (this.isDirectCreationWithTreeViewer()) {
            if (this.referenceFactory != null && this.referenceFactory.canCreateObject()) {
                this.getOperationExecutor(context).execute(new Callable<Object>(){

                    @Override
                    public Object call() {
                        Object result = MultipleStringEditor.this.getDefaultValue();
                        if (result != null) {
                            MultipleStringEditor.this.modelProperty.add(result);
                            MultipleStringEditor.this.commit();
                        }
                        return result;
                    }
                }, NLS.bind((String)Messages.MultipleValueEditor_addOperation, (Object)this.labelText));
                this.editNewElement();
            }
        } else {
            super.directCreateObject(context);
        }
    }

    protected void editNewElement() {
        Object object;
        int size;
        Object data = this.tree.getData();
        if (data instanceof List && (size = ((List)data).size()) != 0 && (object = ((List)data).get(size - 1)) != null) {
            this.treeViewer.editElement(object, 0);
        }
    }

    protected Object getDefaultValue() {
        return "New String";
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite compositeTree = factory.createComposite(parent);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        compositeTree.setLayout((Layout)treeColumnLayout);
        this.tree = new Tree(compositeTree, 68354);
        this.tree.addSelectionListener((SelectionListener)this);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)TreeCollectionContentProvider.instance);
        TreeViewerColumn viewerColumn = this.createTreeViewerColumn(this.treeViewer, "Value");
        treeColumnLayout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager(this.treeViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.treeViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 0x100000B || event.eventType == 4;
            }
        };
        int feature = 58;
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)feature);
        viewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.treeViewer){

            protected void setValue(Object element, Object value) {
                Object newValue = MultipleStringEditor.this.getValueToSet(element, value);
                int index = MultipleStringEditor.this.modelProperty.indexOf(element);
                if (element != newValue && newValue != null) {
                    MultipleStringEditor.this.modelProperty.set(index, newValue);
                }
                MultipleStringEditor.this.commit();
            }

            protected Object getValue(Object element) {
                return MultipleStringEditor.this.getEditingValue(element);
            }

            protected CellEditor getCellEditor(Object element) {
                return MultipleStringEditor.this.createCellEditor(element);
            }

            protected boolean canEdit(Object element) {
                return MultipleStringEditor.this.isDirectCreationWithTreeViewer();
            }
        });
        return compositeTree;
    }

    protected TreeViewerColumn createTreeViewerColumn(TreeViewer viewer, String title) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, 2048);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    protected CellEditor createCellEditor(Object element) {
        return new TextCellEditor((Composite)this.tree);
    }

    protected Object getEditingValue(Object element) {
        return element.toString();
    }

    protected Object getValueToSet(Object element, Object value) {
        return value;
    }
}

