/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.directedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.common.ui.contentassist.ContentAssistantHelper;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.tools.DirectEditManagerBase;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.WrapTextCellEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultiLineCellEditor;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

class MultilineLabelDirectEditManagerWrapped
extends DirectEditManagerBase {
    private static IAction copy;
    private static IAction cut;
    private static IAction paste;
    private static IAction undo;
    private static IAction redo;
    private static IAction find;
    private static IAction selectAll;
    private static IAction delete;
    private static IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    protected boolean multiLine = false;
    private GraphicalEditPart source;

    public MultilineLabelDirectEditManagerWrapped(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
        this.source = source;
        if (editorType != null && MultiLineCellEditor.class.isAssignableFrom(editorType)) {
            this.multiLine = true;
        }
    }

    public static Class getTextCellEditorClass(GraphicalEditPart source) {
        IFigure figure = source.getFigure();
        if (figure instanceof IMultilineEditableFigure) {
            return MultiLineCellEditor.class;
        }
        return TextDirectEditManager.getTextCellEditorClass((GraphicalEditPart)source);
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        if (this.multiLine) {
            return new TextCellEditor(composite, 66);
        }
        return super.createCellEditorOn(composite);
    }

    public MultilineLabelDirectEditManagerWrapped(ITextAwareEditPart source) {
        super(source);
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        return MultilineLabelDirectEditManagerWrapped.getCellEditorLocator((ITextAwareEditPart)source);
    }

    protected CellEditor doCreateCellEditorOn(Composite composite) {
        ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
        if (label != null && label.isTextWrapOn()) {
            int style = 66;
            switch (label.getTextJustification()) {
                case 1: {
                    style |= 0x4000;
                    break;
                }
                case 4: {
                    style |= 0x20000;
                    break;
                }
                case 2: {
                    style |= 0x1000000;
                    break;
                }
            }
            return new WrapTextCellEditor(composite, style);
        }
        return new TextCellEditorEx(composite);
    }

    public void setEditText(String toEdit) {
        super.setEditText(toEdit);
        CellEditor cellEditor = this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        Text textControl = (Text)cellEditor.getControl();
        textControl.setSelection(toEdit.length());
    }

    protected void createContentAssistant(Control control, Color proposalPopupForegroundColor, Color proposalPopupBackgroundColor, IContentAssistProcessor processor) {
        ContentAssistantHelper.createTextContentAssistant((Text)((Text)control), (Color)proposalPopupForegroundColor, (Color)proposalPopupBackgroundColor, (IContentAssistProcessor)processor);
    }

    protected void initCellEditor() {
        super.initCellEditor();
        if (this.source instanceof PapyrusLabelEditPart) {
            int alignment = ((PapyrusLabelEditPart)this.source).getTextAlignment();
            Text text = (Text)this.getCellEditor().getControl();
            switch (alignment) {
                case 4: {
                    text.setOrientation(0x4000000);
                    break;
                }
                case 1: {
                    text.setOrientation(0x2000000);
                    break;
                }
                default: {
                    text.setOrientation(0x2000000);
                }
            }
        }
        IActionBars editorActionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        if (actionBars != null) {
            this.restoreSavedActions(editorActionBars);
        }
        this.saveCurrentActions(editorActionBars);
        actionBars = editorActionBars;
        this.actionHandler = new CellEditorActionHandler(actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        actionBars.updateActionBars();
    }

    protected void bringDown() {
        super.bringDown();
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (actionBars != null) {
            this.restoreSavedActions(actionBars);
            actionBars.updateActionBars();
            actionBars = null;
        }
    }

    private void saveCurrentActions(IActionBars _actionBars) {
        copy = _actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        paste = _actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        delete = _actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        selectAll = _actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        cut = _actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        find = _actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        undo = _actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        redo = _actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void restoreSavedActions(IActionBars _actionBars) {
        _actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
        _actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), paste);
        _actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), delete);
        _actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), selectAll);
        _actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), cut);
        _actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), find);
        _actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), undo);
        _actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), redo);
    }
}

