/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.resource.DependencyManager;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.markerlistener.dialogs.DiagnosticDialog;
import org.eclipse.papyrus.infra.ui.util.TransactionUIHelper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.library.IRegisteredLibrary;
import org.eclipse.papyrus.uml.modelrepair.ui.SwitchLibraryContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;

public class SwitchLibraryDialog
extends SelectionDialog {
    private static final int APPLY_ID = 1025;
    private static final String APPLY_LABEL = "Apply";
    private static final int BROWSE_WORKSPACE_ID = 1026;
    private static final int BROWSE_REGISTERED_ID = 1027;
    private ModelSet modelSet;
    private TransactionalEditingDomain editingDomain;
    protected TableViewer viewer;
    protected Table table;
    protected LabelProviderService labelProviderService;
    protected final Map<URI, URI> librariesToEdit = new HashMap<URI, URI>();

    public SwitchLibraryDialog(Shell shell, ModelSet modelSet, TransactionalEditingDomain domain) throws ServiceException {
        super(shell);
        this.modelSet = modelSet;
        this.editingDomain = domain;
        this.labelProviderService = (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)modelSet);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Composite self = new Composite(contents, 0);
        self.setLayout((Layout)new GridLayout(1, false));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        Label descriptionLabel = new Label(self, 64);
        String description = "Select an imported library, then select a new library (either from the workspace, or a registered one).\n";
        description = String.valueOf(description) + "If the libraries are equivalent, the selected library will replace the imported library.\n";
        description = String.valueOf(description) + "Two libraries are equivalent if one is the copy of the other or if you have deployed a workspace library in a plug-in.\n";
        description = String.valueOf(description) + "If a library P' is a copy of a library P, with some modifications, they are also equivalent.";
        descriptionLabel.setText(description);
        descriptionLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Label warningLabel = new Label(self, 64);
        String warning = "Replacing an imported library with a totally different one could result in loss of information.";
        warningLabel.setText(warning);
        warningLabel.setForeground(parent.getDisplay().getSystemColor(4));
        warningLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite buttonsBarComposite = new Composite(self, 0);
        GridLayout buttonsLayout = new GridLayout(0, false);
        buttonsLayout.marginWidth = 0;
        buttonsBarComposite.setLayout((Layout)buttonsLayout);
        buttonsBarComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Button browseWorkspace = this.createButton(buttonsBarComposite, 1026, "", false);
        browseWorkspace.setImage(Activator.getDefault().getImage("icons/Add_12x12.gif"));
        Button browseRegistered = this.createButton(buttonsBarComposite, 1027, "", false);
        browseRegistered.setImage(Activator.getDefault().getImage("org.eclipse.papyrus.uml.modelrepair", "icons/AddReg.gif"));
        this.viewer = new TableViewer(self, 67584);
        this.table = this.viewer.getTable();
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.table, 0);
        nameColumn.setText("Applied Library");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 150, true));
        TableColumn locationColumn = new TableColumn(this.table, 0);
        locationColumn.setText("Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 500, true));
        TableColumn newLocationColumn = new TableColumn(this.table, 0);
        newLocationColumn.setText("New Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 500, true));
        this.viewer.setContentProvider((IContentProvider)new SwitchLibraryContentProvider());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof URI) {
                    URI uri = (URI)element;
                    Resource resource = SwitchLibraryDialog.this.modelSet.getResource(uri, false);
                    if (resource != null) {
                        for (EObject rootElement : resource.getContents()) {
                            if (!(rootElement instanceof Package)) continue;
                            return ((Package)rootElement).getName();
                        }
                    }
                    return uri.toString();
                }
                return super.getText(element);
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)new LibraryColumnsLabelProvider((ILabelProvider)labelProvider));
        this.viewer.setComparator(new ViewerComparator((ILabelProvider)labelProvider){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            {
                this.val$labelProvider = iLabelProvider;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                return Strings.nullToEmpty((String)this.val$labelProvider.getText(e1)).compareTo(Strings.nullToEmpty((String)this.val$labelProvider.getText(e2)));
            }
        });
        this.viewer.setInput((Object)this.modelSet);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SwitchLibraryDialog.this.updateControls();
            }
        });
        this.viewer.getControl().addDisposeListener(new DisposeListener((ILabelProvider)labelProvider){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            {
                this.val$labelProvider = iLabelProvider;
            }

            public void widgetDisposed(DisposeEvent e) {
                this.val$labelProvider.dispose();
            }
        });
        return contents;
    }

    protected void updateControls() {
        String newTitle = "Switch Library Locations";
        if (!this.librariesToEdit.isEmpty()) {
            newTitle = String.valueOf(newTitle) + " *";
        }
        this.getShell().setText(newTitle);
        this.getButton(1025).setEnabled(!this.librariesToEdit.isEmpty());
        boolean enableBrowse = !this.viewer.getSelection().isEmpty();
        this.getButton(1027).setEnabled(enableBrowse);
        this.getButton(1026).setEnabled(enableBrowse);
        this.viewer.refresh();
    }

    protected void setButtonLayoutData(Button button) {
        int buttonId = (Integer)button.getData();
        if (buttonId == 1027 || buttonId == 1026) {
            return;
        }
        super.setButtonLayoutData(button);
    }

    protected void applyPressed() {
        if (this.librariesToEdit.isEmpty()) {
            return;
        }
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain, "Edit package imports"){

            protected void doExecute() {
                final LinkedList allReplacements = new LinkedList();
                final BasicDiagnostic diagnostics = new BasicDiagnostic("org.eclipse.papyrus.uml.modelrepair", 0, "Problems in switching library", null);
                IRunnableWithProgress runnable = TransactionUIHelper.createPrivilegedRunnableWithProgress((TransactionalEditingDomain)SwitchLibraryDialog.this.editingDomain, (IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this).SwitchLibraryDialog.this.librariesToEdit.size());
                        for (Map.Entry<URI, URI> replacementEntry : (this).SwitchLibraryDialog.this.librariesToEdit.entrySet()) {
                            URI targetURI;
                            URI uriToReplace = replacementEntry.getKey();
                            if (uriToReplace.equals(targetURI = replacementEntry.getValue())) continue;
                            Collection result = new DependencyManager((ResourceSet)SwitchLibraryDialog.this.modelSet).updateDependencies(uriToReplace, targetURI, (DiagnosticChain)diagnostics, (IProgressMonitor)subMonitor.newChild(1));
                            allReplacements.addAll(result);
                        }
                        subMonitor.done();
                    }
                });
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Failed to execute library switch."), 2);
                }
                if (allReplacements.isEmpty()) {
                    MessageDialog.openWarning((Shell)SwitchLibraryDialog.this.getShell(), (String)"Switch Libraries", (String)"No library applications were found to update.");
                } else if (diagnostics.getSeverity() > 0) {
                    DiagnosticDialog dialog = new DiagnosticDialog(SwitchLibraryDialog.this.getShell(), "Problems in Switching Libraries", "Some incompatible differences in the target library likely resulted in loss or transformation of data in stereotype applications. Please review the specific details and take any corrective action that may be required.", (Diagnostic)diagnostics, 6);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                }
            }
        });
        this.librariesToEdit.clear();
        this.updateControls();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, APPLY_LABEL, true);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1: {
                if (this.librariesToEdit.isEmpty() || MessageDialog.openQuestion((Shell)this.getShell(), (String)"Switch Libraries", (String)"You have not yet applied the pending library switch(es). Are you sure you want to cancel?")) break;
                return;
            }
            case 1025: {
                this.applyPressed();
                return;
            }
            case 1027: {
                this.browseRegisteredLibraries();
                return;
            }
            case 1026: {
                this.browseWorkspaceLibraries();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        this.updateControls();
        this.getShell().setText("Switch Library Locations");
        this.getShell().setMinimumSize(600, 400);
        this.getShell().pack();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    public boolean close() {
        this.librariesToEdit.clear();
        return super.close();
    }

    protected void browseWorkspaceLibraries() {
        if (this.getSelectedURI() == null) {
            return;
        }
        LinkedHashMap<String, String> extensionFilters = new LinkedHashMap<String, String>();
        extensionFilters.put("*.uml", "UML (*.uml)");
        extensionFilters.put("*", "All (*)");
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle("Browse Workspace");
        dialog.setDescription("Select a library in the workspace.");
        WorkspaceContentProvider workspaceContentProvider = new WorkspaceContentProvider();
        workspaceContentProvider.setExtensionFilters(extensionFilters);
        dialog.setContentProvider((ITreeContentProvider)workspaceContentProvider);
        dialog.setLabelProvider(this.labelProviderService.getLabelProvider());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedFile = result[0];
            if (selectedFile instanceof IFile) {
                IPath filePath = ((IFile)selectedFile).getFullPath();
                URI workspaceURI = URI.createPlatformResourceURI((String)filePath.toString(), (boolean)true);
                this.replaceSelectionWith(workspaceURI);
            }
        }
    }

    protected URI getSelectedURI() {
        Object selectedElement;
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof URI) {
            return (URI)selectedElement;
        }
        return null;
    }

    protected void browseRegisteredLibraries() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle("Browse Registered Libraries");
        dialog.setDescription("Select one of the registered libraries below.");
        dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)new StaticContentProvider((Object[])Registry.getRegisteredLibraries().toArray(new IRegisteredLibrary[0]))));
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IRegisteredLibrary) {
                    IRegisteredLibrary library = (IRegisteredLibrary)element;
                    return library.getImage();
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof IRegisteredLibrary) {
                    IRegisteredLibrary library = (IRegisteredLibrary)element;
                    return library.getName();
                }
                return super.getText(element);
            }
        });
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedElement = result[0];
            if (selectedElement instanceof IRegisteredLibrary) {
                IRegisteredLibrary library = (IRegisteredLibrary)selectedElement;
                this.replaceSelectionWith(library.getUri());
            }
        }
    }

    protected void replaceSelectionWith(URI targetURI) {
        if (!this.getSelectedURI().equals(targetURI)) {
            this.librariesToEdit.put(this.getSelectedURI(), targetURI);
            this.updateControls();
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Nothing changed", (String)"Nothing to change");
        }
    }

    private class LibraryColumnsLabelProvider
    extends ColumnLabelProvider {
        private ILabelProvider defaultLabelProvider;

        public LibraryColumnsLabelProvider(ILabelProvider defaultLabelProvider) {
            this.defaultLabelProvider = defaultLabelProvider;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            URI uri = element instanceof URI ? (URI)element : null;
            switch (cell.getColumnIndex()) {
                case 0: {
                    this.updateName(cell);
                    break;
                }
                case 1: {
                    this.updateLocation(cell, uri);
                    break;
                }
                case 2: {
                    this.updateNewLocation(cell, uri);
                }
            }
        }

        public void updateName(ViewerCell cell) {
            cell.setImage(this.defaultLabelProvider.getImage(cell.getElement()));
            cell.setText(this.defaultLabelProvider.getText(cell.getElement()));
        }

        public void updateLocation(ViewerCell cell, URI uri) {
            String location = "Unknown";
            if (uri != null) {
                location = uri.toString();
            }
            cell.setText(location);
        }

        public void updateNewLocation(ViewerCell cell, URI uri) {
            String location = "";
            if ((uri = SwitchLibraryDialog.this.librariesToEdit.get(uri)) != null) {
                location = uri.toString();
            }
            cell.setText(location);
        }
    }
}

