/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.tree.ModuleExportNode;
import org.eclipse.persistence.internal.libraries.asm.tree.ModuleOpenNode;
import org.eclipse.persistence.internal.libraries.asm.tree.ModuleProvideNode;
import org.eclipse.persistence.internal.libraries.asm.tree.ModuleRequireNode;

public class ModuleNode
extends ModuleVisitor {
    public String name;
    public int access;
    public String version;
    public String mainClass;
    public List<String> packages;
    public List<ModuleRequireNode> requires;
    public List<ModuleExportNode> exports;
    public List<ModuleOpenNode> opens;
    public List<String> uses;
    public List<ModuleProvideNode> provides;

    public ModuleNode(String string, int n, String string2) {
        super(393216);
        this.name = string;
        this.access = n;
        this.version = string2;
    }

    public ModuleNode(int n, String string, int n2, String string2, List<ModuleRequireNode> list, List<ModuleExportNode> list2, List<ModuleOpenNode> list3, List<String> list4, List<ModuleProvideNode> list5) {
        super(n);
        this.name = string;
        this.access = n2;
        this.version = string2;
        this.requires = list;
        this.exports = list2;
        this.opens = list3;
        this.uses = list4;
        this.provides = list5;
        if (this.getClass() != ModuleNode.class) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void visitMainClass(String string) {
        this.mainClass = string;
    }

    @Override
    public void visitPackage(String string) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>(5);
        }
        this.packages.add(string);
    }

    @Override
    public void visitRequire(String string, int n, String string2) {
        if (this.requires == null) {
            this.requires = new ArrayList<ModuleRequireNode>(5);
        }
        this.requires.add(new ModuleRequireNode(string, n, string2));
    }

    @Override
    public void visitExport(String string, int n, String ... stringArray) {
        if (this.exports == null) {
            this.exports = new ArrayList<ModuleExportNode>(5);
        }
        ArrayList<String> arrayList = null;
        if (stringArray != null) {
            arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        this.exports.add(new ModuleExportNode(string, n, arrayList));
    }

    @Override
    public void visitOpen(String string, int n, String ... stringArray) {
        if (this.opens == null) {
            this.opens = new ArrayList<ModuleOpenNode>(5);
        }
        ArrayList<String> arrayList = null;
        if (stringArray != null) {
            arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        this.opens.add(new ModuleOpenNode(string, n, arrayList));
    }

    @Override
    public void visitUse(String string) {
        if (this.uses == null) {
            this.uses = new ArrayList<String>(5);
        }
        this.uses.add(string);
    }

    @Override
    public void visitProvide(String string, String ... stringArray) {
        if (this.provides == null) {
            this.provides = new ArrayList<ModuleProvideNode>(5);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.provides.add(new ModuleProvideNode(string, arrayList));
    }

    @Override
    public void visitEnd() {
    }

    public void accept(ClassVisitor classVisitor) {
        int n;
        ModuleVisitor moduleVisitor = classVisitor.visitModule(this.name, this.access, this.version);
        if (moduleVisitor == null) {
            return;
        }
        if (this.mainClass != null) {
            moduleVisitor.visitMainClass(this.mainClass);
        }
        if (this.packages != null) {
            for (n = 0; n < this.packages.size(); ++n) {
                moduleVisitor.visitPackage(this.packages.get(n));
            }
        }
        if (this.requires != null) {
            for (n = 0; n < this.requires.size(); ++n) {
                this.requires.get(n).accept(moduleVisitor);
            }
        }
        if (this.exports != null) {
            for (n = 0; n < this.exports.size(); ++n) {
                this.exports.get(n).accept(moduleVisitor);
            }
        }
        if (this.opens != null) {
            for (n = 0; n < this.opens.size(); ++n) {
                this.opens.get(n).accept(moduleVisitor);
            }
        }
        if (this.uses != null) {
            for (n = 0; n < this.uses.size(); ++n) {
                moduleVisitor.visitUse(this.uses.get(n));
            }
        }
        if (this.provides != null) {
            for (n = 0; n < this.provides.size(); ++n) {
                this.provides.get(n).accept(moduleVisitor);
            }
        }
    }
}

