/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceElementAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.evaluation.AbstractDispatch;

public abstract class TraceClassAnalysis<@NonNull RA extends PartialRegionAnalysis<@NonNull RA>>
extends TraceElementAnalysis<RA> {
    protected final @NonNull ClassDatum traceClassDatum;
    private @Nullable List<@NonNull Property> discriminatingProperties = null;
    private @NonNull List<@NonNull TraceClassAnalysis<@NonNull RA>> subTraceClassAnalyses = new ArrayList<TraceClassAnalysis<RA>>();
    private @NonNull List<@NonNull TraceClassAnalysis<@NonNull RA>> superTraceClassAnalyses = new ArrayList<TraceClassAnalysis<RA>>();
    private @Nullable Boolean isDispatcher = null;

    public TraceClassAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull ClassDatum traceClassDatum) {
        this.traceClassDatum = traceClassDatum;
        this.subTraceClassAnalyses.add(this);
        this.superTraceClassAnalyses.add(this);
    }

    public void addSubTraceClassAnalysis(@NonNull TraceClassAnalysis<@NonNull RA> traceClassAnalysis) {
        if (!this.subTraceClassAnalyses.contains(traceClassAnalysis)) {
            this.subTraceClassAnalyses.add(traceClassAnalysis);
        }
    }

    public void addSuperTraceClassAnalysis(@NonNull TraceClassAnalysis<@NonNull RA> traceClassAnalysis) {
        if (!this.superTraceClassAnalyses.contains(traceClassAnalysis)) {
            this.superTraceClassAnalyses.add(traceClassAnalysis);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void discriminate() throws CompilerChainException {
        if (this.producers.size() <= 1 || this.consumers.size() <= 1) {
            TransformationPartitioner.DISCRIMINATION.println("Not required for " + this);
            return;
        }
        HashMap<@NonNull PartialRegionAnalysis, @NonNull HashMap<@NonNull K, @NonNull V>> partitioner2property2edge = new HashMap();
        HashSet<@NonNull E> commonProperties = null;
        for (PartialRegionAnalysis producer : this.producers) {
            HashMap<@NonNull Property, @NonNull Iterator<Object>> property2edge = new HashMap<Property, Iterator<Object>>();
            partitioner2property2edge.put(producer, property2edge);
            for (Node traceNode : producer.getTraceNodes()) {
                for (Iterator<Object> edge : traceNode.getRealizedNavigationEdges()) {
                    if (edge.getEdgeTarget().isRealized()) continue;
                    property2edge.put(QVTscheduleUtil.getProperty(edge), edge);
                }
            }
            Set partionerProperties = property2edge.keySet();
            if (commonProperties == null) {
                commonProperties = new HashSet(partionerProperties);
                continue;
            }
            commonProperties.retainAll(partionerProperties);
        }
        if (commonProperties == null || commonProperties.isEmpty()) {
            TransformationPartitioner.DISCRIMINATION.println("No common properties to disambiguate " + this);
            return;
        }
        ArrayList<@NonNull E> sortedProperties = new ArrayList(commonProperties);
        Collections.sort(sortedProperties, NameUtil.NAMEABLE_COMPARATOR);
        HashMap<@NonNull Property, @Nullable HashMap<@Nullable K, @NonNull @NonNull V>> property2completeClass2regionAnalyses = new HashMap();
        for (Property property : sortedProperties) {
            for (PartialRegionAnalysis producer : this.producers) {
                Node targetNode;
                CompleteClass completeClass;
                ArrayList<PartialRegionAnalysis> regionAnalyses;
                @NonNull @NonNull Map property2edge = (Map)partitioner2property2edge.get(producer);
                assert (property2edge != null);
                NavigableEdge edge = (NavigableEdge)property2edge.get(property);
                if (edge == null) {
                    property2completeClass2regionAnalyses.put(property, null);
                    continue;
                }
                HashMap<@Nullable CompleteClass, @NonNull ArrayList<@NonNull PartialRegionAnalysis>> completeClass2regionAnalyses = (HashMap<CompleteClass, ArrayList<PartialRegionAnalysis>>)property2completeClass2regionAnalyses.get(property);
                if (completeClass2regionAnalyses == null) {
                    completeClass2regionAnalyses = new HashMap<CompleteClass, ArrayList<PartialRegionAnalysis>>();
                    property2completeClass2regionAnalyses.put(property, completeClass2regionAnalyses);
                }
                if ((regionAnalyses = (ArrayList<PartialRegionAnalysis>)completeClass2regionAnalyses.get(completeClass = (targetNode = QVTscheduleUtil.getTargetNode((Edge)edge)).isNullLiteral() ? null : targetNode.getCompleteClass())) == null) {
                    regionAnalyses = new ArrayList<PartialRegionAnalysis>();
                    completeClass2regionAnalyses.put(completeClass, regionAnalyses);
                }
                regionAnalyses.add(producer);
            }
        }
        int bestSize = 0;
        Property bestProperty = null;
        for (Property property : property2completeClass2regionAnalyses.keySet()) {
            int size;
            @Nullable @NonNull @NonNull Map completeClass2regionAnalyses = (Map)property2completeClass2regionAnalyses.get(property);
            if (completeClass2regionAnalyses == null || (size = completeClass2regionAnalyses.size()) <= bestSize) continue;
            bestSize = size;
            bestProperty = property;
        }
        if (TransformationPartitioner.DISCRIMINATION.isActive()) {
            StringBuilder s = new StringBuilder();
            s.append("property->completeClass->regionAnalyses");
            for (Property property : property2completeClass2regionAnalyses.keySet()) {
                s.append("\n\t" + property);
                @Nullable @NonNull @NonNull Map completeClass2regionAnalyses = (Map)property2completeClass2regionAnalyses.get(property);
                if (completeClass2regionAnalyses == null) continue;
                for (CompleteClass completeClass : completeClass2regionAnalyses.keySet()) {
                    s.append("\n\t\t" + completeClass);
                    @NonNull List regionAnalyses = (List)completeClass2regionAnalyses.get(completeClass);
                    assert (regionAnalyses != null);
                    for (PartialRegionAnalysis regionAnalysis : regionAnalyses) {
                        s.append("\n\t\t\t" + regionAnalysis);
                    }
                }
            }
            TransformationPartitioner.DISCRIMINATION.println(s.toString());
        }
        if (bestProperty != null) {
            TransformationPartitioner.DISCRIMINATION.println("Best property : " + bestProperty);
            this.discriminatingProperties = Collections.singletonList(bestProperty);
            return;
        }
        throw new CompilerChainException("Unable to disambiguate " + this, new Object[0]);
    }

    public @NonNull ClassDatum getClassDatum() {
        return this.traceClassDatum;
    }

    public @Nullable Iterable<@NonNull Property> getDiscriminatingProperties() {
        return this.discriminatingProperties;
    }

    public String getName() {
        return this.traceClassDatum.getName();
    }

    public @NonNull Iterable<@NonNull TraceClassAnalysis<@NonNull RA>> getSubTraceClassAnalyses() {
        return this.subTraceClassAnalyses;
    }

    public @NonNull Iterable<@NonNull TraceClassAnalysis<@NonNull RA>> getSuperTraceClassAnalyses() {
        return this.superTraceClassAnalyses;
    }

    public @NonNull CompleteClass getTraceClass() {
        return QVTscheduleUtil.getCompleteClass((ClassDatum)this.traceClassDatum);
    }

    public boolean isDispatcher() {
        Boolean isDispatcher2 = this.isDispatcher;
        if (isDispatcher2 == null) {
            String abstractDispatchClassName = AbstractDispatch.class.getName();
            for (Class superClass : QVTbaseUtil.getSuperClasses((Class)QVTscheduleUtil.getCompleteClass((ClassDatum)this.traceClassDatum).getPrimaryClass())) {
                if (!abstractDispatchClassName.equals(superClass.getInstanceClassName())) continue;
                isDispatcher2 = this.isDispatcher = Boolean.valueOf(true);
                return isDispatcher2;
            }
            isDispatcher2 = this.isDispatcher = Boolean.valueOf(false);
        }
        return isDispatcher2;
    }

    public String toString() {
        return this.traceClassDatum.toString();
    }
}

