/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.poll;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.recommenders.internal.news.rcp.NewsRcpPreferences;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.news.rcp.poll.PollFeedsJob;
import org.eclipse.recommenders.news.api.poll.INewsPollingService;

@Creatable
@Singleton
public class PollingManager {
    private final NewsRcpPreferences preferences;
    private final INewsPollingService pollingService;
    private final IEventBroker eventBroker;
    private final Object jobLock = new Object();
    @Nullable
    private Job job;
    private int pollingDelay;

    @Inject
    public PollingManager(NewsRcpPreferences preferences, INewsPollingService pollingService, IEventBroker eventBroker, @Preference(value="pollingDelay") int pollingDelay) {
        this.preferences = preferences;
        this.pollingService = pollingService;
        this.eventBroker = eventBroker;
        this.pollingDelay = pollingDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public void setEnabled(@Preference(value="newsEnabled") boolean enabled) {
        Object object = this.jobLock;
        synchronized (object) {
            if (enabled && this.job == null) {
                this.job = new PollFeedsJob(Messages.JOB_NAME_POLLING_FEEDS, true, this.preferences, this.pollingService, this.eventBroker);
                this.job.setPriority(50);
                this.job.schedule(TimeUnit.MINUTES.toMillis(this.pollingDelay));
            } else if (!enabled && this.job != null) {
                this.job.cancel();
                this.job = null;
            }
        }
    }

    @Inject
    public void updatePollingDelay(@Preference(value="pollingDelay") int pollingDelay) {
        this.pollingDelay = pollingDelay;
    }
}

