/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.recommenders.rcp.utils.SelectionListener;
import org.eclipse.recommenders.rcp.utils.TableComparator;
import org.eclipse.swt.widgets.TableColumn;

public final class TableSortConfigurator {
    private final TableViewer tableViewer;
    private final IAction refreshUiAction;
    private final Map<TableColumn, Comparator<Object>> comparators = new HashMap<TableColumn, Comparator<Object>>();
    private TableColumn initialSortingColumn = null;
    private int initialDirection = 128;

    private TableSortConfigurator(TableViewer tableViewer, IAction refreshUiAction) {
        this.tableViewer = tableViewer;
        this.refreshUiAction = refreshUiAction;
    }

    public static TableSortConfigurator newConfigurator(TableViewer tableViewer, IAction refreshAction) {
        return new TableSortConfigurator(tableViewer, refreshAction);
    }

    public TableSortConfigurator add(TableColumn tableColoumn, Comparator<Object> comparator) {
        this.comparators.put(tableColoumn, comparator);
        return this;
    }

    public TableSortConfigurator initialize(TableColumn tableColoumn, int direction) {
        this.initialSortingColumn = tableColoumn;
        this.initialDirection = direction;
        return this;
    }

    public void configure() {
        TableComparator comparator = new TableComparator(this.tableViewer, this.refreshUiAction, (ImmutableMap<TableColumn, Comparator<Object>>)ImmutableMap.copyOf(this.comparators));
        this.tableViewer.setComparator((ViewerComparator)comparator);
        for (Map.Entry<TableColumn, Comparator<Object>> entry : this.comparators.entrySet()) {
            entry.getKey().addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionListener(entry.getKey(), comparator));
        }
        if (this.initialSortingColumn != null) {
            this.tableViewer.getTable().setSortDirection(this.initialDirection);
            comparator.initial(this.initialSortingColumn, this.initialDirection);
            this.tableViewer.getTable().setSortColumn(this.initialSortingColumn);
            this.refreshUiAction.run();
        }
    }
}

