/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.snipmatch.rcp;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class SnippetEditorInput
implements IEditorInput {
    private final Snippet snippet;
    private ISnippet oldSnippet;
    private ISnippetRepository snippetRepository;

    public SnippetEditorInput(ISnippet snippet) {
        this(snippet, null);
    }

    public SnippetEditorInput(ISnippet snippet, ISnippetRepository snippetRepository) {
        this.oldSnippet = snippet;
        this.snippet = Snippet.copy((ISnippet)snippet);
        this.snippetRepository = snippetRepository;
    }

    public Snippet getSnippet() {
        return this.snippet;
    }

    public ISnippet getOldSnippet() {
        return this.oldSnippet;
    }

    public ISnippetRepository getRepository() {
        return this.snippetRepository;
    }

    public void setRepository(ISnippetRepository repository) {
        this.snippetRepository = repository;
    }

    public boolean exists() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SnippetEditorInput) {
            SnippetEditorInput other = (SnippetEditorInput)obj;
            return this.getOldSnippet().equals(other.getOldSnippet());
        }
        return false;
    }

    public int hashCode() {
        return this.getOldSnippet().hashCode();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.snippet.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return String.valueOf(this.snippet.getName()) + " - " + this.snippet.getDescription();
    }

    public void setOldSnippet(Snippet oldSnippet) {
        this.oldSnippet = oldSnippet;
    }
}

