/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.tree;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.handler.TreeHandler;
import org.eclipse.reddeer.core.handler.TreeItemHandler;
import org.eclipse.reddeer.core.lookup.TreeItemLookup;
import org.eclipse.reddeer.core.matcher.TreeItemTextMatcher;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.condition.TreeItemHasMinChildren;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.swt.widgets.AbstractItem;
import org.eclipse.swt.widgets.TreeItem;
import org.hamcrest.Matcher;

public abstract class AbstractTreeItem
extends AbstractItem<TreeItem>
implements org.eclipse.reddeer.swt.api.TreeItem {
    private static final Logger logger = Logger.getLogger(AbstractTreeItem.class);
    private TreeHandler treeHandler = TreeHandler.getInstance();
    private TreeItemHandler treeItemHandler = TreeItemHandler.getInstance();

    protected AbstractTreeItem(TreeItem swtWidget) {
        super(swtWidget);
    }

    @Override
    public void select() {
        logger.info("Select tree item " + this.getText());
        this.treeItemHandler.select((TreeItem)this.swtWidget);
    }

    @Override
    public String getToolTipText() {
        return TreeItemHandler.getInstance().getToolTipText((TreeItem)this.swtWidget);
    }

    @Override
    public String getCell(int index) {
        return TreeItemHandler.getInstance().getText((TreeItem)this.swtWidget, index);
    }

    @Override
    public String[] getPath() {
        return this.treeItemHandler.getPath((TreeItem)this.swtWidget);
    }

    @Override
    public void expand() {
        this.expand(TimePeriod.SHORT);
    }

    @Override
    public void expand(TimePeriod timePeriod) {
        logger.info("Expand tree item " + this.getText() + " and wait with time period " + timePeriod.getSeconds());
        this.treeItemHandler.expand((TreeItem)this.swtWidget, timePeriod);
    }

    @Override
    public void collapse() {
        logger.info("Collapse tree item " + this.getText());
        this.treeItemHandler.collapse((TreeItem)this.swtWidget);
    }

    @Override
    public org.eclipse.reddeer.swt.api.TreeItem getItem(String text) {
        return new DefaultTreeItem(this.treeItemHandler.getItem((TreeItem)this.swtWidget, text));
    }

    public org.eclipse.reddeer.swt.api.TreeItem getParentItem() {
        TreeItem parentItem = this.treeItemHandler.getParentItem((TreeItem)this.swtWidget);
        if (parentItem == null) {
            return null;
        }
        return new DefaultTreeItem(parentItem);
    }

    @Override
    public org.eclipse.reddeer.swt.api.TreeItem getItem(String ... path) {
        TreeItem swtItem = TreeItemLookup.getInstance().getTreeItem(this.getSWTWidget(), 0, this.createMatchers(path));
        return new DefaultTreeItem(swtItem);
    }

    @Override
    public void doubleClick() {
        logger.info("Double click tree item " + this.getText());
        this.select();
        logger.debug("Notify tree about mouse double click event");
        this.treeHandler.notifyTree(this.getSWTWidget(), this.treeHandler.createEventForTree(this.getSWTWidget(), 8));
        logger.debug("Notify tree about default selection event");
        this.treeHandler.notifyTree(this.getSWTWidget(), this.treeHandler.createEventForTree(this.getSWTWidget(), 14));
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
        logger.debug("Double click successfull");
    }

    @Override
    public boolean isSelected() {
        return this.treeItemHandler.isSelected((TreeItem)this.swtWidget);
    }

    @Override
    public void setChecked(boolean check) {
        logger.info("Check tree item " + this.getText());
        this.treeItemHandler.setChecked((TreeItem)this.swtWidget, check);
    }

    @Override
    public boolean isChecked() {
        return this.treeItemHandler.isChecked((TreeItem)this.swtWidget);
    }

    @Override
    public TreeItem getSWTWidget() {
        return (TreeItem)this.swtWidget;
    }

    @Override
    public List<org.eclipse.reddeer.swt.api.TreeItem> getItems() {
        this.expand(TimePeriod.SHORT);
        LinkedList<org.eclipse.reddeer.swt.api.TreeItem> items = new LinkedList<org.eclipse.reddeer.swt.api.TreeItem>();
        List eclipseItems = this.treeItemHandler.getChildrenItems((TreeItem)this.swtWidget);
        for (TreeItem swtTreeItem : eclipseItems) {
            items.addLast(new DefaultTreeItem(swtTreeItem));
        }
        return items;
    }

    @Override
    public Tree getParent() {
        return new DefaultTree(this.treeItemHandler.getParent((TreeItem)this.swtWidget));
    }

    @Override
    public Control<?> getParentControl() {
        return this.getParent();
    }

    @Override
    public boolean isExpanded() {
        return this.treeItemHandler.isExpanded((TreeItem)this.swtWidget);
    }

    @Override
    public void expand(int minItemsCount) {
        this.expand(minItemsCount, TimePeriod.SHORT);
    }

    @Override
    public void expand(int minItemsCount, TimePeriod timePeriod) {
        logger.info("Expand tree item " + this.getText() + " and wait for at least " + minItemsCount + " items");
        this.expand();
        new WaitUntil((WaitCondition)new TreeItemHasMinChildren(this, minItemsCount), timePeriod);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("TreeItem: ");
        boolean isFirst = true;
        String[] stringArray = this.getPath();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathItem = stringArray[n2];
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(" > ");
            }
            result.append(pathItem);
            ++n2;
        }
        return result.toString();
    }

    @Override
    public void setText(String text, int index) {
        logger.info("Set text to tree item at index " + index + ": " + text);
        TreeItemHandler.getInstance().setText((TreeItem)this.swtWidget, index, text);
    }

    @Override
    public void setText(String text) {
        logger.info("Set text to tree item: " + text);
        TreeItemHandler.getInstance().setText((TreeItem)this.swtWidget, 0, text);
    }

    private Matcher<TreeItem>[] createMatchers(String[] treeItemPath) {
        Matcher[] matchers = new Matcher[treeItemPath.length];
        int i = 0;
        while (i < treeItemPath.length) {
            matchers[i] = new TreeItemTextMatcher(treeItemPath[i]);
            ++i;
        }
        return matchers;
    }

    class TreeItemTexts {
        private String nonStyledText;
        private String[] styledTexts;

        public TreeItemTexts(String nonStyledText, String[] styledTexts) {
            this.nonStyledText = nonStyledText;
            this.styledTexts = styledTexts;
        }

        public String getNonStyledText() {
            return this.nonStyledText;
        }

        public String[] getStyledTexts() {
            return this.styledTexts;
        }
    }
}

