/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.services.DataService;
import org.eclipse.sapphire.util.Filters;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.sapphire.util.SortedSetFactory;

public abstract class PossibleTypesService
extends DataService<Set<ElementType>> {
    private static final Comparator<ElementType> COMPARATOR = new Comparator<ElementType>(){

        @Override
        public int compare(ElementType x, ElementType y) {
            return x.getSimpleName().compareTo(y.getSimpleName());
        }
    };

    @Override
    protected final void initDataService() {
        this.initPossibleTypesService();
    }

    protected void initPossibleTypesService() {
    }

    public final Set<ElementType> types() {
        return (Set)this.data();
    }

    @Override
    protected final Set<ElementType> compute() {
        if (this.ordered()) {
            LinkedHashSet<ElementType> values = new LinkedHashSet<ElementType>();
            this.compute(values);
            return SetFactory.start().filter(Filters.createNotNullFilter()).add((Collection<ElementType>)values).result();
        }
        TreeSet<ElementType> values = new TreeSet<ElementType>(COMPARATOR);
        this.compute(values);
        return SortedSetFactory.start(COMPARATOR).filter(Filters.createNotNullFilter()).add((Collection<ElementType>)values).result();
    }

    protected abstract void compute(Set<ElementType> var1);

    public boolean ordered() {
        return false;
    }
}

