/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Comparator;
import org.eclipse.sapphire.Collation;
import org.eclipse.sapphire.CollationService;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.internal.DefaultCollationService;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class DeclarativeCollationService
extends CollationService {
    private static final Comparator<String> IGNORE_CASE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            return str1.compareToIgnoreCase(str2);
        }
    };
    private FunctionResult ignoreCaseDifferencesFunctionResult;

    @Override
    protected void initCollationService() {
        Function ignoreCaseDifferencesFunction;
        Collation annotation = this.context(PropertyDef.class).getAnnotation(Collation.class);
        try {
            ignoreCaseDifferencesFunction = ExpressionLanguageParser.parse(annotation.ignoreCaseDifferences());
            ignoreCaseDifferencesFunction = FailSafeFunction.create(ignoreCaseDifferencesFunction, Boolean.class, false);
        }
        catch (Exception e) {
            Sapphire.service(LoggingService.class).log(e);
            ignoreCaseDifferencesFunction = Literal.FALSE;
        }
        Element element = this.context(Element.class);
        FunctionContext context = element == null ? new FunctionContext() : new ModelElementFunctionContext(element);
        this.ignoreCaseDifferencesFunctionResult = ignoreCaseDifferencesFunction.evaluate(context);
        this.ignoreCaseDifferencesFunctionResult.attach(new Listener(){

            @Override
            public void handle(Event event) {
                DeclarativeCollationService.this.refresh();
            }
        });
    }

    @Override
    protected Comparator<String> compute() {
        if (((Boolean)this.ignoreCaseDifferencesFunctionResult.value()).booleanValue()) {
            return IGNORE_CASE_COMPARATOR;
        }
        return DefaultCollationService.COMPARATOR;
    }

    public static final class GlobalCondition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Collation collation;
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null && (collation = property.getAnnotation(Collation.class)) != null) {
                return collation.global() || collation.ignoreCaseDifferences().equalsIgnoreCase("true") || collation.ignoreCaseDifferences().equalsIgnoreCase("false");
            }
            return false;
        }
    }

    public static final class InstanceCondition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Collation collation;
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null && (collation = property.getAnnotation(Collation.class)) != null) {
                return !collation.global() && !collation.ignoreCaseDifferences().equalsIgnoreCase("true") && !collation.ignoreCaseDifferences().equalsIgnoreCase("false");
            }
            return false;
        }
    }
}

