/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class IndexFunction
extends Function {
    @Text(value="Cannot determine index if parent is not a list.")
    private static LocalizableText parentNotListMessage;

    static {
        LocalizableText.init(IndexFunction.class);
    }

    @Override
    public String name() {
        return "Index";
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){
            private ElementList<?> list;
            private Listener listener;

            @Override
            protected Object evaluate() {
                Element element = this.operand(0, Element.class, false);
                Property parent = element.parent();
                if (parent instanceof ElementList) {
                    ElementList list = (ElementList)parent;
                    if (this.list != list) {
                        if (this.listener == null) {
                            this.listener = new FilteredListener<PropertyContentEvent>(){

                                @Override
                                protected void handleTypedEvent(PropertyContentEvent event) {
                                    this.refresh();
                                }
                            };
                        } else if (this.list != null) {
                            this.list.detach(this.listener);
                        }
                        this.list = list;
                        this.list.attach(this.listener);
                    }
                    int i = 0;
                    int n = list.size();
                    while (i < n) {
                        if (list.get(i) == element) {
                            return i;
                        }
                        ++i;
                    }
                    return -1;
                }
                if (this.list != null) {
                    this.list.detach(this.listener);
                    this.list = null;
                }
                throw new FunctionException(parentNotListMessage.text());
            }

            @Override
            public void dispose() {
                super.dispose();
                if (this.list != null) {
                    this.list.detach(this.listener);
                    this.list = null;
                }
                this.listener = null;
            }
        };
    }
}

