/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

public final class HashCodeFactory {
    private final int result;

    private HashCodeFactory(int result) {
        this.result = result;
    }

    public static HashCodeFactory start() {
        return new HashCodeFactory(1);
    }

    public HashCodeFactory add(Object object) {
        if (object == null) {
            return this;
        }
        return new HashCodeFactory(this.result ^ object.hashCode());
    }

    public HashCodeFactory add(boolean value) {
        return new HashCodeFactory(this.result ^ (value ? 1231 : 1237));
    }

    public HashCodeFactory add(char value) {
        return new HashCodeFactory(this.result ^ value);
    }

    public HashCodeFactory add(byte value) {
        return new HashCodeFactory(this.result ^ value);
    }

    public HashCodeFactory add(short value) {
        return new HashCodeFactory(this.result ^ value);
    }

    public HashCodeFactory add(int value) {
        return new HashCodeFactory(this.result ^ value);
    }

    public HashCodeFactory add(long value) {
        return new HashCodeFactory(this.result ^ (int)(value ^ value >>> 32));
    }

    public HashCodeFactory add(float value) {
        return new HashCodeFactory(this.result ^ Float.floatToIntBits(value));
    }

    public HashCodeFactory add(double value) {
        long v = Double.doubleToLongBits(value);
        return new HashCodeFactory(this.result ^ (int)(v ^ v >>> 32));
    }

    public int result() {
        return this.result;
    }
}

