/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceEvent;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;

public abstract class DiagramLayoutPersistenceService
extends Service {
    public boolean dirty() {
        return false;
    }

    public abstract DiagramConnectionInfo read(DiagramConnectionPart var1);

    public static class DiagramConnectionInfo {
        private List<Point> bendPoints = new ArrayList<Point>();
        private Point labelPosition;

        public DiagramConnectionInfo(List<Point> bendPoints) {
            this.bendPoints.addAll(bendPoints);
        }

        public DiagramConnectionInfo(List<Point> bendPoints, Point labelPosition) {
            if (bendPoints != null) {
                this.bendPoints.addAll(bendPoints);
            }
            if (labelPosition != null) {
                this.labelPosition = new Point(labelPosition.getX(), labelPosition.getY());
            }
        }

        public List<Point> getBendPoints() {
            return this.bendPoints;
        }

        public Point getLabelPosition() {
            return this.labelPosition;
        }
    }

    public static class DirtyStateEvent
    extends ServiceEvent {
        private final boolean before;
        private final boolean after;

        public DirtyStateEvent(Service service, boolean before, boolean after) {
            super(service);
            this.before = before;
            this.after = after;
        }

        public boolean before() {
            return this.before;
        }

        public boolean after() {
            return this.after;
        }
    }
}

