/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireHotSpotsActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class SapphireMenuActionPresentation
extends SapphireHotSpotsActionPresentation {
    private Menu menu;
    private final Listener actionVisibilityListener = new FilteredListener<SapphireActionSystemPart.VisibilityEvent>(){

        protected void handleTypedEvent(SapphireActionSystemPart.VisibilityEvent event) {
            SapphireMenuActionPresentation.this.render();
        }
    };

    public SapphireMenuActionPresentation(SapphireActionPresentationManager manager) {
        super(manager);
        for (SapphireAction action : manager.getActions()) {
            action.attach(this.actionVisibilityListener);
        }
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    @Override
    public void render() {
        if (this.menu == null) {
            return;
        }
        final SwtPresentation context = (SwtPresentation)this.getManager().context();
        MenuItem[] menuItemArray = this.menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
        boolean first = true;
        String lastGroup = null;
        for (final SapphireAction action : this.getActions()) {
            MenuItem menuItem;
            if (!action.isVisible()) continue;
            String group = action.getGroup();
            if (!first && !MiscUtil.equal(lastGroup, (Object)group)) {
                new MenuItem(this.menu, 2);
            }
            first = false;
            lastGroup = group;
            final List<SapphireActionHandler> handlers = action.getActiveHandlers();
            if (action.getType() == SapphireActionType.PUSH) {
                if (handlers.size() == 1) {
                    menuItem = new MenuItem(this.menu, 8);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            ((SapphireActionHandler)handlers.get(0)).execute(context);
                        }
                    });
                } else {
                    Menu childMenu = new Menu(this.menu);
                    menuItem = new MenuItem(this.menu, 64);
                    menuItem.setMenu(childMenu);
                    for (SapphireActionHandler handler : action.getActiveHandlers()) {
                        this.renderMenuItem(childMenu, handler);
                    }
                }
            } else if (action.getType() == SapphireActionType.TOGGLE) {
                menuItem = new MenuItem(this.menu, 32);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        ((SapphireActionHandler)handlers.get(0)).execute(context);
                    }
                });
            } else {
                throw new IllegalStateException();
            }
            final Runnable updateActionLabelOp = new Runnable(){

                @Override
                public void run() {
                    if (!menuItem.isDisposed()) {
                        menuItem.setText(LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
                    }
                }
            };
            final Runnable updateActionImageOp = new Runnable(){

                @Override
                public void run() {
                    if (!menuItem.isDisposed()) {
                        menuItem.setImage(context.resources().image(action.getImage(16)));
                    }
                }
            };
            final Runnable updateActionEnablementStateOp = new Runnable(){

                @Override
                public void run() {
                    if (!menuItem.isDisposed()) {
                        menuItem.setEnabled(action.isEnabled());
                    }
                }
            };
            final Runnable updateActionCheckedStateOp = new Runnable(){

                @Override
                public void run() {
                    if (!menuItem.isDisposed()) {
                        menuItem.setSelection(action.isChecked());
                    }
                }
            };
            updateActionLabelOp.run();
            updateActionImageOp.run();
            updateActionEnablementStateOp.run();
            updateActionCheckedStateOp.run();
            final Listener listener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphireActionSystemPart.LabelChangedEvent) {
                        updateActionLabelOp.run();
                    } else if (event instanceof SapphireActionSystemPart.ImagesChangedEvent) {
                        updateActionImageOp.run();
                    } else if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                        updateActionEnablementStateOp.run();
                    } else if (event instanceof SapphireActionSystemPart.CheckedStateChangedEvent) {
                        updateActionCheckedStateOp.run();
                    } else if (event instanceof SapphireAction.HandlersChangedEvent) {
                        SapphireMenuActionPresentation.this.render();
                    }
                }
            };
            action.attach(listener);
            menuItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    action.detach(listener);
                }
            });
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphireAction action : this.getManager().getActions()) {
            action.detach(this.actionVisibilityListener);
        }
    }
}

