/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.viewpoint;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.ui.business.internal.viewpoint.ViewpointSelectionCallbackWithConfimationAndDependenciesHandling;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class ViewpointHelper {
    private static Function<? super Viewpoint, ? extends String> getURIFromViewpointFunction = vp -> {
        Option uri = new ViewpointQuery(vp).getViewpointURI();
        String result = null;
        if (uri.some()) {
            result = ((URI)uri.get()).toString();
        }
        return result;
    };
    private static BinaryOperator<Viewpoint> usePluginVersionOverWorkspaceFunction = (vp1, vp2) -> {
        URI uri = vp1.eResource().getURI();
        if (uri.isPlatformResource()) {
            return vp1;
        }
        return vp2;
    };

    private ViewpointHelper() {
    }

    public static boolean isViewpointEnabledInSession(Session session, Viewpoint viewpoint) {
        boolean isViewpointEnabledInSession = false;
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (Viewpoint viewpointTemp : selectedViewpoints) {
            if (!EqualityHelper.areEquals((EObject)viewpoint, (EObject)viewpointTemp)) continue;
            isViewpointEnabledInSession = true;
        }
        return isViewpointEnabledInSession;
    }

    public static Viewpoint getViewpointInVSM(Session session, Viewpoint viewpoint) {
        ViewpointRegistry registry = ViewpointRegistry.getInstance();
        Set viewpoints = registry.getViewpoints();
        for (Viewpoint viewpointTemp : viewpoints) {
            if (!EqualityHelper.areEquals((EObject)viewpoint, (EObject)viewpointTemp)) continue;
            return viewpointTemp;
        }
        return null;
    }

    public static Map<String, Viewpoint> getViewpointDependencies(Collection<Viewpoint> allViewpoints, Collection<Viewpoint> selectedViewpoints, Viewpoint viewpoint) {
        Collector<Viewpoint, ?, Map<? extends String, Viewpoint>> viewpointUriToViewpointMapCollector = Collectors.toMap(getURIFromViewpointFunction, vp -> vp, usePluginVersionOverWorkspaceFunction);
        Map<? extends String, Viewpoint> selectedViewpointUriToViewpoint = selectedViewpoints.stream().collect(viewpointUriToViewpointMapCollector);
        Map<? extends String, Viewpoint> allViewpointUriToViewpoint = allViewpoints.stream().collect(viewpointUriToViewpointMapCollector);
        Set<String> viewpointsURI = selectedViewpointUriToViewpoint.keySet();
        HashMap<String, Viewpoint> missingViewpointDependencies = new HashMap<String, Viewpoint>();
        for (RepresentationExtensionDescription extension : new ViewpointQuery(viewpoint).getAllRepresentationExtensionDescriptions()) {
            String extendedURI = extension.getViewpointURI();
            Pattern pattern = Pattern.compile(extendedURI);
            if (ViewpointHelper.atLeastOneUriMatchesPattern(viewpointsURI, pattern)) continue;
            missingViewpointDependencies.put(extendedURI, allViewpointUriToViewpoint.get(extendedURI));
        }
        return missingViewpointDependencies;
    }

    public static Set<Viewpoint> getAdditionalViewpointsToDeactivate(Viewpoint viewpoint, Session session) {
        HashSet<Viewpoint> viewpointsWithDependency = new HashSet<Viewpoint>();
        HashSet<String> viewpointURISet = new HashSet<String>();
        Option uri = new ViewpointQuery(viewpoint).getViewpointURI();
        String viewpointURIString = null;
        if (uri.some()) {
            viewpointURIString = ((URI)uri.get()).toString();
        }
        viewpointURISet.add(viewpointURIString);
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (Viewpoint selectedViewpoint : selectedViewpoints) {
            if (EqualityHelper.areEquals((EObject)selectedViewpoint, (EObject)viewpoint)) continue;
            for (RepresentationExtensionDescription extension : new ViewpointQuery(selectedViewpoint).getAllRepresentationExtensionDescriptions()) {
                String extendedURI = extension.getViewpointURI();
                Pattern pattern = Pattern.compile(extendedURI);
                if (!ViewpointHelper.atLeastOneUriMatchesPattern(viewpointURISet, pattern)) continue;
                viewpointsWithDependency.add(selectedViewpoint);
            }
        }
        return viewpointsWithDependency;
    }

    public static boolean atLeastOneUriMatchesPattern(Set<String> selectedURIs, Pattern pattern) {
        for (String uriToMatch : selectedURIs) {
            Matcher matcher = pattern.matcher(uriToMatch);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public static void applyNewViewpointSelection(Map<Viewpoint, Boolean> originalMap, Map<Viewpoint, Boolean> newMap, final Session session, final boolean createNewRepresentations, final ViewpointSelection.Callback callback) {
        if (originalMap.size() != newMap.size()) {
            throw new IllegalArgumentException(Messages.ViewpointSelection_viewpointsMapNotReused);
        }
        final HashSet<Viewpoint> newSelectedViewpoints = new HashSet<Viewpoint>();
        final HashSet<Viewpoint> newDeselectedViewpoints = new HashSet<Viewpoint>();
        Iterator<Map.Entry<Viewpoint, Boolean>> originalIterator = originalMap.entrySet().iterator();
        Iterator<Map.Entry<Viewpoint, Boolean>> newIterator = newMap.entrySet().iterator();
        while (originalIterator.hasNext() && newIterator.hasNext()) {
            Map.Entry<Viewpoint, Boolean> originalEntry = originalIterator.next();
            Map.Entry<Viewpoint, Boolean> newEntry = newIterator.next();
            if (!(originalEntry.getValue() ^ newEntry.getValue())) continue;
            if (newEntry.getValue().booleanValue()) {
                newSelectedViewpoints.add(originalEntry.getKey());
                continue;
            }
            newDeselectedViewpoints.add(originalEntry.getKey());
        }
        if (!newSelectedViewpoints.isEmpty() || !newDeselectedViewpoints.isEmpty()) {
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        ChangeViewpointSelectionCommand command = new ChangeViewpointSelectionCommand(session, callback, newSelectedViewpoints, newDeselectedViewpoints, createNewRepresentations, monitor);
                        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
                        domain.getCommandStack().execute((Command)command);
                    }
                };
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, runnable);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Collection<Viewpoint> getAvailableViewpoints(final Session session) {
        ViewpointRegistry registry = ViewpointRegistry.getInstance();
        return Collections2.filter((Collection)registry.getViewpoints(), (Predicate)new Predicate<Viewpoint>(){

            public boolean apply(Viewpoint viewpoint) {
                for (String ext : ViewpointHelper.getSemanticFileExtensionsFromSession(session)) {
                    if (!new ViewpointQuery(viewpoint).handlesSemanticModelExtension(ext)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static Collection<String> getSemanticFileExtensionsFromSession(Session theSession) {
        HashSet<String> extensions = new HashSet<String>();
        for (Resource resource : theSession.getSemanticResources()) {
            String currentFileExtension;
            if (resource == null || resource.getURI() == null || (currentFileExtension = resource.getURI().fileExtension()) == null) continue;
            extensions.add(currentFileExtension);
        }
        return extensions;
    }

    public static Image getImage(Viewpoint viewpoint) {
        ImageDescriptor desc;
        Image image = null;
        if (viewpoint.getIcon() != null && viewpoint.getIcon().length() > 0 && (desc = SiriusEditPlugin.Implementation.findImageDescriptor(viewpoint.getIcon())) != null) {
            image = SiriusEditPlugin.getPlugin().getImage(desc);
            image = ViewpointHelper.getEnhancedImage(image, viewpoint);
        }
        if (image == null) {
            image = SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.getPlugin().getItemImageDescriptor(viewpoint));
            image = ViewpointHelper.getEnhancedImage(image, viewpoint);
        }
        return image;
    }

    public static void handleViewpointActivation(Session session, Set<Viewpoint> viewpointsToHandle, boolean activateViewpoint, boolean askUserForDependencyActivation) {
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        TreeMap<Viewpoint, Boolean> originalViewpointsMap = new TreeMap<Viewpoint, Boolean>((Comparator<Viewpoint>)new ViewpointRegistry.ViewpointComparator());
        Collection<Viewpoint> availableViewpoints = ViewpointHelper.getAvailableViewpoints(session);
        for (Viewpoint viewpoint : availableViewpoints) {
            boolean selected = false;
            for (Viewpoint selectedViewpoint : selectedViewpoints) {
                if (!EqualityHelper.areEquals((EObject)selectedViewpoint, (EObject)viewpoint)) continue;
                selected = true;
                break;
            }
            originalViewpointsMap.put(viewpoint, selected);
        }
        TreeMap<Viewpoint, Boolean> newViewpointToSelectionStateMap = new TreeMap<Viewpoint, Boolean>((Comparator<Viewpoint>)new ViewpointRegistry.ViewpointComparator());
        newViewpointToSelectionStateMap.putAll(originalViewpointsMap);
        for (Viewpoint viewpoint : viewpointsToHandle) {
            newViewpointToSelectionStateMap.put(viewpoint, activateViewpoint);
        }
        Display.getCurrent().syncExec(() -> ViewpointHelper.applyNewViewpointSelection(originalViewpointsMap, newViewpointToSelectionStateMap, session, true, new ViewpointSelectionCallbackWithConfimationAndDependenciesHandling(askUserForDependencyActivation)));
    }

    private static Image getEnhancedImage(Image image, Viewpoint viewpoint) {
        if (!ViewpointRegistry.getInstance().isFromPlugin(viewpoint) && image != null) {
            return SiriusEditPlugin.getPlugin().getImage(ViewpointHelper.getOverlayedDescriptor(image, "icons/full/decorator/folder_close.gif"));
        }
        return image;
    }

    private static ImageDescriptor getOverlayedDescriptor(Image baseImage, String decoratorPath) {
        ImageDescriptor decoratorDescriptor = SiriusEditPlugin.Implementation.getBundledImageDescriptor(decoratorPath);
        return new DecorationOverlayIcon(baseImage, decoratorDescriptor, 2);
    }
}

