/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Diff;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.ClipboardDiffOperation;
import org.eclipse.team.internal.ccvs.ui.operations.FileDiffOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.operations.WorkspaceFileDiffOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.CreatePatchWizardParticipant;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceSynchronizeParticipant;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ParticipantPagePane;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class GenerateDiffFileWizard
extends Wizard {
    private static final int INITIAL_WIDTH = 300;
    private static final int INITIAL_HEIGHT = 350;
    private LocationPage locationPage;
    private OptionsPage optionsPage;
    protected IResource[] resources;
    private final DefaultValuesStore defaultValuesStore;
    private final IWorkbenchPart part;
    protected boolean unifiedSelectionEnabled;

    public static void run(IWorkbenchPart part, IResource[] resources, boolean unifiedSelectionEnabled) {
        String title = CVSUIMessages.GenerateCVSDiff_title;
        GenerateDiffFileWizard wizard = new GenerateDiffFileWizard(part, resources, unifiedSelectionEnabled);
        wizard.setWindowTitle(title);
        WizardDialog dialog = new WizardDialog(part.getSite().getShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(300, 350);
        dialog.open();
    }

    public static void run(IWorkbenchPart part, IResource[] resources) {
        GenerateDiffFileWizard.run(part, resources, true);
    }

    public GenerateDiffFileWizard(IWorkbenchPart part, IResource[] resources, boolean unifiedSelectionEnabled) {
        this.part = part;
        this.resources = resources;
        this.setWindowTitle(CVSUIMessages.GenerateCVSDiff_title);
        this.initializeDefaultPageImageDescriptor();
        this.defaultValuesStore = new DefaultValuesStore();
        this.unifiedSelectionEnabled = unifiedSelectionEnabled;
    }

    public void addPages() {
        String pageTitle = CVSUIMessages.GenerateCVSDiff_pageTitle;
        String pageDescription = CVSUIMessages.GenerateCVSDiff_pageDescription;
        this.locationPage = new LocationPage(pageTitle, pageTitle, CVSUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.png"), this.defaultValuesStore);
        this.locationPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.locationPage);
        pageTitle = CVSUIMessages.Advanced_options_19;
        pageDescription = CVSUIMessages.Configure_the_options_used_for_the_CVS_diff_command_20;
        this.optionsPage = new OptionsPage(pageTitle, pageTitle, CVSUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.png"), this.defaultValuesStore);
        this.optionsPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.optionsPage);
    }

    protected void initializeDefaultPageImageDescriptor() {
        try {
            URL installURL = CVSUIPlugin.getPlugin().getBundle().getEntry("/");
            URL url = new URL(installURL, "icons/full/wizards/newconnect_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        IFile binFile;
        File file;
        int location = this.locationPage.getSelectedLocation();
        File file2 = file = location != 1 ? this.locationPage.getFile() : null;
        if (file != null && !this.validateFile(file)) {
            return false;
        }
        boolean multiPatch = false;
        if (this.optionsPage.unifiedDiffOption.getSelection() && this.optionsPage.unified_workspaceRelativeOption.getSelection()) {
            multiPatch = true;
        }
        boolean useProjectRelativePaths = false;
        if (this.optionsPage.unifiedDiffOption.getSelection() && this.optionsPage.unified_projectRelativeOption.getSelection()) {
            useProjectRelativePaths = true;
        }
        if ((binFile = this.locationPage.findBinaryFile()) != null) {
            int result = this.promptToIncludeBinary(binFile);
            if (result == 2) {
                return false;
            }
            if (result == 1) {
                this.locationPage.removeBinaryFiles();
            }
        }
        try {
            if (file != null) {
                this.generateDiffToFile(file, multiPatch, useProjectRelativePaths);
            } else {
                this.generateDiffToClipboard(multiPatch, useProjectRelativePaths);
            }
        }
        catch (TeamException teamException) {}
        switch (location) {
            case 3: {
                String workspaceResource = this.locationPage.getWorkspaceLocation();
                if (workspaceResource != null) {
                    this.defaultValuesStore.storeLocationSelection(3);
                    this.defaultValuesStore.storeWorkspacePath(workspaceResource);
                    break;
                }
                this.defaultValuesStore.storeLocationSelection(1);
                break;
            }
            case 2: {
                this.defaultValuesStore.storeFilesystemPath(file.getPath());
                this.defaultValuesStore.storeLocationSelection(2);
                break;
            }
            case 1: {
                this.defaultValuesStore.storeLocationSelection(1);
                break;
            }
            default: {
                return false;
            }
        }
        this.defaultValuesStore.storeOutputFormat(this.optionsPage.getFormatSelection());
        this.defaultValuesStore.storePatchRoot(this.optionsPage.getRootSelection());
        return true;
    }

    private int promptToIncludeBinary(IFile file) {
        MessageDialog dialog = new MessageDialog(this.getShell(), CVSUIMessages.GenerateDiffFileWizard_11, null, NLS.bind((String)CVSUIMessages.GenerateDiffFileWizard_12, (Object)file.getFullPath()), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        return dialog.open();
    }

    private void generateDiffToClipboard(boolean multiPatch, boolean useProjectRelativePaths) throws TeamException {
        ClipboardDiffOperation diffop = new ClipboardDiffOperation(this.part, RepositoryProviderOperation.asResourceMappers(this.resources, 0), this.optionsPage.getOptions(), multiPatch, useProjectRelativePaths, this.optionsPage.patchRoot);
        try {
            diffop.run();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    private void generateDiffToFile(File file, boolean multiPatch, boolean useProjectRelativePaths) throws TeamException {
        FileDiffOperation diffop = null;
        diffop = this.locationPage.selectedLocation == 3 ? new WorkspaceFileDiffOperation(this.part, RepositoryProviderOperation.asResourceMappers(this.resources, 0), this.optionsPage.getOptions(), file, multiPatch, useProjectRelativePaths, this.optionsPage.patchRoot) : new FileDiffOperation(this.part, RepositoryProviderOperation.asResourceMappers(this.resources, 0), this.optionsPage.getOptions(), file, multiPatch, useProjectRelativePaths, this.optionsPage.patchRoot);
        try {
            diffop.run();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean validateFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.canWrite()) {
            String title = CVSUIMessages.GenerateCVSDiff_1;
            String msg = CVSUIMessages.GenerateCVSDiff_2;
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, msg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            return false;
        }
        String title = CVSUIMessages.GenerateCVSDiff_overwriteTitle;
        String msg = CVSUIMessages.GenerateCVSDiff_overwriteMsg;
        MessageDialog dialog = new MessageDialog(this.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        dialog.open();
        return dialog.getReturnCode() == 0;
    }

    public LocationPage getLocationPage() {
        return this.locationPage;
    }

    private final class DefaultValuesStore {
        private static final String PREF_LAST_SELECTION = "org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard.PatchFileSelectionPage.lastselection";
        private static final String PREF_LAST_FS_PATH = "org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard.PatchFileSelectionPage.filesystem.path";
        private static final String PREF_LAST_WS_PATH = "org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard.PatchFileSelectionPage.workspace.path";
        private static final String PREF_LAST_AO_FORMAT = "org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard.OptionsPage.diff.format";
        private static final String PREF_LAST_AO_ROOT = "org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard.OptionsPage.patch.root";
        private final IDialogSettings dialogSettings = CVSUIPlugin.getPlugin().getDialogSettings();

        public int getLocationSelection() {
            int value = 1;
            try {
                value = this.dialogSettings.getInt(PREF_LAST_SELECTION);
            }
            catch (NumberFormatException numberFormatException) {}
            switch (value) {
                case 1: 
                case 2: 
                case 3: {
                    return value;
                }
            }
            return 1;
        }

        public String getFilesystemPath() {
            String path = this.dialogSettings.get(PREF_LAST_FS_PATH);
            return path != null ? path : "";
        }

        public String getWorkspacePath() {
            String path = this.dialogSettings.get(PREF_LAST_WS_PATH);
            return path != null ? path : "";
        }

        public int getFormatSelection() {
            int value = 1;
            try {
                value = this.dialogSettings.getInt(PREF_LAST_AO_FORMAT);
            }
            catch (NumberFormatException numberFormatException) {}
            switch (value) {
                case 1: 
                case 2: 
                case 3: {
                    return value;
                }
            }
            return 1;
        }

        public int getRootSelection() {
            int value = 1;
            try {
                value = this.dialogSettings.getInt(PREF_LAST_AO_ROOT);
            }
            catch (NumberFormatException numberFormatException) {}
            switch (value) {
                case 1: 
                case 2: 
                case 3: {
                    return value;
                }
            }
            return 1;
        }

        public void storeLocationSelection(int defaultSelection) {
            this.dialogSettings.put(PREF_LAST_SELECTION, defaultSelection);
        }

        public void storeFilesystemPath(String path) {
            this.dialogSettings.put(PREF_LAST_FS_PATH, path);
        }

        public void storeWorkspacePath(String path) {
            this.dialogSettings.put(PREF_LAST_WS_PATH, path);
        }

        public void storeOutputFormat(int selection) {
            this.dialogSettings.put(PREF_LAST_AO_FORMAT, selection);
        }

        public void storePatchRoot(int selection) {
            this.dialogSettings.put(PREF_LAST_AO_ROOT, selection);
        }
    }

    public class LocationPage
    extends WizardPage {
        public static final int CLIPBOARD = 1;
        public static final int FILESYSTEM = 2;
        public static final int WORKSPACE = 3;
        private Button cpRadio;
        private Button fsRadio;
        protected Text fsPathText;
        private Button fsBrowseButton;
        private boolean fsBrowsed;
        private Button wsRadio;
        protected Text wsPathText;
        private Button wsBrowseButton;
        private boolean wsBrowsed;
        protected CreatePatchWizardParticipant fParticipant;
        private Button chgSelectAll;
        private Button chgDeselectAll;
        protected boolean canValidate;
        protected boolean pageValid;
        protected IContainer wsSelectedContainer;
        protected IPath[] foldersToCreate;
        protected int selectedLocation;
        private final DefaultValuesStore store;
        private ParticipantPagePane fPagePane;
        private PageBook bottomChild;
        private ISynchronizePageConfiguration fConfiguration;

        LocationPage(String pageName, String title, ImageDescriptor image, DefaultValuesStore store) {
            super(pageName, title, image);
            this.fsBrowsed = false;
            this.wsBrowsed = false;
            this.setPageComplete(false);
            this.store = store;
            this.canValidate = false;
        }

        protected boolean validatePage() {
            if (!this.canValidate) {
                return false;
            }
            switch (this.selectedLocation) {
                case 3: {
                    this.pageValid = this.validateWorkspaceLocation();
                    break;
                }
                case 2: {
                    this.pageValid = this.validateFilesystemLocation();
                    break;
                }
                case 1: {
                    this.pageValid = true;
                }
            }
            GenerateDiffFileWizard.this.resources = this.getSelectedResources();
            if (GenerateDiffFileWizard.this.resources.length == 0) {
                this.pageValid = false;
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_noChangesSelected);
            }
            if (this.pageValid) {
                this.setMessage(null);
                this.setErrorMessage(null);
            }
            this.setPageComplete(this.pageValid);
            return this.pageValid;
        }

        private boolean validateFilesystemLocation() {
            String pathString = this.fsPathText.getText().trim();
            if (pathString.length() == 0 || !new Path("").isValidPath(pathString)) {
                if (this.fsBrowsed) {
                    this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_0);
                } else {
                    this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_browseFilesystem);
                }
                return false;
            }
            File file = new File(pathString);
            if (!file.isAbsolute()) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_0);
                return false;
            }
            if (file.isDirectory()) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_2);
                return false;
            }
            if (pathString.endsWith("/") || pathString.endsWith("\\")) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_3);
                return false;
            }
            File parent = file.getParentFile();
            if (!parent.exists() || !parent.isDirectory()) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_3);
                return false;
            }
            return true;
        }

        private boolean validateWorkspaceLocation() {
            if (this.wsPathText.getText().equals("")) {
                if (this.selectedLocation == 3 && this.wsBrowsed) {
                    this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_5);
                } else {
                    this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_4);
                }
                return false;
            }
            Path pathToWorkspaceFile = new Path(this.wsPathText.getText());
            IStatus status = ResourcesPlugin.getWorkspace().validatePath(this.wsPathText.getText(), 1);
            if (status.isOK()) {
                IPath containerPath = pathToWorkspaceFile.removeLastSegments(1);
                IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath);
                if (container == null) {
                    if (this.selectedLocation == 3) {
                        this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_4);
                    }
                    return false;
                }
                if (!container.isAccessible()) {
                    if (this.selectedLocation == 3) {
                        this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_ProjectClosed);
                    }
                    return false;
                }
                if (ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)pathToWorkspaceFile).exists()) {
                    this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_FolderExists);
                    return false;
                }
            } else {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            return true;
        }

        public File getFile() {
            if (this.pageValid && this.selectedLocation == 2) {
                return new File(this.fsPathText.getText().trim());
            }
            if (this.pageValid && this.selectedLocation == 3) {
                String filename = this.wsPathText.getText().trim();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFile((IPath)new Path(filename));
                return file.getLocation().toFile();
            }
            return null;
        }

        public String getWorkspaceLocation() {
            if (this.pageValid && this.selectedLocation == 3) {
                String filename = this.wsPathText.getText().trim();
                return filename;
            }
            return null;
        }

        public IResource getResource() {
            if (this.pageValid && this.selectedLocation == 3) {
                Path pathToWorkspaceFile = new Path(this.wsPathText.getText().trim());
                IPath containerPath = pathToWorkspaceFile.removeLastSegments(1);
                return ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath);
            }
            return null;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.setControl((Control)composite);
            this.initializeDialogUnits((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.patch_selection_page_context");
            this.setupLocationControls(composite);
            this.initializeDefaultValues();
            this.fParticipant = new CreatePatchWizardParticipant((ISynchronizeScope)new ResourceScope(((GenerateDiffFileWizard)this.getWizard()).resources), (GenerateDiffFileWizard)this.getWizard());
            try {
                this.getAllOutOfSync();
            }
            catch (CVSException cVSException) {}
            PixelConverter converter = new PixelConverter((Control)parent);
            this.createChangesArea(composite, converter);
            this.createSelectionButtons(composite);
            Dialog.applyDialogFont((Control)parent);
            this.validatePage();
            this.updateEnablements();
            this.setupListeners();
        }

        private void createSelectionButtons(Composite composite) {
            Composite buttonGroup = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            buttonGroup.setLayout((Layout)layout);
            GridData data = new GridData(132);
            buttonGroup.setLayoutData((Object)data);
            this.chgSelectAll = this.createSelectionButton(CVSUIMessages.GenerateDiffFileWizard_SelectAll, buttonGroup);
            this.chgDeselectAll = this.createSelectionButton(CVSUIMessages.GenerateDiffFileWizard_DeselectAll, buttonGroup);
        }

        private Button createSelectionButton(String buttonName, Composite buttonGroup) {
            Button button = new Button(buttonGroup, 8);
            button.setText(buttonName);
            GridData data = new GridData(256);
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            Point minSize = button.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            button.setLayoutData((Object)data);
            return button;
        }

        private void setupLocationControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(768));
            GridData gd = new GridData(32);
            gd.horizontalSpan = 3;
            this.cpRadio = new Button(composite, 16);
            this.cpRadio.setText(CVSUIMessages.Save_To_Clipboard_2);
            this.cpRadio.setLayoutData((Object)gd);
            this.fsRadio = new Button(composite, 16);
            this.fsRadio.setText(CVSUIMessages.Save_In_File_System_3);
            this.fsPathText = new Text(composite, 2048);
            gd = new GridData(768);
            this.fsPathText.setLayoutData((Object)gd);
            this.fsBrowseButton = new Button(composite, 8);
            this.fsBrowseButton.setText(CVSUIMessages.Browse____4);
            GridData data = new GridData(256);
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            Point minSize = this.fsBrowseButton.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            this.fsBrowseButton.setLayoutData((Object)data);
            this.wsRadio = new Button(composite, 16);
            this.wsRadio.setText(CVSUIMessages.Save_In_Workspace_7);
            this.wsPathText = new Text(composite, 2048);
            gd = new GridData(768);
            this.wsPathText.setLayoutData((Object)gd);
            this.wsBrowseButton = new Button(composite, 8);
            this.wsBrowseButton.setText(CVSUIMessages.Browse____4);
            data = new GridData(256);
            widthHint = this.convertHorizontalDLUsToPixels(61);
            minSize = this.fsBrowseButton.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            this.wsBrowseButton.setLayoutData((Object)data);
            ((GridData)this.cpRadio.getLayoutData()).heightHint = minSize.y;
        }

        private void createChangesArea(Composite parent, PixelConverter converter) {
            int size = this.fParticipant.getSyncInfoSet().size();
            if (size > this.getFileDisplayThreshold()) {
                this.bottomChild = new PageBook(parent, 0);
                this.bottomChild.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)false));
                Composite changeDesc = new Composite((Composite)this.bottomChild, 0);
                changeDesc.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)0));
                SWTUtils.createLabel((Composite)changeDesc, (String)NLS.bind((String)CVSUIMessages.CommitWizardCommitPage_1, (Object[])new String[]{Integer.toString(size), Integer.toString(this.getFileDisplayThreshold())}));
                Button showChanges = new Button(changeDesc, 8);
                showChanges.setText(CVSUIMessages.CommitWizardCommitPage_5);
                showChanges.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LocationPage.this.showChangesPane();
                    }
                });
                showChanges.setLayoutData((Object)new GridData());
                this.bottomChild.showPage((Control)changeDesc);
            } else {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)0));
                composite.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)true));
                this.createPlaceholder(composite);
                Control c = this.createChangesPage(composite, this.fParticipant);
                c.setLayoutData((Object)SWTUtils.createHVFillGridData());
            }
        }

        protected void showChangesPane() {
            Control c = this.createChangesPage((Composite)this.bottomChild, this.fParticipant);
            this.bottomChild.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)true));
            this.bottomChild.showPage(c);
            Dialog.applyDialogFont((Control)this.getControl());
            ((Composite)this.getControl()).layout();
        }

        private Control createChangesPage(Composite composite, WorkspaceSynchronizeParticipant participant) {
            this.fConfiguration = participant.createPageConfiguration();
            this.fPagePane = new ParticipantPagePane(this.getShell(), true, this.fConfiguration, (ISynchronizeParticipant)participant);
            Control control = this.fPagePane.createPartControl(composite);
            return control;
        }

        public void dispose() {
            if (this.fPagePane != null) {
                this.fPagePane.dispose();
            }
            if (this.fParticipant != null) {
                this.fParticipant.dispose();
            }
            super.dispose();
        }

        private int getFileDisplayThreshold() {
            return CVSUIPlugin.getPlugin().getPreferenceStore().getInt("pref_commit_files_display_threshold");
        }

        private void createPlaceholder(Composite composite) {
            Composite placeholder = new Composite(composite, 0);
            placeholder.setLayoutData((Object)new GridData(-1, this.convertHorizontalDLUsToPixels(4) / 3));
        }

        private void initializeDefaultValues() {
            this.selectedLocation = this.store.getLocationSelection();
            this.updateRadioButtons();
            this.wsPathText.setText(this.store.getWorkspacePath());
            if (!this.validateWorkspaceLocation()) {
                this.wsPathText.setText("");
                if (this.selectedLocation == 3) {
                    this.setErrorMessage(null);
                    this.selectedLocation = 1;
                    this.updateRadioButtons();
                }
            }
            this.fsPathText.setText(this.store.getFilesystemPath());
            if (!this.validateFilesystemLocation()) {
                this.fsPathText.setText("");
                if (this.selectedLocation == 2) {
                    this.setErrorMessage(null);
                    this.selectedLocation = 1;
                    this.updateRadioButtons();
                }
            }
        }

        private void updateRadioButtons() {
            this.cpRadio.setSelection(this.selectedLocation == 1);
            this.fsRadio.setSelection(this.selectedLocation == 2);
            this.wsRadio.setSelection(this.selectedLocation == 3);
        }

        private void setupListeners() {
            Viewer viewer;
            this.cpRadio.addListener(13, event -> {
                this.selectedLocation = 1;
                this.validatePage();
                this.updateEnablements();
            });
            this.fsRadio.addListener(13, event -> {
                this.selectedLocation = 2;
                this.validatePage();
                this.updateEnablements();
            });
            this.wsRadio.addListener(13, event -> {
                this.selectedLocation = 3;
                this.validatePage();
                this.updateEnablements();
            });
            ModifyListener pathTextModifyListener = e -> {
                boolean bl = this.validatePage();
            };
            this.fsPathText.addModifyListener(pathTextModifyListener);
            this.wsPathText.addModifyListener(pathTextModifyListener);
            this.fsBrowseButton.addListener(13, event -> {
                FileDialog dialog = new FileDialog(this.getShell(), 40960);
                if (this.pageValid) {
                    File file = new File(this.fsPathText.getText());
                    dialog.setFilterPath(file.getParent());
                }
                dialog.setText(CVSUIMessages.Save_Patch_As_5);
                dialog.setFileName(CVSUIMessages.patch_txt_6);
                String path = dialog.open();
                this.fsBrowsed = true;
                if (path != null) {
                    this.fsPathText.setText(new Path(path).toOSString());
                }
                this.validatePage();
            });
            this.wsBrowseButton.addListener(13, event -> {
                WorkspaceDialog dialog = new WorkspaceDialog(this.getShell());
                this.wsBrowsed = true;
                dialog.open();
                this.validatePage();
            });
            this.chgSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocationPage.this.initCheckedItems();
                    if (!LocationPage.this.isPageComplete()) {
                        LocationPage.this.setPageComplete(LocationPage.this.validatePage());
                    }
                }
            });
            this.chgDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Viewer viewer;
                    ISynchronizePage page = LocationPage.this.fConfiguration.getPage();
                    if (page != null && (viewer = page.getViewer()) instanceof CheckboxTreeViewer) {
                        CheckboxTreeViewer treeViewer = (CheckboxTreeViewer)viewer;
                        treeViewer.setCheckedElements(new Object[0]);
                    }
                    if (LocationPage.this.isPageComplete()) {
                        LocationPage.this.setPageComplete(LocationPage.this.validatePage());
                    }
                }
            });
            ISynchronizePage page = this.fConfiguration.getPage();
            if (page != null && (viewer = page.getViewer()) instanceof CheckboxTreeViewer) {
                ((CheckboxTreeViewer)viewer).addCheckStateListener(event -> this.setPageComplete(this.validatePage()));
            }
        }

        protected void initCheckedItems() {
            Viewer viewer;
            ISynchronizePage page = this.fConfiguration.getPage();
            if (page != null && (viewer = page.getViewer()) instanceof CheckboxTreeViewer) {
                TreeItem[] items = ((CheckboxTreeViewer)viewer).getTree().getItems();
                int i = 0;
                while (i < items.length) {
                    ((CheckboxTreeViewer)viewer).setChecked(items[i].getData(), true);
                    ++i;
                }
            }
        }

        protected IResource[] getSelectedResources() {
            Viewer viewer;
            ISynchronizePage page = this.fConfiguration.getPage();
            if (page != null && (viewer = page.getViewer()) instanceof CheckboxTreeViewer) {
                Object[] elements = ((CheckboxTreeViewer)viewer).getCheckedElements();
                IResource[] selectedResources = Utils.getResources((Object[])elements);
                ArrayList<IResource> result = new ArrayList<IResource>();
                int i = 0;
                while (i < selectedResources.length) {
                    IResource resource = selectedResources[i];
                    if (this.fConfiguration.getSyncInfoSet().getSyncInfo(resource) != null) {
                        result.add(resource);
                    }
                    ++i;
                }
                return result.toArray(new IResource[result.size()]);
            }
            return new IResource[0];
        }

        public void updateEnablements() {
            this.fsBrowseButton.setEnabled(this.selectedLocation == 2);
            this.fsPathText.setEnabled(this.selectedLocation == 2);
            if (this.selectedLocation == 2) {
                this.fsBrowsed = false;
            }
            this.wsPathText.setEnabled(this.selectedLocation == 3);
            this.wsBrowseButton.setEnabled(this.selectedLocation == 3);
            if (this.selectedLocation == 3) {
                this.wsBrowsed = false;
            }
        }

        public int getSelectedLocation() {
            return this.selectedLocation;
        }

        private SyncInfoSet getAllOutOfSync() throws CVSException {
            SubscriberSyncInfoCollector syncInfoCollector = this.fParticipant.getSubscriberSyncInfoCollector();
            class WaitForChangesJob
            extends Job {
                LocationPage fLocationPage;
                private final /* synthetic */ SubscriberSyncInfoCollector val$syncInfoCollector;

                public WaitForChangesJob(LocationPage page, SubscriberSyncInfoCollector subscriberSyncInfoCollector) {
                    this.val$syncInfoCollector = subscriberSyncInfoCollector;
                    super("");
                    this.fLocationPage = page;
                }

                public IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(CVSUIMessages.CommitWizard_4, -1);
                    this.val$syncInfoCollector.waitForCollector(monitor);
                    Utils.syncExec(() -> {
                        this.fLocationPage.initCheckedItems();
                        this.fLocationPage.canValidate = true;
                        this.fLocationPage.validatePage();
                    }, (Control)LocationPage.this.getControl());
                    monitor.done();
                    return Status.OK_STATUS;
                }
            }
            WaitForChangesJob job = new WaitForChangesJob(this, syncInfoCollector);
            job.setSystem(true);
            job.schedule();
            return this.fParticipant.getSyncInfoSet();
        }

        public IFile findBinaryFile() {
            try {
                IFile[] found = new IFile[1];
                this.fParticipant.getSubscriber().accept(GenerateDiffFileWizard.this.resources, 2, diff -> {
                    if (this.isBinaryFile(diff)) {
                        iFileArray[0] = this.getFile(diff);
                    }
                    return true;
                });
                return found[0];
            }
            catch (CoreException e) {
                CVSUIPlugin.log(e);
                return null;
            }
        }

        protected boolean isBinaryFile(IDiff diff) {
            IFile file = this.getFile(diff);
            if (file != null) {
                ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
                try {
                    byte[] bytes = cvsFile.getSyncBytes();
                    if (bytes != null) {
                        return ResourceSyncInfo.getKeywordMode((byte[])bytes).toMode().equals(Command.KSUBST_BINARY.toMode());
                    }
                }
                catch (CVSException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
                return Team.getFileContentManager().getType((IStorage)file) == 2;
            }
            return false;
        }

        protected IFile getFile(IDiff diff) {
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                return file;
            }
            return null;
        }

        public void removeBinaryFiles() {
            try {
                ArrayList nonBinaryFiles = new ArrayList();
                this.fParticipant.getSubscriber().accept(GenerateDiffFileWizard.this.resources, 2, diff -> {
                    IFile file;
                    if (!this.isBinaryFile(diff) && (file = this.getFile(diff)) != null) {
                        nonBinaryFiles.add(file);
                    }
                    return true;
                });
                GenerateDiffFileWizard.this.resources = nonBinaryFiles.toArray(new IResource[nonBinaryFiles.size()]);
            }
            catch (CoreException e) {
                CVSUIPlugin.log(e);
            }
        }

        class LocationPageContentProvider
        extends BaseWorkbenchContentProvider {
            boolean showClosedProjects = false;

            LocationPageContentProvider() {
            }

            public Object[] getChildren(Object element) {
                if (element instanceof IWorkspace) {
                    Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
                    if (this.showClosedProjects) {
                        return allProjects;
                    }
                    ArrayList<Object> accessibleProjects = new ArrayList<Object>();
                    int i = 0;
                    while (i < allProjects.length) {
                        if (allProjects[i].isOpen()) {
                            accessibleProjects.add(allProjects[i]);
                        }
                        ++i;
                    }
                    return accessibleProjects.toArray();
                }
                return super.getChildren(element);
            }
        }

        class WorkspaceDialog
        extends TitleAreaDialog {
            protected TreeViewer wsTreeViewer;
            protected Text wsFilenameText;
            protected Image dlgTitleImage;
            private boolean modified;

            public WorkspaceDialog(Shell shell) {
                super(shell);
                this.modified = false;
            }

            protected Control createContents(Composite parent) {
                Control control = super.createContents(parent);
                this.setTitle(CVSUIMessages.WorkspacePatchDialogTitle);
                this.setMessage(CVSUIMessages.WorkspacePatchDialogDescription);
                this.dlgTitleImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.png").createImage();
                this.setTitleImage(this.dlgTitleImage);
                return control;
            }

            protected Control createDialogArea(Composite parent) {
                Composite parentComposite = (Composite)super.createDialogArea(parent);
                Composite composite = new Composite(parentComposite, 0);
                GridLayout layout = new GridLayout();
                layout.marginHeight = this.convertVerticalDLUsToPixels(7);
                layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
                layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                composite.setLayout((Layout)layout);
                composite.setLayoutData((Object)new GridData(1808));
                composite.setFont(parentComposite.getFont());
                this.getShell().setText(CVSUIMessages.GenerateDiffFileWizard_9);
                this.wsTreeViewer = new TreeViewer(composite, 2048);
                GridData gd = new GridData(4, 4, true, true);
                gd.widthHint = 550;
                gd.heightHint = 250;
                this.wsTreeViewer.getTree().setLayoutData((Object)gd);
                this.wsTreeViewer.setContentProvider((IContentProvider)new LocationPageContentProvider());
                this.wsTreeViewer.setComparator((ViewerComparator)new ResourceComparator(1));
                this.wsTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
                this.wsTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
                Path existingWorkspacePath = new Path(LocationPage.this.wsPathText.getText());
                IResource selectedResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)existingWorkspacePath);
                if (selectedResource != null) {
                    this.wsTreeViewer.expandToLevel((Object)selectedResource, 0);
                    this.wsTreeViewer.setSelection((ISelection)new StructuredSelection((Object)selectedResource));
                }
                Composite group = new Composite(composite, 0);
                layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                group.setLayout((Layout)layout);
                group.setLayoutData((Object)new GridData(4, 4, true, false));
                Label label = new Label(group, 0);
                label.setLayoutData((Object)new GridData());
                label.setText(CVSUIMessages.Fi_le_name__9);
                this.wsFilenameText = new Text(group, 2048);
                this.wsFilenameText.setLayoutData((Object)new GridData(4, 128, true, false));
                this.setupListeners();
                return parent;
            }

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                Button button = super.createButton(parent, id, label, defaultButton);
                if (id == 0) {
                    button.setEnabled(false);
                }
                return button;
            }

            private void validateDialog() {
                String fileName = this.wsFilenameText.getText();
                if (fileName.equals("")) {
                    if (this.modified) {
                        this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_2);
                        this.getButton(0).setEnabled(false);
                        return;
                    }
                    this.setErrorMessage(null);
                    this.getButton(0).setEnabled(false);
                    return;
                }
                if (!ResourcesPlugin.getWorkspace().validateName(fileName, 1).isOK() && this.modified) {
                    this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_5);
                    this.getButton(0).setEnabled(false);
                    return;
                }
                if (this.getSelectedContainer() == null) {
                    this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_0);
                    this.getButton(0).setEnabled(false);
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath fullPath = LocationPage.this.wsSelectedContainer.getFullPath().append(fileName);
                if (workspace.getRoot().getFolder(fullPath).exists()) {
                    this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_FolderExists);
                    this.getButton(0).setEnabled(false);
                    return;
                }
                this.setErrorMessage(null);
                this.getButton(0).setEnabled(true);
            }

            protected void okPressed() {
                IFile file = LocationPage.this.wsSelectedContainer.getFile((IPath)new Path(this.wsFilenameText.getText()));
                if (file != null) {
                    LocationPage.this.wsPathText.setText(file.getFullPath().toString());
                }
                LocationPage.this.validatePage();
                super.okPressed();
            }

            private IContainer getSelectedContainer() {
                Object obj = this.wsTreeViewer.getStructuredSelection().getFirstElement();
                if (obj instanceof IContainer) {
                    LocationPage.this.wsSelectedContainer = (IContainer)obj;
                } else if (obj instanceof IFile) {
                    LocationPage.this.wsSelectedContainer = ((IFile)obj).getParent();
                }
                return LocationPage.this.wsSelectedContainer;
            }

            protected void cancelPressed() {
                LocationPage.this.validatePage();
                super.cancelPressed();
            }

            public boolean close() {
                if (this.dlgTitleImage != null) {
                    this.dlgTitleImage.dispose();
                }
                return super.close();
            }

            void setupListeners() {
                this.wsTreeViewer.addSelectionChangedListener(event -> {
                    IStructuredSelection s = event.getStructuredSelection();
                    Object obj = s.getFirstElement();
                    if (obj instanceof IContainer) {
                        LocationPage.this.wsSelectedContainer = (IContainer)obj;
                    } else if (obj instanceof IFile) {
                        IFile tempFile = (IFile)obj;
                        LocationPage.this.wsSelectedContainer = tempFile.getParent();
                        this.wsFilenameText.setText(tempFile.getName());
                    }
                    this.validateDialog();
                });
                this.wsTreeViewer.addDoubleClickListener(event -> {
                    ISelection s = event.getSelection();
                    if (s instanceof IStructuredSelection) {
                        Object item = ((IStructuredSelection)s).getFirstElement();
                        if (this.wsTreeViewer.getExpandedState(item)) {
                            this.wsTreeViewer.collapseToLevel(item, 1);
                        } else {
                            this.wsTreeViewer.expandToLevel(item, 1);
                        }
                    }
                    this.validateDialog();
                });
                this.wsFilenameText.addModifyListener(e -> {
                    this.modified = true;
                    this.validateDialog();
                });
            }
        }
    }

    private class OptionsPage
    extends WizardPage {
        public static final int FORMAT_UNIFIED = 1;
        public static final int FORMAT_CONTEXT = 2;
        public static final int FORMAT_STANDARD = 3;
        public static final int ROOT_WORKSPACE = 1;
        public static final int ROOT_PROJECT = 2;
        public static final int ROOT_SELECTION = 3;
        private Button unifiedDiffOption;
        private Button unified_workspaceRelativeOption;
        private Button unified_projectRelativeOption;
        private Button unified_selectionRelativeOption;
        private Button contextDiffOption;
        private Button regularDiffOption;
        private final RadioButtonGroup diffTypeRadioGroup;
        private final RadioButtonGroup unifiedRadioGroup;
        private boolean patchHasCommonRoot;
        protected IPath patchRoot;
        private final DefaultValuesStore store;

        protected OptionsPage(String pageName, String title, ImageDescriptor titleImage, DefaultValuesStore store) {
            super(pageName, title, titleImage);
            this.diffTypeRadioGroup = new RadioButtonGroup();
            this.unifiedRadioGroup = new RadioButtonGroup();
            this.patchHasCommonRoot = true;
            this.patchRoot = ResourcesPlugin.getWorkspace().getRoot().getFullPath();
            this.store = store;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData());
            this.setControl((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.patch_options_page_context");
            Group diffTypeGroup = new Group(composite, 0);
            layout = new GridLayout();
            diffTypeGroup.setLayout((Layout)layout);
            GridData data = new GridData(768);
            diffTypeGroup.setLayoutData((Object)data);
            diffTypeGroup.setText(CVSUIMessages.Diff_output_format_12);
            this.unifiedDiffOption = new Button((Composite)diffTypeGroup, 16);
            this.unifiedDiffOption.setText(CVSUIMessages.Unified__format_required_by_Compare_With_Patch_feature__13);
            this.contextDiffOption = new Button((Composite)diffTypeGroup, 16);
            this.contextDiffOption.setText(CVSUIMessages.Context_14);
            this.regularDiffOption = new Button((Composite)diffTypeGroup, 16);
            this.regularDiffOption.setText(CVSUIMessages.Standard_15);
            this.diffTypeRadioGroup.add(1, this.unifiedDiffOption);
            this.diffTypeRadioGroup.add(2, this.contextDiffOption);
            this.diffTypeRadioGroup.add(3, this.regularDiffOption);
            Group unifiedGroup = new Group(composite, 0);
            layout = new GridLayout();
            unifiedGroup.setLayout((Layout)layout);
            data = new GridData(768);
            unifiedGroup.setLayoutData((Object)data);
            unifiedGroup.setText(CVSUIMessages.GenerateDiffFileWizard_10);
            this.unified_workspaceRelativeOption = new Button((Composite)unifiedGroup, 16);
            this.unified_workspaceRelativeOption.setText(CVSUIMessages.GenerateDiffFileWizard_6);
            this.unified_workspaceRelativeOption.setSelection(true);
            this.unified_projectRelativeOption = new Button((Composite)unifiedGroup, 16);
            this.unified_projectRelativeOption.setText(CVSUIMessages.GenerateDiffFileWizard_7);
            this.unified_selectionRelativeOption = new Button((Composite)unifiedGroup, 16);
            this.unified_selectionRelativeOption.setText(CVSUIMessages.GenerateDiffFileWizard_8);
            this.unifiedRadioGroup.add(1, this.unified_workspaceRelativeOption);
            this.unifiedRadioGroup.add(2, this.unified_projectRelativeOption);
            this.unifiedRadioGroup.add(3, this.unified_selectionRelativeOption);
            Dialog.applyDialogFont((Control)parent);
            this.initializeDefaultValues();
            this.unifiedDiffOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OptionsPage.this.setEnableUnifiedGroup(true);
                    OptionsPage.this.updateEnablements();
                    OptionsPage.this.diffTypeRadioGroup.setSelection(1, false);
                }
            });
            this.contextDiffOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OptionsPage.this.setEnableUnifiedGroup(false);
                    OptionsPage.this.updateEnablements();
                    OptionsPage.this.diffTypeRadioGroup.setSelection(2, false);
                }
            });
            this.regularDiffOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OptionsPage.this.setEnableUnifiedGroup(false);
                    OptionsPage.this.updateEnablements();
                    OptionsPage.this.diffTypeRadioGroup.setSelection(3, false);
                }
            });
            this.unified_workspaceRelativeOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OptionsPage.this.unifiedRadioGroup.setSelection(1, false);
                }
            });
            this.unified_projectRelativeOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OptionsPage.this.unifiedRadioGroup.setSelection(2, false);
                }
            });
            this.unified_selectionRelativeOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OptionsPage.this.unifiedRadioGroup.setSelection(3, false);
                }
            });
            this.calculatePatchRoot();
            this.updateEnablements();
            this.diffTypeRadioGroup.selectEnabledOnly();
            this.unifiedRadioGroup.selectEnabledOnly();
        }

        public int getFormatSelection() {
            return this.diffTypeRadioGroup.getSelected();
        }

        public int getRootSelection() {
            return this.unifiedRadioGroup.getSelected();
        }

        private void initializeDefaultValues() {
            this.diffTypeRadioGroup.setSelection(this.store.getFormatSelection(), true);
            this.unifiedRadioGroup.setSelection(this.store.getRootSelection(), true);
            if (this.store.getFormatSelection() != 1) {
                this.setEnableUnifiedGroup(false);
            }
        }

        protected void updateEnablements() {
            if (!this.patchHasCommonRoot) {
                this.diffTypeRadioGroup.setEnablement(false, new int[]{2, 3}, 1);
                this.unifiedRadioGroup.setEnablement(false, new int[]{2, 3}, 1);
            }
            if (!GenerateDiffFileWizard.this.unifiedSelectionEnabled) {
                this.unifiedRadioGroup.setEnablement(false, new int[]{3});
            }
        }

        private void calculatePatchRoot() {
            IResource[] tempResources = ((GenerateDiffFileWizard)this.getWizard()).resources;
            if (tempResources == null) {
                return;
            }
            if (tempResources.length > 1) {
                this.patchHasCommonRoot = true;
                int segmentMatch = -1;
                IPath path = tempResources[0].getFullPath().removeLastSegments(1);
                int i = 1;
                while (i < tempResources.length) {
                    int segments = path.matchingFirstSegments(tempResources[i].getFullPath());
                    if (segmentMatch == -1 || segmentMatch > segments) {
                        segmentMatch = segments;
                    }
                    if (segments == 0) {
                        this.patchHasCommonRoot = false;
                        break;
                    }
                    ++i;
                }
                if (this.patchHasCommonRoot) {
                    IPath tempPath;
                    this.patchRoot = tempPath = path.uptoSegment(segmentMatch);
                }
            } else {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IPath fullPath = tempResources[0].getFullPath();
                IResource resource = root.findMember(fullPath);
                while (resource == null && !(resource instanceof IWorkspaceRoot)) {
                    fullPath = fullPath.removeLastSegments(1);
                    resource = root.findMember(fullPath);
                }
                this.patchRoot = resource.getFullPath();
                if (resource.getType() == 1) {
                    this.patchRoot = resource.getFullPath().removeLastSegments(1);
                }
            }
        }

        public Command.LocalOption[] getOptions() {
            ArrayList<Command.LocalOption> options = new ArrayList<Command.LocalOption>(5);
            options.add(Diff.INCLUDE_NEWFILES);
            if (this.unifiedDiffOption.getSelection()) {
                options.add(Diff.UNIFIED_FORMAT);
            } else if (this.contextDiffOption.getSelection()) {
                options.add(Diff.CONTEXT_FORMAT);
            }
            return options.toArray(new Command.LocalOption[options.size()]);
        }

        protected void setEnableUnifiedGroup(boolean enabled) {
            this.unifiedRadioGroup.setEnablement(enabled, new int[]{1, 2, 3});
            if (!GenerateDiffFileWizard.this.unifiedSelectionEnabled) {
                this.unifiedRadioGroup.setEnablement(false, new int[]{3});
            }
        }
    }

    class RadioButtonGroup {
        private List buttons = new ArrayList(3);
        private int selected = 0;

        RadioButtonGroup() {
        }

        public void add(int buttonCode, Button button) {
            if (button != null && (button.getStyle() & 0x10) != 0) {
                if (button.getSelection() && !this.buttons.isEmpty()) {
                    this.deselectAll();
                    this.selected = buttonCode - 1;
                }
                this.buttons.add(buttonCode - 1, button);
            }
        }

        public int getSelected() {
            return this.selected + 1;
        }

        public int setSelection(int buttonCode, boolean selectEnabledOnly) {
            this.deselectAll();
            ((Button)this.buttons.get(buttonCode - 1)).setSelection(true);
            this.selected = buttonCode - 1;
            if (selectEnabledOnly) {
                this.selected = this.selectEnabledOnly() - 1;
            }
            return this.getSelected();
        }

        public int selectEnabledOnly() {
            this.deselectAll();
            Button selectedButton = (Button)this.buttons.get(this.selected);
            if (!selectedButton.isEnabled()) {
                for (Button b : this.buttons) {
                    if (!b.isEnabled()) continue;
                    b.setSelection(true);
                    this.selected = this.buttons.indexOf(b);
                    return this.selected + 1;
                }
                selectedButton.setSelection(true);
            } else {
                selectedButton.setSelection(true);
            }
            return this.getSelected();
        }

        public void setEnablement(boolean enabled, int[] buttonsToChange, int defaultSelection) {
            int i = 0;
            while (i < buttonsToChange.length) {
                ((Button)this.buttons.get(buttonsToChange[i] - 1)).setEnabled(enabled);
                ++i;
            }
            if (!((Button)this.buttons.get(this.selected)).isEnabled()) {
                if (defaultSelection != -1) {
                    this.setSelection(defaultSelection, true);
                } else {
                    this.selectEnabledOnly();
                }
            }
        }

        public void setEnablement(boolean enabled, int[] buttonsToChange) {
            this.setEnablement(enabled, buttonsToChange, -1);
        }

        private void deselectAll() {
            Iterator iterator = this.buttons.iterator();
            while (iterator.hasNext()) {
                ((Button)iterator.next()).setSelection(false);
            }
        }
    }
}

