/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.core.preferences;

import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class ScopedEclipsePreferences {
    private final String qualifier;
    protected final IEclipsePreferences defaultPrefs;
    protected final IEclipsePreferences contextScopePrefs;
    private final ListenerList listeners = new ListenerList();

    public ScopedEclipsePreferences(String qualifier) {
        this(InstanceScope.INSTANCE, qualifier);
    }

    public ScopedEclipsePreferences(IScopeContext context, String qualifier) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)qualifier);
        this.qualifier = qualifier;
        this.defaultPrefs = DefaultScope.INSTANCE.getNode(this.getQualifier());
        this.contextScopePrefs = context.getNode(this.getQualifier());
    }

    protected final String getQualifier() {
        return this.qualifier;
    }

    public void exportPreferences(OutputStream stream) {
        Assert.isNotNull((Object)stream);
        try {
            IPreferenceFilter filter = new IPreferenceFilter(){

                public String[] getScopes() {
                    return new String[]{"instance"};
                }

                public Map getMapping(String scope) {
                    return null;
                }
            };
            Platform.getPreferencesService().exportPreferences(this.contextScopePrefs, new IPreferenceFilter[]{filter}, stream);
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean containsKey(String key) {
        return Platform.getPreferencesService().getString(this.getQualifier(), key, null, null) != null;
    }

    public final String getString(String key) {
        return Platform.getPreferencesService().getString(this.getQualifier(), key, null, null);
    }

    public final boolean getBoolean(String key) {
        return Platform.getPreferencesService().getBoolean(this.getQualifier(), key, false, null);
    }

    public final int getInt(String key) {
        return Platform.getPreferencesService().getInt(this.getQualifier(), key, 0, null);
    }

    public final long getLong(String key) {
        return Platform.getPreferencesService().getLong(this.getQualifier(), key, 0L, null);
    }

    public final String getDefaultString(String key) {
        return this.defaultPrefs.get(key, null);
    }

    public final boolean getDefaultBoolean(String key) {
        return this.defaultPrefs.getBoolean(key, false);
    }

    public final int getDefaultInt(String key) {
        return this.defaultPrefs.getInt(key, 0);
    }

    public final long getDefaultLong(String key) {
        return this.defaultPrefs.getLong(key, 0L);
    }

    public void putString(String key, String value) {
        String defValue = this.defaultPrefs.get(key, null);
        String instValue = this.getString(key);
        if (value == null || value.equals(defValue)) {
            this.contextScopePrefs.remove(key);
            this.flushAndNotify(this.contextScopePrefs, key, instValue, defValue);
        } else if (!value.equals(instValue)) {
            this.contextScopePrefs.put(key, value);
            this.flushAndNotify(this.contextScopePrefs, key, instValue, value);
        }
    }

    public void putBoolean(String key, boolean value) {
        boolean defValue = this.defaultPrefs.getBoolean(key, false);
        boolean instValue = this.getBoolean(key);
        if (value == defValue) {
            this.contextScopePrefs.remove(key);
            this.flushAndNotify(this.contextScopePrefs, key, Boolean.toString(instValue), Boolean.toString(defValue));
        } else if (value != instValue) {
            this.contextScopePrefs.putBoolean(key, value);
            this.flushAndNotify(this.contextScopePrefs, key, Boolean.toString(instValue), Boolean.toString(value));
        }
    }

    public void putInt(String key, int value) {
        int defValue = this.defaultPrefs.getInt(key, 0);
        int instValue = this.getInt(key);
        if (value == defValue) {
            this.contextScopePrefs.remove(key);
            this.flushAndNotify(this.contextScopePrefs, key, Integer.toString(instValue), Integer.toString(defValue));
        } else if (value != instValue) {
            this.contextScopePrefs.putInt(key, value);
            this.flushAndNotify(this.contextScopePrefs, key, Integer.toString(instValue), Integer.toString(value));
        }
    }

    public void putLong(String key, long value) {
        long defValue = this.defaultPrefs.getLong(key, 0L);
        long instValue = this.getLong(key);
        if (value == defValue) {
            this.contextScopePrefs.remove(key);
            this.flushAndNotify(this.contextScopePrefs, key, Long.toString(instValue), Long.toString(defValue));
        } else if (value != instValue) {
            this.contextScopePrefs.putLong(key, value);
            this.flushAndNotify(this.contextScopePrefs, key, Long.toString(instValue), Long.toString(value));
        }
    }

    public void putDefaultString(String key, String value) {
        String defValue = this.defaultPrefs.get(key, null);
        if (value == null) {
            this.defaultPrefs.remove(key);
            this.flushAndNotify(this.defaultPrefs, key, defValue, null);
        } else if (!value.equals(defValue)) {
            this.defaultPrefs.put(key, value);
            this.flushAndNotify(this.defaultPrefs, key, defValue, value);
        }
    }

    public void putDefaultBoolean(String key, boolean value) {
        boolean defValue = this.defaultPrefs.getBoolean(key, false);
        if (value != defValue) {
            this.defaultPrefs.putBoolean(key, value);
            this.flushAndNotify(this.defaultPrefs, key, Boolean.toString(defValue), Boolean.toString(value));
        }
    }

    public void putDefaultInt(String key, int value) {
        int defValue = this.defaultPrefs.getInt(key, 0);
        if (value != defValue) {
            this.defaultPrefs.putInt(key, value);
            this.flushAndNotify(this.defaultPrefs, key, Integer.toString(defValue), Integer.toString(value));
        }
    }

    public void putDefaultLong(String key, long value) {
        long defValue = this.defaultPrefs.getLong(key, 0L);
        if (value != defValue) {
            this.defaultPrefs.putLong(key, value);
            this.flushAndNotify(this.defaultPrefs, key, Long.toString(defValue), Long.toString(value));
        }
    }

    protected final void flushAndNotify(IEclipsePreferences node, String key, String oldValue, String newValue) {
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.firePreferenceEvent(node, key, oldValue, newValue);
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.add((Object)listener);
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.remove((Object)listener);
    }

    protected void firePreferenceEvent(IEclipsePreferences node, String key, String oldValue, String newValue) {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)key);
        if (this.listeners.isEmpty()) {
            return;
        }
        Object[] l = this.listeners.getListeners();
        final IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)node, key, (Object)oldValue, (Object)newValue);
        int i = 0;
        while (i < l.length) {
            final IEclipsePreferences.IPreferenceChangeListener listener = (IEclipsePreferences.IPreferenceChangeListener)l[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.preferenceChange(event);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }
}

