/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.model.tree;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTreeDataProvider<A extends TmfStateSystemAnalysisModule, M extends ITmfTreeDataModel>
extends AbstractStateSystemAnalysisDataProvider
implements ITmfTreeDataProvider<M> {
    protected static final Logger LOGGER = TraceCompassLog.getLogger(AbstractTreeDataProvider.class);
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private final A fAnalysisModule;
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private final BiMap<Long, Integer> fIdToQuark = HashBiMap.create();
    private @Nullable TmfModelResponse<List<M>> fCached;

    public AbstractTreeDataProvider(ITmfTrace trace, A analysisModule) {
        super(trace);
        this.fAnalysisModule = analysisModule;
    }

    protected A getAnalysisModule() {
        return this.fAnalysisModule;
    }

    protected long getId(int quark) {
        return (Long)this.fIdToQuark.inverse().computeIfAbsent((Object)quark, q -> ENTRY_ID.getAndIncrement());
    }

    protected long getEntryId() {
        return ENTRY_ID.getAndIncrement();
    }

    @Deprecated
    protected Set<Integer> getSelectedQuarks(SelectionTimeQueryFilter filter) {
        return new HashSet<Integer>(this.getSelectedEntries(filter).values());
    }

    protected Map<Long, Integer> getSelectedEntries(SelectionTimeQueryFilter filter) {
        this.fLock.readLock().lock();
        try {
            HashMap<Long, Integer> selectedEntries = new HashMap<Long, Integer>();
            Iterator iterator = filter.getSelectedItems().iterator();
            while (iterator.hasNext()) {
                Long selectedItem = (Long)iterator.next();
                Integer quark = (Integer)this.fIdToQuark.get((Object)selectedItem);
                if (quark == null || quark < 0) continue;
                selectedEntries.put(selectedItem, quark);
            }
            HashMap<Long, Integer> hashMap = selectedEntries;
            return hashMap;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    protected static Collection<Long> getTimes(TimeQueryFilter filter, long start, long end) {
        HashSet<Long> times = new HashSet<Long>();
        long[] lArray = filter.getTimesRequested();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            if (start <= time && time <= end) {
                times.add(time);
            }
            ++n2;
        }
        return times;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final TmfModelResponse<List<M>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract boolean isCacheable();

    protected abstract List<M> getTree(ITmfStateSystem var1, TimeQueryFilter var2, @Nullable IProgressMonitor var3) throws StateSystemDisposedException;
}

