/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.graphimpl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCC;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCCResult;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;

public class Graph<V>
implements IGraphDataSource<V>,
IBiDirectionalGraphDataSource<V> {
    private IMultiLookup<V, V> outgoingEdges = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.MULTISETS, Object.class);
    private IMultiLookup<V, V> incomingEdges = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.MULTISETS, Object.class);
    private Set<V> nodes = CollectionsFactory.createSet();
    private List<IGraphObserver<V>> observers = CollectionsFactory.createObserverList();
    private static final String[] colors = new String[]{"yellow", "blue", "red", "green", "gray", "cyan"};

    public void insertEdge(V source, V target) {
        this.outgoingEdges.addPair(source, target);
        this.incomingEdges.addPair(target, source);
        for (IGraphObserver<V> go : this.observers) {
            go.edgeInserted(source, target);
        }
    }

    public void deleteEdgeIfExists(V source, V target) {
        boolean containedEdge = this.outgoingEdges.lookupOrEmpty(source).containsNonZero(target);
        if (containedEdge) {
            this.deleteEdgeThatExists(source, target);
        }
    }

    public void deleteEdgeThatExists(V source, V target) {
        this.outgoingEdges.removePair(source, target);
        this.incomingEdges.removePair(target, source);
        for (IGraphObserver<V> go : this.observers) {
            go.edgeDeleted(source, target);
        }
    }

    @Deprecated
    public void deleteEdge(V source, V target) {
        this.deleteEdgeIfExists(source, target);
    }

    public void insertNode(V node) {
        if (this.nodes.add(node)) {
            for (IGraphObserver<V> go : this.observers) {
                go.nodeInserted(node);
            }
        }
    }

    public void deleteNode(V node) {
        if (this.nodes.remove(node)) {
            for (IGraphObserver<V> go : this.observers) {
                go.nodeDeleted(node);
            }
        }
    }

    @Override
    public void attachObserver(IGraphObserver<V> go) {
        this.observers.add(go);
    }

    @Override
    public void attachAsFirstObserver(IGraphObserver<V> observer) {
        this.observers.add(0, observer);
    }

    @Override
    public void detachObserver(IGraphObserver<V> go) {
        this.observers.remove(go);
    }

    @Override
    public Set<V> getAllNodes() {
        return this.nodes;
    }

    @Override
    public IMemoryView<V> getTargetNodes(V source) {
        return this.outgoingEdges.lookupOrEmpty(source);
    }

    @Override
    public IMemoryView<V> getSourceNodes(V target) {
        return this.incomingEdges.lookupOrEmpty(target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes = ");
        for (V n : this.getAllNodes()) {
            sb.append(n.toString());
            sb.append(" ");
        }
        sb.append(" edges = ");
        for (Object source : this.outgoingEdges.distinctKeys()) {
            IMemoryView targets = this.outgoingEdges.lookup(source);
            for (Object target : targets.distinctValues()) {
                int count = targets.getCount(target);
                int i = 0;
                while (i < count) {
                    sb.append("(" + source + "," + target + ") ");
                    ++i;
                }
            }
        }
        return sb.toString();
    }

    public String generateDot(boolean colorSCCs, Function<V, String> nameMapper, Function<V, String> colorMapper) {
        HashMap<Object, String> colorMap = new HashMap<Object, String>();
        if (colorSCCs) {
            SCCResult result = SCC.computeSCC(this);
            Iterator<V> sccs = result.getSccs();
            int i = 0;
            Iterator<Object> iterator = sccs.iterator();
            while (iterator.hasNext()) {
                Set scc = (Set)iterator.next();
                if (scc.size() <= 1) continue;
                for (Object node : scc) {
                    String color = (String)colorMap.get(node);
                    if (color == null) {
                        colorMap.put(node, colors[i % colors.length]);
                        continue;
                    }
                    colorMap.put(node, String.valueOf((String)colorMap.get(node)) + ":" + colors[i % colors.length]);
                }
                ++i;
            }
            for (Object node : this.getAllNodes()) {
                if (colorMap.containsKey(node)) continue;
                colorMap.put(node, "white");
            }
        } else {
            for (Object node : this.getAllNodes()) {
                colorMap.put(node, "white");
            }
        }
        if (colorMapper != null) {
            for (Object node : this.getAllNodes()) {
                colorMap.put(node, colorMapper.apply(node));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("digraph g {\n");
        for (V node : this.getAllNodes()) {
            String nodePresentation = nameMapper == null ? node.toString() : nameMapper.apply(node);
            builder.append("\"" + nodePresentation + "\"");
            builder.append("[style=filled,fillcolor=" + (String)colorMap.get(node) + "]");
            builder.append(";\n");
        }
        for (Object source : this.outgoingEdges.distinctKeys()) {
            IMemoryView targets = this.outgoingEdges.lookup(source);
            String sourcePresentation = nameMapper == null ? source.toString() : nameMapper.apply(source);
            for (Object target : targets.distinctValues()) {
                int count = targets.getCount(target);
                String targetPresentation = nameMapper == null ? target.toString() : nameMapper.apply(target);
                int i = 0;
                while (i < count) {
                    builder.append("\"" + sourcePresentation + "\" -> \"" + targetPresentation + "\";\n");
                    ++i;
                }
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public String generateDot() {
        return this.generateDot(false, null, null);
    }

    public Integer[] deleteRandomEdge() {
        return null;
    }

    public Integer[] insertRandomEdge() {
        return null;
    }
}

