/**
 * Copyright (c) 2010-2016, Peter Lunk, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Peter Lunk - initial API and implementation
 */
package org.eclipse.viatra.query.testing.core.internal;

import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.viatra.query.testing.core.api.JavaObjectAccess;
import org.eclipse.viatra.query.testing.core.api.MatchRecordEquivalence;
import org.eclipse.viatra.query.testing.snapshot.MatchRecord;
import org.eclipse.viatra.query.testing.snapshot.MatchSubstitutionRecord;
import org.eclipse.viatra.query.testing.snapshot.SerializedJavaObjectSubstitution;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * @author Peter Lunk
 */
@SuppressWarnings("all")
public class DefaultMatchRecordEquivalence extends MatchRecordEquivalence {
  public DefaultMatchRecordEquivalence(final Map<String, JavaObjectAccess> accessMap) {
    super(accessMap);
  }
  
  public DefaultMatchRecordEquivalence() {
    super(Maps.<String, JavaObjectAccess>newHashMap());
  }
  
  @Override
  protected boolean doEquivalent(final MatchRecord a, final MatchRecord b) {
    HashMap<String, Object> _map = this.toMap(a);
    HashMap<String, Object> _map_1 = this.toMap(b);
    return Maps.<String, Object>difference(_map, _map_1, new Equivalence<Object>() {
      @Override
      protected boolean doEquivalent(final Object a, final Object b) {
        if (((a instanceof SerializedJavaObjectSubstitution) && (b instanceof SerializedJavaObjectSubstitution))) {
          final SerializedJavaObjectSubstitution aSub = ((SerializedJavaObjectSubstitution) a);
          final SerializedJavaObjectSubstitution bSub = ((SerializedJavaObjectSubstitution) b);
          boolean _equals = aSub.getType().equals(bSub.getType());
          if (_equals) {
            final JavaObjectAccess access = DefaultMatchRecordEquivalence.this.accessMap.get(aSub.getType());
            return access.equals(aSub, bSub);
          }
        } else {
          if (((a instanceof InternalEObject) && (b instanceof InternalEObject))) {
            if ((((InternalEObject) a).eIsProxy() && ((InternalEObject) b).eIsProxy())) {
              URI _eProxyURI = ((InternalEObject) a).eProxyURI();
              URI _eProxyURI_1 = ((InternalEObject) b).eProxyURI();
              return Objects.equal(_eProxyURI, _eProxyURI_1);
            }
          }
        }
        return java.util.Objects.equals(a, b);
      }
      
      @Override
      protected int doHash(final Object t) {
        int _xblockexpression = (int) 0;
        {
          if (((t instanceof SerializedJavaObjectSubstitution) && (!((InternalEObject) t).eIsProxy()))) {
            final JavaObjectAccess access = DefaultMatchRecordEquivalence.this.accessMap.get(((SerializedJavaObjectSubstitution) t).getType());
            return access.calculateHash(((SerializedJavaObjectSubstitution) t));
          } else {
            if (((t instanceof InternalEObject) && ((InternalEObject) t).eIsProxy())) {
              return ((InternalEObject) t).eProxyURI().hashCode();
            }
          }
          _xblockexpression = t.hashCode();
        }
        return _xblockexpression;
      }
    }).areEqual();
  }
  
  @Override
  protected int doHash(final MatchRecord t) {
    final Function1<MatchSubstitutionRecord, Integer> _function = (MatchSubstitutionRecord it) -> {
      int _xblockexpression = (int) 0;
      {
        final Object value = this.helper.derivedValue(it);
        int _xifexpression = (int) 0;
        if (((value instanceof InternalEObject) && ((InternalEObject) value).eIsProxy())) {
          _xifexpression = ((InternalEObject) value).eProxyURI().hashCode();
        } else {
          int _xifexpression_1 = (int) 0;
          if ((value instanceof SerializedJavaObjectSubstitution)) {
            final JavaObjectAccess access = this.accessMap.get(((SerializedJavaObjectSubstitution) value).getType());
            return Integer.valueOf(access.calculateHash(((SerializedJavaObjectSubstitution) value)));
          } else {
            int _hashCode = 0;
            if (value!=null) {
              _hashCode=value.hashCode();
            }
            _xifexpression_1 = _hashCode;
          }
          _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
      }
      return Integer.valueOf(_xblockexpression);
    };
    final Function2<Integer, Integer, Integer> _function_1 = (Integer r, Integer e) -> {
      return Integer.valueOf(((r).intValue() + (e).intValue()));
    };
    return (int) IterableExtensions.<Integer, Integer>fold(ListExtensions.<MatchSubstitutionRecord, Integer>map(t.getSubstitutions(), _function), Integer.valueOf(0), _function_1);
  }
}
