/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap;

import java.util.ArrayList;
import java.util.Arrays;

public class VlqDecoder {
    private static final int VLQ_BASE_SHIFT = 5;
    private static final int VLQ_BASE = 32;
    private static final int VLQ_BASE_MASK = 31;
    private static final int VLQ_CONTINUATION_BIT = 32;
    private static final String BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int[] BASE64_DECODE_MAP = new int[256];

    static {
        Arrays.fill(BASE64_DECODE_MAP, -1);
        int i = 0;
        while (i < BASE64_MAP.length()) {
            VlqDecoder.BASE64_DECODE_MAP[BASE64_MAP.charAt((int)i)] = i;
            ++i;
        }
    }

    public static int[] decode(String str) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        int i = 0;
        int strLen = str.length();
        while (i < strLen) {
            boolean continuation;
            int result = 0;
            int shift = 0;
            do {
                char c;
                int digit;
                continuation = ((digit = VlqDecoder.fromBase64(c = str.charAt(i++))) & 0x20) != 0;
                result += (digit &= 0x1F) << shift;
                shift += 5;
            } while (continuation);
            results.add(VlqDecoder.fromVLQSigned(result));
        }
        int[] array = new int[results.size()];
        i = 0;
        while (i < results.size()) {
            array[i] = (Integer)results.get(i);
            ++i;
        }
        return array;
    }

    public static String encode(int[] values) {
        StringBuilder builder = new StringBuilder();
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            value = VlqDecoder.toVLQSigned(value);
            do {
                int digit = value & 0x1F;
                if ((value >>>= 5) > 0) {
                    digit |= 0x20;
                }
                builder.append(VlqDecoder.toBase64(digit));
            } while (value > 0);
            ++n2;
        }
        return builder.toString();
    }

    private static int fromBase64(char c) {
        return BASE64_DECODE_MAP[c];
    }

    private static int fromVLQSigned(int value) {
        boolean negate = (value & 1) == 1;
        return negate ? -value : (value >>= 1);
    }

    private static char toBase64(int value) {
        return BASE64_MAP.charAt(value);
    }

    private static int toVLQSigned(int value) {
        if (value < 0) {
            return (-value << 1) + 1;
        }
        return (value << 1) + 0;
    }

    private VlqDecoder() {
    }
}

