/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.properties;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CustomPropertyDescriptor
extends PropertyDescriptor {
    protected Class cellEditorClass = null;

    public CustomPropertyDescriptor(Object id, String newDisplayName, Class editorClass) {
        super(id, newDisplayName);
        this.setDescription((String)id);
        this.setCellEditorClass(editorClass);
    }

    public CustomPropertyDescriptor(String uniqueName, String newDisplayName) {
        this(uniqueName, newDisplayName, TextCellEditor.class);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return this.getPropertyEditor(parent);
    }

    public Class getCellEditorClass() {
        return this.cellEditorClass;
    }

    protected CellEditor getPropertyEditor(Composite parent) {
        if (this.getCellEditorClass() == null) {
            return null;
        }
        Constructor constructor = null;
        try {
            constructor = this.getCellEditorClass().getDeclaredConstructor(Composite.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return new TextCellEditor(parent);
        }
        if (constructor != null) {
            try {
                return (CellEditor)constructor.newInstance(parent);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return new TextCellEditor(parent);
    }

    public void setCellEditorClass(Class newCellEditorClass) {
        this.cellEditorClass = newCellEditorClass;
    }
}

