/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.junit.formatter;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.formatting.AbstractFormatter;
import org.eclipse.xtext.xbase.formatting.IBasicFormatter;
import org.eclipse.xtext.xbase.formatting.TextReplacement;
import org.eclipse.xtext.xbase.junit.formatter.AssertingFormatterData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.junit.Assert;

@Deprecated
public class FormatterTester {
    @Inject
    @Extension
    private ParseHelper<EObject> _parseHelper;
    @Inject
    private IBasicFormatter formatter;

    public void assertFormatted(Procedures.Procedure1<? super AssertingFormatterData> init) {
        AssertingFormatterData data = new AssertingFormatterData();
        HashMap _newHashMap = CollectionLiterals.newHashMap();
        MapBasedPreferenceValues _mapBasedPreferenceValues = new MapBasedPreferenceValues((Map)_newHashMap);
        data.setConfig(_mapBasedPreferenceValues);
        init.apply((Object)data);
        this.assertFormatted(data);
    }

    public void assertFormatted(AssertingFormatterData it) {
        try {
            boolean _not_2;
            boolean _isAllowErrors_1;
            boolean _not_1;
            boolean _not;
            String _prefix = it.getPrefix();
            CharSequence _toBeFormatted = it.getToBeFormatted();
            String _plus = String.valueOf(_prefix) + _toBeFormatted;
            String _postfix = it.getPostfix();
            String fullToBeParsed = String.valueOf(_plus) + _postfix;
            EObject parsed = this._parseHelper.parse((CharSequence)fullToBeParsed);
            boolean _isAllowErrors = it.isAllowErrors();
            boolean bl = _not = !_isAllowErrors;
            if (_not) {
                Assert.assertEquals((String)IterableExtensions.join((Iterable)parsed.eResource().getErrors(), (CharSequence)"\n"), (long)0L, (long)parsed.eResource().getErrors().size());
            }
            Resource _eResource = parsed.eResource();
            IParseResult _parseResult = ((XtextResource)_eResource).getParseResult();
            ICompositeNode _rootNode = null;
            if (_parseResult != null) {
                _rootNode = _parseResult.getRootNode();
            }
            String _text = null;
            if (_rootNode != null) {
                _text = _rootNode.getText();
            }
            String oldDocument = _text;
            IBasicFormatter formatter = this.formatter;
            boolean _matched = false;
            if (formatter instanceof AbstractFormatter) {
                _matched = true;
                ((AbstractFormatter)this.formatter).setAllowIdentityEdits(true);
            }
            int start = it.getPrefix().length();
            int length = it.getToBeFormatted().length();
            LinkedHashSet edits = CollectionLiterals.newLinkedHashSet();
            Resource _eResource_1 = parsed.eResource();
            List _format = this.formatter.format((XtextResource)_eResource_1, start, length, it.getCfg());
            Iterables.addAll((Collection)edits, (Iterable)_format);
            IBasicFormatter formatter_1 = this.formatter;
            boolean _matched_1 = false;
            if (formatter_1 instanceof AbstractFormatter) {
                _matched_1 = true;
                boolean _isConflictOccurred = ((AbstractFormatter)this.formatter).isConflictOccurred();
                if (_isConflictOccurred) {
                    throw new RuntimeException("There are conflicting text edits, see console for details.");
                }
            }
            boolean bl2 = _not_1 = !(_isAllowErrors_1 = it.isAllowErrors());
            if (_not_1) {
                Resource _eResource_2 = parsed.eResource();
                ArrayList<TextReplacement> _createMissingEditReplacements = this.createMissingEditReplacements((XtextResource)_eResource_2, edits, start, length);
                Iterables.addAll((Collection)edits, _createMissingEditReplacements);
            }
            String newDocument = this.applyEdits(oldDocument, edits);
            try {
                String _prefix_1 = it.getPrefix();
                CharSequence _expectation = it.getExpectation();
                String _plus_1 = String.valueOf(_prefix_1) + _expectation;
                String _postfix_1 = it.getPostfix();
                Assert.assertEquals((Object)(String.valueOf(_plus_1) + _postfix_1).toString(), (Object)newDocument.toString());
            }
            catch (Throwable _t) {
                if (_t instanceof AssertionError) {
                    AssertionError e = (AssertionError)((Object)_t);
                    InputOutput.println((Object)this.applyDebugEdits(oldDocument, edits));
                    InputOutput.println();
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Resource _eResource_3 = parsed.eResource();
            String parsed2Doc = this.applyEdits(fullToBeParsed, this.formatter.format((XtextResource)_eResource_3, 0, fullToBeParsed.length(), it.getCfg()));
            EObject parsed2 = this._parseHelper.parse((CharSequence)parsed2Doc);
            boolean _isAllowErrors_2 = it.isAllowErrors();
            boolean bl3 = _not_2 = !_isAllowErrors_2;
            if (_not_2) {
                Assert.assertEquals((long)0L, (long)parsed2.eResource().getErrors().size());
            }
            Resource _eResource_4 = parsed2.eResource();
            List edits2 = this.formatter.format((XtextResource)_eResource_4, 0, parsed2Doc.length(), it.getCfg());
            String newDocument2 = this.applyEdits(parsed2Doc, edits2);
            try {
                Assert.assertEquals((Object)parsed2Doc, (Object)newDocument2.toString());
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof AssertionError) {
                    AssertionError e_1 = (AssertionError)((Object)_t_1);
                    InputOutput.println((Object)this.applyDebugEdits(newDocument, edits2));
                    InputOutput.println();
                    throw e_1;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String applyEdits(String oldDocument, Collection<TextReplacement> edits) {
        String _xblockexpression = null;
        int lastOffset = 0;
        StringBuilder newDocument = new StringBuilder();
        Functions.Function1 _function = it -> it.getOffset();
        List _sortBy = IterableExtensions.sortBy(edits, (Functions.Function1)_function);
        for (TextReplacement edit : _sortBy) {
            int _plus;
            newDocument.append(oldDocument.substring(lastOffset, edit.getOffset()));
            newDocument.append(edit.getText());
            int _offset = edit.getOffset();
            int _length = edit.getLength();
            lastOffset = _plus = _offset + _length;
        }
        newDocument.append(oldDocument.substring(lastOffset, oldDocument.length()));
        _xblockexpression = newDocument.toString();
        return _xblockexpression;
    }

    protected String applyDebugEdits(String oldDocument, Collection<TextReplacement> edits) {
        String _xblockexpression = null;
        int lastOffset = 0;
        StringBuilder debugTrace = new StringBuilder();
        Functions.Function1 _function = it -> it.getOffset();
        List _sortBy = IterableExtensions.sortBy(edits, (Functions.Function1)_function);
        for (TextReplacement edit : _sortBy) {
            int _plus_1;
            debugTrace.append(oldDocument.substring(lastOffset, edit.getOffset()));
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("[");
            int _offset = edit.getOffset();
            int _length = edit.getLength();
            int _plus = _offset + _length;
            String _substring = oldDocument.substring(edit.getOffset(), _plus);
            _builder.append(_substring);
            _builder.append("|");
            String _text = edit.getText();
            _builder.append(_text);
            _builder.append("]");
            debugTrace.append((CharSequence)_builder);
            int _offset_1 = edit.getOffset();
            int _length_1 = edit.getLength();
            lastOffset = _plus_1 = _offset_1 + _length_1;
        }
        debugTrace.append(oldDocument.substring(lastOffset, oldDocument.length()));
        _xblockexpression = debugTrace.toString();
        return _xblockexpression;
    }

    protected ArrayList<TextReplacement> createMissingEditReplacements(XtextResource res, Collection<TextReplacement> edits, int offset, int length) {
        ArrayList _xblockexpression = null;
        Functions.Function1 _function = it -> it.getOffset();
        Set offsets = IterableExtensions.toSet((Iterable)IterableExtensions.map(edits, (Functions.Function1)_function));
        ArrayList result = CollectionLiterals.newArrayList();
        int lastOffset = 0;
        Iterable _elvis = null;
        IParseResult _parseResult = res.getParseResult();
        ICompositeNode _rootNode = null;
        if (_parseResult != null) {
            _rootNode = _parseResult.getRootNode();
        }
        Iterable _leafNodes = null;
        if (_rootNode != null) {
            _leafNodes = _rootNode.getLeafNodes();
        }
        if (_leafNodes != null) {
            _elvis = _leafNodes;
        } else {
            List _emptyList = CollectionLiterals.emptyList();
            _elvis = _emptyList;
        }
        for (ILeafNode leaf : _elvis) {
            int _plus;
            if (leaf.isHidden() && StringExtensions.isNullOrEmpty((String)leaf.getText().trim())) continue;
            ITextRegion leafRegion = leaf.getTextRegion();
            if (lastOffset >= offset && leafRegion.getOffset() <= offset + length && !offsets.contains(lastOffset)) {
                int _offset = leafRegion.getOffset();
                int _minus = _offset - lastOffset;
                TextReplacement _textReplacement = new TextReplacement(lastOffset, _minus, "!!");
                result.add(_textReplacement);
            }
            int _offset_1 = leafRegion.getOffset();
            int _length = leafRegion.getLength();
            lastOffset = _plus = _offset_1 + _length;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }
}

