/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.ide.authoring;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.ide.authoring.AcceleoDeltaVisitor;
import org.eclipse.acceleo.common.ide.authoring.WorkspaceClassInstance;
import org.eclipse.acceleo.common.internal.utils.workspace.ClassLoadingCompanion;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.IDynamicExtensionRegistry;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public final class AcceleoWorkspaceUtil
implements ClassLoadingCompanion {
    public static final AcceleoWorkspaceUtil INSTANCE = new AcceleoWorkspaceUtil();
    private static final int OSGI_TIMEOUT = 3000;
    private static final String UNINSTALLATION_FAILURE_KEY = "WorkspaceUtil.UninstallationFailure";
    private static final String EMPTY_PLUGIN_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><plugin/>";
    private static final String REFERENCE_URI_PREFIX = "reference:";
    final Set<IPluginModelBase> changedContributions = new CompactLinkedHashSet();
    final Map<IPluginModelBase, Bundle> workspaceInstalledBundles = new HashMap<IPluginModelBase, Bundle>();
    final Map<String, WorkspaceClassInstance> workspaceLoadedClasses = new HashMap<String, WorkspaceClassInstance>();
    private final IResourceChangeListener workspaceListener = new WorkspaceResourcesListener();
    private final Set<String> logOnceProjectLoad = new LinkedHashSet<String>();

    private AcceleoWorkspaceUtil() {
    }

    public IProject getProject(String bundleName) {
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getBundleDescription().getSymbolicName().equals(bundleName)) {
                return model.getUnderlyingResource().getProject();
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasCorrespondingExportPackage(IPluginModelBase model, String qualifiedName) {
        String packageName = "";
        int end = qualifiedName.lastIndexOf(46);
        if (end != -1) {
            packageName = qualifiedName.substring(0, end);
        }
        ExportPackageDescription[] exportPackageDescriptionArray = model.getBundleDescription().getExportPackages();
        int n = exportPackageDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription exported = exportPackageDescriptionArray[n2];
            if (packageName.startsWith(exported.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void addWorkspaceContribution(IProject project) {
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model != null && !this.workspaceInstalledBundles.containsKey(model)) {
            this.changedContributions.add(model);
        }
    }

    public synchronized void dispose() {
        this.changedContributions.clear();
        this.workspaceLoadedClasses.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
        for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
            Bundle bundle = entry.getValue();
            try {
                this.uninstallBundle(bundle);
            }
            catch (BundleException e) {
                AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString((String)UNINSTALLATION_FAILURE_KEY, (Object[])new Object[]{bundle.getSymbolicName()}), (Throwable)e));
            }
        }
        this.workspaceInstalledBundles.clear();
    }

    public synchronized Class<?> getClass(String qualifiedName, boolean honorOSGiVisibility) {
        if (this.changedContributions.size() > 0) {
            this.refreshContributions();
        }
        Class<?> clazz = null;
        WorkspaceClassInstance workspaceInstance = this.workspaceLoadedClasses.get(qualifiedName);
        if (workspaceInstance != null) {
            if (workspaceInstance.isStale()) {
                for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
                    IPluginModelBase model = entry.getKey();
                    if (!workspaceInstance.getBundle().equals(model.getBundleDescription().getSymbolicName())) continue;
                    clazz = this.internalLoadClass(entry.getValue(), qualifiedName);
                    workspaceInstance.setStale(false);
                    workspaceInstance.setClass(clazz);
                    break;
                }
            } else {
                clazz = workspaceInstance.getInstance().getClass();
            }
        }
        if (clazz != null) {
            return clazz;
        }
        Iterator<Map.Entry<IPluginModelBase, Bundle>> iterator = this.workspaceInstalledBundles.entrySet().iterator();
        while (clazz == null && iterator.hasNext()) {
            Map.Entry<IPluginModelBase, Bundle> entry = iterator.next();
            if (honorOSGiVisibility && !AcceleoWorkspaceUtil.hasCorrespondingExportPackage(entry.getKey(), qualifiedName)) continue;
            try {
                clazz = entry.getValue().loadClass(qualifiedName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            AcceleoCommonPlugin.log((String)AcceleoCommonMessages.getString((String)"BundleClassLookupFailure", (Object[])new Object[]{qualifiedName}), (boolean)false);
        }
        return clazz;
    }

    public synchronized Class<?> getClass(IProject project, String qualifiedName) {
        Class<?> instance = null;
        this.addWorkspaceContribution(project);
        this.refreshContributions();
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        Bundle installedBundle = this.workspaceInstalledBundles.get(model);
        if (installedBundle != null) {
            instance = this.internalLoadClass(installedBundle, qualifiedName);
        }
        return instance;
    }

    public synchronized ResourceBundle getResourceBundle(String qualifiedName) {
        if (this.changedContributions.size() > 0) {
            this.refreshContributions();
        }
        for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
            Bundle bundle = entry.getValue();
            URL propertiesResource = bundle.getResource(String.valueOf(qualifiedName.replace('.', '/')) + ".properties");
            if (propertiesResource == null) continue;
            InputStream stream = null;
            try {
                stream = propertiesResource.openStream();
                stream = new BufferedInputStream(stream);
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(stream);
                return propertyResourceBundle;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public synchronized Object getServiceInstance(Class<?> serviceClass) {
        String qualifiedName = serviceClass.getName();
        for (Map.Entry<String, WorkspaceClassInstance> workspaceClass : this.workspaceLoadedClasses.entrySet()) {
            if (!workspaceClass.getKey().equals(qualifiedName)) continue;
            WorkspaceClassInstance workspaceInstance = workspaceClass.getValue();
            if (workspaceInstance.isStale()) {
                for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
                    IPluginModelBase model = entry.getKey();
                    if (!workspaceInstance.getBundle().equals(model.getBundleDescription().getSymbolicName())) continue;
                    Class<?> clazz = this.internalLoadClass(entry.getValue(), qualifiedName);
                    workspaceInstance.setStale(false);
                    workspaceInstance.setClass(clazz);
                    break;
                }
            }
            return workspaceInstance.getInstance();
        }
        return null;
    }

    public void initialize() {
        int interestingEvents = 23;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.workspaceListener, 23);
    }

    public boolean isInDynamicBundle(Class<?> clazz) {
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin != null) {
            Bundle bundle = packageAdmin.getBundle(clazz);
            if (this.workspaceInstalledBundles.values().contains(bundle)) {
                return true;
            }
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        return false;
    }

    public synchronized void refreshContributions() {
        if (this.changedContributions.size() == 0) {
            return;
        }
        for (IPluginModelBase candidate : this.changedContributions) {
            this.installBundle(candidate);
        }
        this.changedContributions.clear();
    }

    public synchronized void reset() {
        this.changedContributions.clear();
        this.workspaceLoadedClasses.clear();
        for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
            Bundle bundle = entry.getValue();
            try {
                if (bundle.getState() == 1) continue;
                this.uninstallBundle(bundle);
            }
            catch (BundleException e) {
                AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString((String)UNINSTALLATION_FAILURE_KEY, (Object[])new Object[]{bundle.getSymbolicName()}), (Throwable)e));
            }
        }
        this.workspaceInstalledBundles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void refreshPackages(Bundle[] bundles) {
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin == null) return;
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        if (bundles != null && Platform.getExtensionRegistry() instanceof IDynamicExtensionRegistry) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                IContributor contributor = ContributorFactoryOSGi.createContributor((Bundle)bundle);
                if (!((IDynamicExtensionRegistry)registry).hasContributor(contributor)) {
                    registry.addContribution((InputStream)new ByteArrayInputStream(EMPTY_PLUGIN_XML.getBytes()), contributor, false, null, null, ((ExtensionRegistry)registry).getTemporaryUserToken());
                }
                ++n2;
            }
        }
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (!flag[0]) {
                try {
                    flag.wait(3000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            context.removeFrameworkListener(listener);
            if (packageAdminReference == null) return;
            context.ungetService(packageAdminReference);
            return;
        }
    }

    void uninstallBundle(Bundle target) throws BundleException {
        target.uninstall();
        this.refreshPackages(null);
    }

    private void checkImportPackagesDependencies(IPluginModelBase model) {
        BundleDescription desc = model.getBundleDescription();
        if (desc == null) {
            return;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = desc.getImportPackages();
        int n = importPackageSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importPackage = importPackageSpecificationArray[n2];
            IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            int n3 = iPluginModelBaseArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPluginModelBase workspaceModel = iPluginModelBaseArray[n4];
                if (workspaceModel != null && workspaceModel.getBundleDescription() != null) {
                    ExportPackageDescription[] exportPackageDescriptionArray = workspaceModel.getBundleDescription().getExportPackages();
                    int n5 = exportPackageDescriptionArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ExportPackageDescription export = exportPackageDescriptionArray[n6];
                        if (importPackage.isSatisfiedBy((BaseDescription)export)) {
                            this.installBundle(workspaceModel);
                            break;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void checkRequireBundleDependencies(IPluginModelBase model) {
        BundleDescription desc = model.getBundleDescription();
        if (desc == null) {
            return;
        }
        BundleSpecification[] bundleSpecificationArray = desc.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            int n3 = iPluginModelBaseArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPluginModelBase workspaceModel = iPluginModelBaseArray[n4];
                if (requiredBundle.isSatisfiedBy((BaseDescription)workspaceModel.getBundleDescription())) {
                    this.installBundle(workspaceModel);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void installBundle(IPluginModelBase model) {
        try {
            IResource candidateManifest = model.getUnderlyingResource();
            IProject project = candidateManifest.getProject();
            URL url = null;
            try {
                url = project.getLocationURI().toURL();
            }
            catch (MalformedURLException e) {
                try {
                    URI uri = project.getLocationURI();
                    IFileStore store = EFS.getStore((URI)uri);
                    File file = store.toLocalFile(0, null);
                    if (file != null) {
                        url = file.toURI().toURL();
                    }
                }
                catch (CoreException ex) {
                    AcceleoCommonPlugin.log((Exception)e, (boolean)false);
                    AcceleoCommonPlugin.log((Exception)((Object)ex), (boolean)false);
                }
            }
            if (url != null) {
                String candidateLocationReference = REFERENCE_URI_PREFIX + URLDecoder.decode(url.toExternalForm(), System.getProperty("file.encoding"));
                Bundle bundle = org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil.getBundle((String)candidateLocationReference);
                if (bundle == null) {
                    this.checkRequireBundleDependencies(model);
                    bundle = this.installBundle(candidateLocationReference);
                    this.setBundleClasspath(project, bundle);
                    this.workspaceInstalledBundles.put(model, bundle);
                    this.checkImportPackagesDependencies(model);
                }
                this.refreshPackages(new Bundle[]{bundle});
            }
        }
        catch (BundleException e) {
            String bundleName = model.getBundleDescription().getName();
            if (!this.logOnceProjectLoad.contains(bundleName)) {
                this.logOnceProjectLoad.add(bundleName);
                AcceleoCommonPlugin.log((IStatus)new Status(2, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString((String)"WorkspaceUtil.InstallationFailure", (Object[])new Object[]{bundleName, e.getMessage()}), (Throwable)e));
            }
        }
        catch (MalformedURLException e) {
            AcceleoCommonPlugin.log((Exception)e, (boolean)false);
        }
        catch (UnsupportedEncodingException e) {
            AcceleoCommonPlugin.log((Exception)e, (boolean)false);
        }
    }

    private Bundle installBundle(String pluginLocation) throws BundleException, IllegalStateException {
        Bundle target = AcceleoCommonPlugin.getDefault().getContext().installBundle(pluginLocation);
        int state = target.getState();
        if (state != 2) {
            throw new IllegalStateException(AcceleoCommonMessages.getString((String)"WorkspaceUtil.IllegalBundleState", (Object[])new Object[]{target, state}));
        }
        return target;
    }

    private Class<?> internalLoadClass(Bundle bundle, String qualifiedName) {
        try {
            Class clazz;
            WorkspaceClassInstance workspaceInstance = this.workspaceLoadedClasses.get(qualifiedName);
            if (workspaceInstance == null) {
                clazz = bundle.loadClass(qualifiedName);
                this.workspaceLoadedClasses.put(qualifiedName, new WorkspaceClassInstance(clazz, bundle.getSymbolicName()));
            } else if (workspaceInstance.isStale()) {
                clazz = bundle.loadClass(qualifiedName);
                workspaceInstance.setStale(false);
                workspaceInstance.setClass(clazz);
            } else {
                clazz = workspaceInstance.getClassInstance();
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            e.fillInStackTrace();
            AcceleoCommonPlugin.log((String)AcceleoCommonMessages.getString((String)"BundleClassLookupFailure", (Object[])new Object[]{qualifiedName, bundle.getSymbolicName()}), (Exception)e, (boolean)false);
            return null;
        }
    }

    private void setBundleClasspath(IProject plugin, Bundle bundle) {
    }

    class WorkspaceResourcesListener
    implements IResourceChangeListener {
        WorkspaceResourcesListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: 
                case 4: {
                    IProject project;
                    IPluginModelBase model;
                    if (!(event.getResource() instanceof IProject) || (model = PluginRegistry.findModel((IProject)(project = (IProject)event.getResource()))) == null) break;
                    Bundle bundle = AcceleoWorkspaceUtil.this.workspaceInstalledBundles.remove(model);
                    AcceleoWorkspaceUtil.this.changedContributions.remove(model);
                    if (bundle == null) break;
                    try {
                        AcceleoWorkspaceUtil.this.uninstallBundle(bundle);
                    }
                    catch (BundleException e) {
                        AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString((String)AcceleoWorkspaceUtil.UNINSTALLATION_FAILURE_KEY, (Object[])new Object[]{bundle.getSymbolicName()}), (Throwable)e));
                    }
                    break;
                }
                case 16: {
                    this.processBuildEvent(event);
                }
            }
        }

        private void processBuildEvent(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            switch (event.getBuildKind()) {
                case 9: {
                    if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) break;
                }
                case 10: {
                    AcceleoDeltaVisitor visitor = new AcceleoDeltaVisitor();
                    try {
                        delta.accept((IResourceDeltaVisitor)visitor);
                    }
                    catch (CoreException e) {
                        AcceleoCommonPlugin.log((Exception)((Object)e), (boolean)false);
                    }
                    for (IProject changed : visitor.getChangedProjects()) {
                        IPluginModelBase model = PluginRegistry.findModel((IProject)changed);
                        if (model == null || !AcceleoWorkspaceUtil.this.workspaceInstalledBundles.keySet().contains(model)) continue;
                        AcceleoWorkspaceUtil.this.changedContributions.add(model);
                    }
                    for (String changedClass : visitor.getChangedClasses()) {
                        WorkspaceClassInstance workspaceInstance = AcceleoWorkspaceUtil.this.workspaceLoadedClasses.get(changedClass);
                        if (workspaceInstance == null) continue;
                        workspaceInstance.setStale(true);
                    }
                    break;
                }
                case 6: {
                    for (Map.Entry<IPluginModelBase, Bundle> entry : AcceleoWorkspaceUtil.this.workspaceInstalledBundles.entrySet()) {
                        IPluginModelBase model = entry.getKey();
                        if (model == null) continue;
                        AcceleoWorkspaceUtil.this.changedContributions.add(model);
                    }
                    for (WorkspaceClassInstance workspaceInstance : AcceleoWorkspaceUtil.this.workspaceLoadedClasses.values()) {
                        workspaceInstance.setStale(true);
                    }
                    break;
                }
                case 15: {
                    Iterator<Map.Entry<IPluginModelBase, Bundle>> workspaceBundleIterator = AcceleoWorkspaceUtil.this.workspaceInstalledBundles.entrySet().iterator();
                    while (workspaceBundleIterator.hasNext()) {
                        Map.Entry<IPluginModelBase, Bundle> entry = workspaceBundleIterator.next();
                        Bundle bundle = entry.getValue();
                        try {
                            AcceleoWorkspaceUtil.this.uninstallBundle(bundle);
                        }
                        catch (BundleException e) {
                            AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString((String)AcceleoWorkspaceUtil.UNINSTALLATION_FAILURE_KEY, (Object[])new Object[]{bundle.getSymbolicName()}), (Throwable)e));
                        }
                        workspaceBundleIterator.remove();
                    }
                    for (WorkspaceClassInstance workspaceInstance : AcceleoWorkspaceUtil.this.workspaceLoadedClasses.values()) {
                        workspaceInstance.setStale(true);
                    }
                    break;
                }
            }
        }
    }
}

