/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ISelectionValidator;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.SelectionList;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.SelectionStatusDialog;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.StatusInfo;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractElementListSelectionDialog
extends SelectionStatusDialog {
    private ILabelProvider fRenderer;
    private boolean fIgnoreCase;
    private boolean fIsMultipleSelection;
    private SelectionList fSelectionList;
    private Label fMessage;
    private ISelectionValidator fValidator;
    private String fMessageText;
    private String fEmptyListMessage;
    private String fNothingSelectedMessage;
    private StatusInfo fCurrStatus;

    protected void access$superOpen() {
        super.open();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected Point computeInitialSize() {
        return new Point(this.convertWidthInCharsToPixels(60), this.convertHeightInCharsToPixels(18));
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.fMessage = this.createMessage(contents);
        int flags = this.fIsMultipleSelection ? 2 : 4;
        this.fSelectionList = new SelectionList(contents, flags | 0x800 | 0x200 | 0x100, this.fRenderer, this.fIgnoreCase);
        this.fSelectionList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractElementListSelectionDialog.this.handleDoubleClick();
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractElementListSelectionDialog.this.verifyCurrentSelection();
            }
        });
        GridData spec = new GridData();
        Point initialSize = this.computeInitialSize();
        spec.widthHint = initialSize.x;
        spec.heightHint = initialSize.y;
        spec.grabExcessVerticalSpace = true;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 4;
        this.fSelectionList.setLayoutData(spec);
        return contents;
    }

    protected Label createMessage(Composite parent) {
        Label text = new Label(parent, 0);
        text.setText(this.fMessageText);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        text.setLayoutData((Object)spec);
        return text;
    }

    @Override
    public void create() {
        super.create();
        if (this.isEmptyList()) {
            this.fMessage.setEnabled(false);
            this.fSelectionList.setEnabled(false);
        } else {
            this.verifyCurrentSelection();
            this.fSelectionList.selectFilterText();
            this.fSelectionList.setFocus();
        }
    }

    protected String getFilter() {
        return this.fSelectionList.getFilter();
    }

    protected int[] getSelectionIndices() {
        return this.fSelectionList.getSelectionIndices();
    }

    protected List<Object> getWidgetSelection() {
        if (this.fSelectionList == null || this.fSelectionList.isDisposed()) {
            return new ArrayList<Object>(0);
        }
        return this.fSelectionList.getSelection();
    }

    protected abstract void handleDoubleClick();

    protected boolean isEmptyList() {
        if (this.fSelectionList == null) {
            return true;
        }
        return this.fSelectionList.isEmptyList();
    }

    protected AbstractElementListSelectionDialog(Shell parent, String title, Image image, ILabelProvider renderer, boolean ignoreCase, boolean multipleSelection) {
        super(parent);
        this.setTitle(title);
        this.setImage(image);
        this.fRenderer = renderer;
        this.fIgnoreCase = ignoreCase;
        this.fIsMultipleSelection = multipleSelection;
        this.fMessageText = "";
        this.fCurrStatus = new StatusInfo();
        this.fValidator = null;
        this.fEmptyListMessage = "";
        this.fNothingSelectedMessage = "";
    }

    protected AbstractElementListSelectionDialog(Shell parent, ILabelProvider renderer, boolean ignoreCase, boolean multipleSelection) {
        this(parent, "", null, renderer, ignoreCase, multipleSelection);
    }

    public int open() {
        BusyIndicator.showWhile(null, () -> this.access$superOpen());
        return this.getReturnCode();
    }

    protected void refilter() {
        this.fSelectionList.filter(true);
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    protected void setFilter(String text, boolean refilter) {
        this.fSelectionList.setFilter(text, refilter);
    }

    public void setMessage(String message) {
        this.fMessageText = message;
    }

    public void setNothingSelectedMessage(String message) {
        this.fNothingSelectedMessage = message;
    }

    protected void setSelection(int[] selection) {
        this.fSelectionList.setSelection(selection);
    }

    protected void setSelectionListElements(List<Object> elements, boolean refilter) {
        this.fSelectionList.setElements(elements, refilter);
    }

    public void setValidator(ISelectionValidator validator) {
        this.fValidator = validator;
    }

    protected boolean verifyCurrentSelection() {
        List<Object> sel = this.getWidgetSelection();
        int length = sel.size();
        if (length > 0) {
            if (this.fValidator != null) {
                this.fValidator.isValid(sel.toArray(), this.fCurrStatus);
            } else {
                this.fCurrStatus.setOK();
            }
        } else if (this.isEmptyList()) {
            this.fCurrStatus.setError(this.fEmptyListMessage);
        } else {
            this.fCurrStatus.setError(this.fNothingSelectedMessage);
        }
        this.updateStatus(this.fCurrStatus);
        return this.fCurrStatus.isOK();
    }
}

