/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class DefaultGCCDependencyCalculator
implements IManagedDependencyGenerator {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public final String WHITESPACE = " ";

    @Override
    public IResource[] findDependencies(IResource resource, IProject project) {
        return null;
    }

    @Override
    public int getCalculatorType() {
        return 1;
    }

    @Override
    public String getDependencyCommand(IResource resource, IManagedBuildInfo info) {
        ITool[] tools;
        StringBuilder buffer = new StringBuilder();
        IConfiguration config = info.getDefaultConfiguration();
        IResourceConfiguration resConfig = null;
        if (config != null) {
            resConfig = config.getResourceConfiguration(resource.getFullPath().toString());
        }
        String inputExtension = resource.getFileExtension();
        String outputExtension = info.getOutputExtension(inputExtension);
        IContainer resourceLocation = resource.getParent();
        String relativePath = "";
        if (resourceLocation != null) {
            relativePath = String.valueOf(relativePath) + resourceLocation.getProjectRelativePath().toString();
        }
        if (relativePath.length() > 0) {
            relativePath = String.valueOf(relativePath) + "/";
        }
        String depRule = "'$(@:%." + outputExtension + "=%." + "d" + ")'";
        buffer.append("\techo -n ").append(depRule).append(" $(dir $@) > ").append(depRule).append(" && \\\n");
        IManagedCommandLineInfo cmdLInfo = null;
        String buildCmd = null;
        String[] inputs = new String[]{"$<"};
        String outflag = "";
        String outputPrefix = "";
        String outputFile = "";
        if (resConfig != null && (tools = resConfig.getToolsToInvoke()) != null && tools.length > 0) {
            ITool tool = tools[0];
            String cmd = tool.getToolCommand();
            try {
                String resolvedCommand = null;
                resolvedCommand = resource.getProjectRelativePath().toString().indexOf(" ") != -1 ? ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, "", " ", 1, new FileContextData(resource.getLocation(), null, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, "", " ", 1, new FileContextData(resource.getLocation(), null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    cmd = resolvedCommand;
                }
            }
            catch (BuildMacroException resolvedCommand) {
                // empty catch block
            }
            String[] toolFlags = null;
            try {
                toolFlags = tool.getToolCommandFlags(resource.getLocation(), null);
            }
            catch (BuildException ex) {
                toolFlags = EMPTY_STRING_ARRAY;
            }
            String[] flags = new String[toolFlags.length + 4];
            flags[0] = "-MM";
            flags[1] = "-MG";
            flags[2] = "-P";
            flags[3] = "-w";
            int i = 0;
            while (i < toolFlags.length) {
                flags[4 + i] = toolFlags[i];
                ++i;
            }
            IManagedCommandLineGenerator cmdLGen = tool.getCommandLineGenerator();
            cmdLInfo = cmdLGen.generateCommandLineInfo(tool, cmd, flags, outflag, outputPrefix, outputFile, inputs, tool.getCommandLinePattern());
            buildCmd = cmdLInfo.getCommandLine();
            try {
                String resolvedCommand = null;
                resolvedCommand = resource.getProjectRelativePath().toString().indexOf(" ") != -1 ? ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, "", " ", 1, new FileContextData(resource.getLocation(), null, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, "", " ", 1, new FileContextData(resource.getLocation(), null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    buildCmd = resolvedCommand;
                }
            }
            catch (BuildMacroException resolvedCommand) {}
        } else {
            String buildFlags;
            String[] flags;
            ITool tool = null;
            IFolderInfo foInfo = (IFolderInfo)config.getResourceInfo(resource.getProjectRelativePath(), false);
            tools = foInfo.getFilteredTools();
            int index = 0;
            while (index < tools.length) {
                ITool tmp = tools[index];
                if (tmp.buildsFileType(inputExtension)) {
                    tool = tmp;
                    break;
                }
                ++index;
            }
            String cmd = tool != null ? tool.getToolCommand() : null;
            try {
                String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, "", " ", 1, new FileContextData(resource.getLocation(), null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    cmd = resolvedCommand;
                }
            }
            catch (BuildMacroException resolvedCommand) {
                // empty catch block
            }
            buildCmd = (cmdLInfo = info.generateToolCommandLineInfo(inputExtension, flags = (buildFlags = "-MM -MG -P -w " + info.getToolFlagsForSource(inputExtension, resource.getLocation(), null)).split("\\s"), outflag, outputPrefix, outputFile, inputs, resource.getLocation(), null)) == null ? String.valueOf(cmd) + " " + "-MM -MG -P -w " + buildFlags + " " + "$<" : cmdLInfo.getCommandLine();
            try {
                String resolvedCommand = null;
                resolvedCommand = resource.getProjectRelativePath().toString().indexOf(" ") != -1 ? ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, "", " ", 1, new FileContextData(resource.getLocation(), null, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, "", " ", 1, new FileContextData(resource.getLocation(), null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    buildCmd = resolvedCommand;
                }
            }
            catch (BuildMacroException buildMacroException) {
                // empty catch block
            }
        }
        buffer.append("\t").append(buildCmd).append(" >> ").append(depRule);
        return buffer.toString();
    }
}

