/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.text.ScriptElementProvider;
import org.eclipse.dltk.ruby.internal.ui.text.IRubyPartitions;
import org.eclipse.dltk.ruby.internal.ui.text.RubyAutoEditStrategy;
import org.eclipse.dltk.ruby.internal.ui.text.RubyCodeScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubyDocScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubySingleQuoteStringScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubyStringScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubyTextTools;
import org.eclipse.dltk.ruby.internal.ui.text.completion.RubyCompletionProcessor;
import org.eclipse.dltk.ruby.internal.ui.text.completion.RubyContentAssistPreference;
import org.eclipse.dltk.ruby.internal.ui.typehierarchy.RubyHierarchyInformationControl;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RubySourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private RubyTextTools fTextTools;
    private RubyCodeScanner fCodeScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fSingleQuoteStringScanner;
    private AbstractScriptScanner fCommentScanner;
    private AbstractScriptScanner fDocScanner;

    public RubySourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return IRubyPartitions.RUBY_PARTITION_TYPES;
    }

    protected void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new RubyCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new RubyStringScanner(this.getColorManager(), this.fPreferenceStore);
        this.fSingleQuoteStringScanner = new RubySingleQuoteStringScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = this.createCommentScanner("DLTK_single_line_comment", "DLTK_comment_task_tag");
        this.fDocScanner = new RubyDocScanner(this.getColorManager(), this.fPreferenceStore);
    }

    private boolean isNewSetup() {
        return this.fTextTools == null;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_percent_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_percent_string");
        dr = new DefaultDamagerRepairer(this.getSingleQuoteStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_single_quote_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_single_quote_string");
        dr = new DefaultDamagerRepairer(this.getDocScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_doc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_doc");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_comment");
        return reconciler;
    }

    private ITokenScanner getSingleQuoteStringScanner() {
        return this.fSingleQuoteStringScanner;
    }

    private ITokenScanner getDocScanner() {
        return this.fDocScanner;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fSingleQuoteStringScanner.affectsBehavior(event)) {
            this.fSingleQuoteStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fDocScanner.affectsBehavior(event)) {
            this.fDocScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event) || this.fSingleQuoteStringScanner.affectsBehavior(event) || this.fCommentScanner.affectsBehavior(event) || this.fDocScanner.affectsBehavior(event);
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
        return parent -> {
            int shellStyle = 16;
            int treeStyle = 768;
            return new RubyHierarchyInformationControl(parent, shellStyle, treeStyle);
        };
    }

    public IInformationPresenter getHierarchyPresenter(ScriptSourceViewer sourceViewer, boolean doCodeResolve) {
        if (this.getEditor() != null && this.getEditor().getEditorInput() != null && EditorUtility.getEditorInputModelElement((IEditorPart)this.getEditor(), (boolean)true) == null) {
            return null;
        }
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator((ISourceViewer)sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning((ISourceViewer)sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        ScriptElementProvider provider = new ScriptElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        return new IAutoEditStrategy[]{new RubyAutoEditStrategy(partitioning)};
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        RubyCompletionProcessor scriptProcessor = new RubyCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__ruby_single_quote_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__ruby_string");
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return RubyContentAssistPreference.getDefault();
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.dltk.ruby.code", this.getEditor());
        return targets;
    }
}

