/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.ftask.internal.registry;

import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.model.EGFFtaskPlugin;
import org.eclipse.egf.model.ftask.task.ITaskNature;
import org.eclipse.osgi.util.NLS;

public class TaskNatureProxy {
    private IConfigurationElement _element;
    private String _uniqueIdentifier;
    private int _handleId = -1;
    private String _kind;
    private String _class;
    private ITaskNature _executable;

    public static TaskNatureProxy createProxy(IConfigurationElement element) {
        String clazz;
        if (element == null || !element.isValid()) {
            return null;
        }
        IExtension declaringExtension = element.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension.getUniqueIdentifier();
        int handleId = -1;
        if (declaringExtension instanceof Handle) {
            handleId = ((Handle)declaringExtension).getId();
        }
        if ((clazz = element.getAttribute("class")) == null || clazz.trim().length() == 0) {
            return null;
        }
        String kind = element.getAttribute("kind");
        if (kind == null || kind.trim().length() == 0) {
            return null;
        }
        return new TaskNatureProxy(element, clazz, kind, uniqueIdentifier, handleId);
    }

    public TaskNatureProxy(IConfigurationElement element, String clazz, String kind, String uniqueIdentifier, int handleId) {
        this._element = element;
        this._class = clazz.trim();
        this._kind = kind.trim();
        if (uniqueIdentifier != null && uniqueIdentifier.trim().length() != 0) {
            this._uniqueIdentifier = uniqueIdentifier.trim();
        }
        this._handleId = handleId;
    }

    public String getUniqueIdentifier() {
        return this._uniqueIdentifier;
    }

    public int getHandleId() {
        return this._handleId;
    }

    public ITaskNature getTaskNature() throws CoreException {
        if (this._executable == null && this._element.isValid()) {
            Object object = this._element.createExecutableExtension("class");
            if (object == null) {
                return null;
            }
            if (!(object instanceof ITaskNature)) {
                EGFFtaskPlugin.getPlugin().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)EGFCommonMessages.Wrong_Class_Sub_Type_Message, (Object)ITaskNature.class.getName()), 1);
                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
                return null;
            }
            this._executable = (ITaskNature)object;
        }
        return this._executable;
    }

    public String getKind() {
        return this._kind;
    }

    public boolean originatesFrom(IExtension extension) {
        String id = extension.getUniqueIdentifier();
        if (id != null) {
            return id.equals(this._uniqueIdentifier);
        }
        if (!(extension instanceof Handle)) {
            return false;
        }
        return this._handleId == ((Handle)extension).getId();
    }
}

