/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataManager
extends Lifecycle
implements IMetaDataManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, MetaDataManager.class);
    private static final boolean ZIP_PACKAGE_BYTES = true;
    private IDBStore store;
    private Map<EModelElement, CDOID> modelElementToMetaID = new HashMap<EModelElement, CDOID>();
    private Map<CDOID, EModelElement> metaIDToModelElement = CDOIDUtil.createMap();

    public MetaDataManager(IDBStore store) {
        this.store = store;
    }

    @Override
    public synchronized CDOID getMetaID(EModelElement modelElement, long commitTime) {
        CDOID metaID = this.modelElementToMetaID.get(modelElement);
        if (metaID != null) {
            return metaID;
        }
        IDBStoreAccessor accessor = (IDBStoreAccessor)StoreThreadLocal.getAccessor();
        String uri = EcoreUtil.getURI((EObject)modelElement).toString();
        metaID = this.store.getIDHandler().mapURI(accessor, uri, commitTime);
        this.cacheMetaIDMapping(modelElement, metaID);
        return metaID;
    }

    @Override
    public synchronized EModelElement getMetaInstance(CDOID id) {
        EModelElement modelElement = this.metaIDToModelElement.get(id);
        if (modelElement != null) {
            return modelElement;
        }
        IDBStoreAccessor accessor = (IDBStoreAccessor)StoreThreadLocal.getAccessor();
        String uri = this.store.getIDHandler().unmapURI(accessor, id);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry((EPackage.Registry)this.getStore().getRepository().getPackageRegistry());
        return (EModelElement)resourceSet.getEObject(URI.createURI((String)uri), true);
    }

    @Override
    public synchronized void clearMetaIDMappings() {
        this.modelElementToMetaID.clear();
        this.metaIDToModelElement.clear();
    }

    @Override
    public final EPackage[] loadPackageUnit(Connection connection, InternalCDOPackageUnit packageUnit) {
        String where = String.valueOf(CDODBSchema.PACKAGE_UNITS_ID.getName()) + "='" + packageUnit.getID() + "'";
        Object[] values = DBUtil.select((Connection)connection, (String)where, (IDBField[])new IDBField[]{CDODBSchema.PACKAGE_UNITS_PACKAGE_DATA});
        byte[] bytes = (byte[])values[0];
        EPackage ePackage = this.createEPackage(packageUnit, bytes);
        return EMFUtil.getAllPackages((EPackage)ePackage);
    }

    @Override
    public Collection<InternalCDOPackageUnit> readPackageUnits(Connection connection) {
        return this.readPackageUnits(connection, 0L, 0L, (OMMonitor)new Monitor());
    }

    @Override
    public final void writePackageUnits(Connection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        try {
            monitor.begin(2.0);
            this.fillSystemTables((IDBConnection)connection, packageUnits, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        String where = " WHERE p_u." + CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/2002/Ecore" + "' AND p_u." + CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/CDO/Eresource/4.0.0" + "' AND p_u." + CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/CDO/Etypes/4.0.0" + "' AND p_u." + CDODBSchema.PACKAGE_UNITS_TIME_STAMP + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)CDODBSchema.PACKAGE_UNITS, (String)"p_u", (String)where);
        String join = ", " + CDODBSchema.PACKAGE_UNITS + " p_u" + where + " AND p_i." + CDODBSchema.PACKAGE_INFOS_UNIT + "=p_u." + CDODBSchema.PACKAGE_UNITS_ID;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)CDODBSchema.PACKAGE_INFOS, (String)"p_i", (String)join);
    }

    @Override
    public Collection<InternalCDOPackageUnit> rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        monitor.begin(3.0);
        try {
            DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)CDODBSchema.PACKAGE_UNITS, (OMMonitor)monitor.fork());
            DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)CDODBSchema.PACKAGE_INFOS, (OMMonitor)monitor.fork());
            Collection<InternalCDOPackageUnit> collection = this.readPackageUnits(connection, fromCommitTime, toCommitTime, monitor.fork());
            return collection;
        }
        finally {
            monitor.done();
        }
    }

    protected IDBStore getStore() {
        return this.store;
    }

    protected void doBeforeActivate() throws Exception {
        this.checkState(this.store, "Store is not set");
    }

    protected void doDeactivate() throws Exception {
        this.clearMetaIDMappings();
        super.doDeactivate();
    }

    protected InternalCDOPackageInfo createPackageInfo() {
        return (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
    }

    protected InternalCDOPackageUnit createPackageUnit() {
        return (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
    }

    private InternalCDOPackageRegistry getPackageRegistry() {
        return (InternalCDOPackageRegistry)this.store.getRepository().getPackageRegistry();
    }

    private EPackage createEPackage(InternalCDOPackageUnit packageUnit, byte[] bytes) {
        ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)this.getPackageRegistry());
        return EMFUtil.createEPackage((String)packageUnit.getID(), (byte[])bytes, (boolean)true, (ResourceSet)resourceSet, (boolean)false);
    }

    private byte[] getEPackageBytes(InternalCDOPackageUnit packageUnit) {
        EPackage ePackage = packageUnit.getTopLevelPackageInfo().getEPackage();
        return EMFUtil.getEPackageBytes((EPackage)ePackage, (boolean)true, (EPackage.Registry)this.getPackageRegistry());
    }

    private void fillSystemTables(IDBConnection connection, InternalCDOPackageUnit packageUnit, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing package unit: {0}", new Object[]{packageUnit});
        }
        InternalCDOPackageInfo[] packageInfos = packageUnit.getPackageInfos();
        OMMonitor.Async async = null;
        monitor.begin((double)(1 + packageInfos.length));
        try {
            String sql = "INSERT INTO " + CDODBSchema.PACKAGE_UNITS + " (" + CDODBSchema.PACKAGE_UNITS_ID + ", " + CDODBSchema.PACKAGE_UNITS_ORIGINAL_TYPE + ", " + CDODBSchema.PACKAGE_UNITS_TIME_STAMP + ", " + CDODBSchema.PACKAGE_UNITS_PACKAGE_DATA + ") VALUES (?, ?, ?, ?)";
            DBUtil.trace((String)sql);
            IDBPreparedStatement stmt = connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
            try {
                try {
                    async = monitor.forkAsync();
                    stmt.setString(1, packageUnit.getID());
                    stmt.setInt(2, packageUnit.getOriginalType().ordinal());
                    stmt.setLong(3, packageUnit.getTimeStamp());
                    stmt.setBytes(4, this.getEPackageBytes(packageUnit));
                    if (stmt.execute()) {
                        throw new DBException("No result set expected");
                    }
                    if (stmt.getUpdateCount() == 0) {
                        throw new DBException("No row inserted into table " + CDODBSchema.PACKAGE_UNITS);
                    }
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
                if (async != null) {
                    async.stop();
                }
            }
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageInfos;
            int n = packageInfos.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                this.fillSystemTables(connection, packageInfo, monitor);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fillSystemTables(IDBConnection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        try {
            monitor.begin((double)packageUnits.length);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
            int n = packageUnits.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                this.fillSystemTables(connection, packageUnit, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fillSystemTables(IDBConnection connection, InternalCDOPackageInfo packageInfo, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing package info: {0}", new Object[]{packageInfo});
        }
        String packageURI = packageInfo.getPackageURI();
        String parentURI = packageInfo.getParentURI();
        String unitID = packageInfo.getPackageUnit().getID();
        String sql = "INSERT INTO " + CDODBSchema.PACKAGE_INFOS + " (" + CDODBSchema.PACKAGE_INFOS_URI + ", " + CDODBSchema.PACKAGE_INFOS_PARENT + ", " + CDODBSchema.PACKAGE_INFOS_UNIT + ") VALUES (?, ?, ?)";
        DBUtil.trace((String)sql);
        IDBPreparedStatement stmt = connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
        OMMonitor.Async async = monitor.forkAsync();
        try {
            try {
                stmt.setString(1, packageURI);
                stmt.setString(2, parentURI);
                stmt.setString(3, unitID);
                if (stmt.execute()) {
                    throw new DBException("No result set expected");
                }
                if (stmt.getUpdateCount() == 0) {
                    throw new DBException("No row inserted into table " + CDODBSchema.PACKAGE_INFOS);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
            if (async != null) {
                async.stop();
            }
        }
    }

    private Collection<InternalCDOPackageUnit> readPackageUnits(Connection connection, long fromCommitTime, long toCommitTime, OMMonitor monitor) {
        final HashMap packageUnits = new HashMap();
        IDBRowHandler unitRowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                int index = DBUtil.asInt((Object)values[1]);
                long timestamp = DBUtil.asLong((Object)values[2]);
                InternalCDOPackageUnit packageUnit = MetaDataManager.this.createPackageUnit();
                packageUnit.setOriginalType(CDOPackageUnit.Type.values()[index]);
                packageUnit.setTimeStamp(timestamp);
                packageUnits.put((String)values[0], packageUnit);
                return true;
            }
        };
        String where = null;
        if (fromCommitTime != 0L) {
            where = CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/2002/Ecore" + "' AND " + CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/CDO/Eresource/4.0.0" + "' AND " + CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/CDO/Etypes/4.0.0" + "' AND " + CDODBSchema.PACKAGE_UNITS_TIME_STAMP + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        }
        DBUtil.select((Connection)connection, (IDBRowHandler)unitRowHandler, where, (IDBField[])new IDBField[]{CDODBSchema.PACKAGE_UNITS_ID, CDODBSchema.PACKAGE_UNITS_ORIGINAL_TYPE, CDODBSchema.PACKAGE_UNITS_TIME_STAMP});
        final HashMap packageInfos = new HashMap();
        IDBRowHandler infoRowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                InternalCDOPackageInfo packageInfo = MetaDataManager.this.createPackageInfo();
                packageInfo.setPackageURI((String)values[1]);
                packageInfo.setParentURI((String)values[2]);
                String unit = (String)values[0];
                ArrayList<InternalCDOPackageInfo> list = (ArrayList<InternalCDOPackageInfo>)packageInfos.get(unit);
                if (list == null) {
                    list = new ArrayList<InternalCDOPackageInfo>();
                    packageInfos.put(unit, list);
                }
                list.add(packageInfo);
                return true;
            }
        };
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            DBUtil.select((Connection)connection, (IDBRowHandler)infoRowHandler, (IDBField[])new IDBField[]{CDODBSchema.PACKAGE_INFOS_UNIT, CDODBSchema.PACKAGE_INFOS_URI, CDODBSchema.PACKAGE_INFOS_PARENT});
        }
        finally {
            async.stop();
            monitor.done();
        }
        for (Map.Entry entry : packageUnits.entrySet()) {
            String id = (String)entry.getKey();
            InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)entry.getValue();
            List list = (List)packageInfos.get(id);
            InternalCDOPackageInfo[] array = list.toArray(new InternalCDOPackageInfo[list.size()]);
            packageUnit.setPackageInfos(array);
        }
        return packageUnits.values();
    }

    private void cacheMetaIDMapping(EModelElement modelElement, CDOID metaID) {
        this.modelElementToMetaID.put(modelElement, metaID);
        this.metaIDToModelElement.put(metaID, modelElement);
    }
}

