/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.spi.transfer.ResourceFactoryRegistryWithoutDefaults;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferMapping;
import org.eclipse.emf.cdo.transfer.CDOTransferMappingImpl;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.cdo.transfer.CDOTransferType;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.monitor.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOTransfer
implements INotifier {
    protected final Notifier notifier = new Notifier();
    private final CDOTransferSystem sourceSystem;
    private final CDOTransferSystem targetSystem;
    private final CDOTransferMapping rootMapping = new CDOTransferMappingImpl(this);
    private final Map<CDOTransferElement, CDOTransferMapping> mappings = new HashMap<CDOTransferElement, CDOTransferMapping>();
    private CDOTransferType defaultTransferType = CDOTransferType.BINARY;
    private ModelTransferContext modelTransferContext = this.createModelTransferContext();
    private PathProvider pathProvider = PathProvider.DEFAULT;

    public CDOTransfer(CDOTransferSystem sourceSystem, CDOTransferSystem targetSystem) {
        this.sourceSystem = sourceSystem;
        this.targetSystem = targetSystem;
    }

    public void addListener(IListener listener) {
        this.notifier.addListener(listener);
    }

    public void removeListener(IListener listener) {
        this.notifier.removeListener(listener);
    }

    public boolean hasListeners() {
        return this.notifier.hasListeners();
    }

    public IListener[] getListeners() {
        return this.notifier.getListeners();
    }

    public final CDOTransferSystem getSourceSystem() {
        return this.sourceSystem;
    }

    public final CDOTransferSystem getTargetSystem() {
        return this.targetSystem;
    }

    public final PathProvider getPathProvider() {
        return this.pathProvider;
    }

    public final void setPathProvider(PathProvider pathProvider) {
        this.pathProvider = pathProvider;
    }

    public ModelTransferContext getModelTransferContext() {
        return this.modelTransferContext;
    }

    public final CDOTransferType getDefaultTransferType() {
        return this.defaultTransferType;
    }

    public final void setDefaultTransferType(CDOTransferType defaultTransferType) {
        if (defaultTransferType == CDOTransferType.FOLDER) {
            throw new IllegalArgumentException();
        }
        this.defaultTransferType = defaultTransferType;
    }

    public Set<CDOTransferType> getUsedTransferTypes() {
        final HashSet<CDOTransferType> result = new HashSet<CDOTransferType>();
        this.rootMapping.accept(new CDOTransferMapping.Visitor(){

            public boolean visit(CDOTransferMapping mapping) {
                result.add(mapping.getTransferType());
                return true;
            }
        });
        return result;
    }

    public final CDOTransferMapping getRootMapping() {
        return this.rootMapping;
    }

    public IPath getTargetPath() {
        return this.rootMapping.getRelativePath();
    }

    public void setTargetPath(IPath targetPath) {
        this.rootMapping.setRelativePath(targetPath);
    }

    public void setTargetPath(String path) {
        this.rootMapping.setRelativePath(path);
    }

    public int getMappingCount() {
        return this.mappings.size();
    }

    public CDOTransferMapping map(IPath sourcePath, IProgressMonitor monitor) {
        CDOTransferElement source = this.sourceSystem.getElement(sourcePath);
        return this.map(source, monitor);
    }

    public CDOTransferMapping map(String sourcePath, IProgressMonitor monitor) {
        return this.map((IPath)new Path(sourcePath), monitor);
    }

    public CDOTransferMapping map(CDOTransferElement source, IProgressMonitor monitor) {
        return this.map(source, this.rootMapping, monitor);
    }

    protected CDOTransferMapping map(CDOTransferElement source, CDOTransferMapping parent, IProgressMonitor monitor) {
        CDOTransferMapping mapping = this.mappings.get(source);
        if (mapping == null) {
            mapping = this.createMapping(source, parent, monitor);
            this.mappings.put(source, mapping);
        } else if (mapping.getParent() != parent) {
            throw new IllegalStateException();
        }
        return mapping;
    }

    protected void unmap(CDOTransferMapping mapping) {
        this.mappings.remove(mapping.getSource());
        mapping.getChildren();
    }

    protected CDOTransferMapping createMapping(CDOTransferElement source, CDOTransferMapping parent, IProgressMonitor monitor) {
        return new CDOTransferMappingImpl(this, source, parent, monitor);
    }

    protected ModelTransferContext createModelTransferContext() {
        return new ModelTransferContext(this);
    }

    protected CDOTransferType getTransferType(CDOTransferElement source) {
        if (source.isDirectory()) {
            return CDOTransferType.FOLDER;
        }
        CDOTransferType type = this.sourceSystem.getDefaultTransferType(source);
        if (type != null) {
            return type;
        }
        if (this.modelTransferContext.hasResourceFactory(source)) {
            return CDOTransferType.MODEL;
        }
        return this.getDefaultTransferType();
    }

    protected void validate(CDOTransferMapping mapping, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (mapping.getStatus() == CDOTransferMapping.Status.CONFLICT) {
            throw new IllegalStateException("Conflict: " + mapping);
        }
        monitor.worked(1);
        CDOTransferMapping[] cDOTransferMappingArray = mapping.getChildren();
        int n = cDOTransferMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOTransferMapping child = cDOTransferMappingArray[n2];
            this.validate(child, monitor);
            ++n2;
        }
    }

    public void perform() {
        this.perform((IProgressMonitor)new NullProgressMonitor());
    }

    public void perform(IProgressMonitor monitor) {
        try {
            int mappingCount = this.getMappingCount();
            monitor.beginTask("Perform transfer from " + this.getSourceSystem() + " to " + this.getTargetSystem(), 5 * mappingCount);
            monitor.subTask("Validating transfer");
            this.validate(this.rootMapping, (IProgressMonitor)new SubProgressMonitor(monitor, mappingCount));
            this.perform(this.rootMapping, monitor);
            this.modelTransferContext.performFinish((IProgressMonitor)new SubProgressMonitor(monitor, 2 * mappingCount));
        }
        finally {
            monitor.done();
        }
    }

    protected void perform(CDOTransferMapping mapping, IProgressMonitor monitor) {
        monitor.subTask("Transferring " + mapping);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        CDOTransferType transferType = mapping.getTransferType();
        if (transferType == CDOTransferType.FOLDER) {
            this.performFolder(mapping, monitor);
        } else if (transferType == CDOTransferType.MODEL) {
            this.performModel(mapping, monitor);
        } else if (transferType == CDOTransferType.BINARY) {
            this.performBinary(mapping, monitor);
        } else if (transferType instanceof CDOTransferType.Text) {
            String encoding = ((CDOTransferType.Text)transferType).getEncoding();
            this.performText(mapping, encoding, monitor);
        }
    }

    protected void performFolder(CDOTransferMapping mapping, IProgressMonitor monitor) {
        if (mapping.getStatus() == CDOTransferMapping.Status.NEW) {
            this.targetSystem.createFolder(mapping.getFullPath());
        }
        monitor.worked(2);
        CDOTransferMapping[] cDOTransferMappingArray = mapping.getChildren();
        int n = cDOTransferMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOTransferMapping child = cDOTransferMappingArray[n2];
            this.perform(child, monitor);
            ++n2;
        }
    }

    protected void performModel(CDOTransferMapping mapping, IProgressMonitor monitor) {
        this.modelTransferContext.perform(mapping, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
    }

    protected void performBinary(CDOTransferMapping mapping, IProgressMonitor monitor) {
        IPath path = mapping.getFullPath();
        InputStream source = mapping.getSource().openInputStream();
        try {
            this.targetSystem.createBinary(path, source, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            IOUtil.close((Closeable)source);
        }
    }

    protected void performText(CDOTransferMapping mapping, String encoding, IProgressMonitor monitor) {
        IPath path = mapping.getFullPath();
        InputStream source = mapping.getSource().openInputStream();
        try {
            this.targetSystem.createText(path, source, encoding, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            IOUtil.close((Closeable)source);
        }
    }

    protected void childrenChanged(CDOTransferMapping mapping, CDOTransferMapping child, ChildrenChangedEvent.Kind kind) {
        IListener[] listeners;
        if (child.getTransferType() == CDOTransferType.MODEL) {
            if (kind == ChildrenChangedEvent.Kind.MAPPED) {
                this.modelTransferContext.addModelMapping(child);
            } else {
                this.modelTransferContext.removeModelMapping(child);
            }
        }
        if ((listeners = this.notifier.getListeners()) != null) {
            this.notifier.fireEvent((IEvent)new ChildrenChangedEvent(mapping, child, kind), listeners);
        }
    }

    protected void relativePathChanged(CDOTransferMapping mapping, IPath oldPath, IPath newPath) {
        IListener[] listeners = this.notifier.getListeners();
        if (listeners != null) {
            this.notifier.fireEvent((IEvent)new RelativePathChangedEvent(mapping, oldPath, newPath), listeners);
        }
    }

    protected void transferTypeChanged(CDOTransferMapping mapping, CDOTransferType oldType, CDOTransferType newType) {
        IListener[] listeners;
        if (oldType == CDOTransferType.MODEL) {
            this.modelTransferContext.removeModelMapping(mapping);
        }
        if (newType == CDOTransferType.MODEL) {
            this.modelTransferContext.addModelMapping(mapping);
        }
        if ((listeners = this.notifier.getListeners()) != null) {
            this.notifier.fireEvent((IEvent)new TransferTypeChangedEvent(mapping, oldType, newType), listeners);
        }
    }

    public static class ChildrenChangedEvent
    extends MappingEvent {
        private static final long serialVersionUID = 1L;
        private CDOTransferMapping child;
        private Kind kind;

        ChildrenChangedEvent(CDOTransferMapping mapping, CDOTransferMapping child, Kind kind) {
            super(mapping);
            this.child = child;
            this.kind = kind;
        }

        public boolean hasTreeImpact() {
            return true;
        }

        public CDOTransferMapping getChild() {
            return this.child;
        }

        public Kind getKind() {
            return this.kind;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            MAPPED,
            UNMAPPED;

        }
    }

    public static abstract class MappingEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private CDOTransferMapping mapping;

        private MappingEvent(CDOTransferMapping mapping) {
            super((INotifier)mapping.getTransfer());
            this.mapping = mapping;
        }

        public CDOTransferMapping getMapping() {
            return this.mapping;
        }

        public abstract boolean hasTreeImpact();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModelTransferContext {
        private final CDOTransfer transfer;
        private ResourceSet sourceResourceSet;
        private ResourceSet targetResourceSet;
        private Map<CDOTransferElement, Resource> elementResources = new HashMap<CDOTransferElement, Resource>();
        private Map<Resource, CDOTransferElement> resourceElements = new HashMap<Resource, CDOTransferElement>();
        private Set<Resource> unmappedModels;
        private Map<URI, ModelTransferResolution> resolutions = new HashMap<URI, ModelTransferResolution>();
        private ResolveProxyAdapter resolveProxyAdapter;
        private EcoreUtil.Copier copier;

        protected ModelTransferContext(CDOTransfer transfer) {
            this.transfer = transfer;
            this.resolveProxyAdapter = new ResolveProxyAdapter();
            this.copier = this.createCopier();
        }

        public final CDOTransfer getTransfer() {
            return this.transfer;
        }

        public final ResourceSet getSourceResourceSet() {
            if (this.sourceResourceSet == null) {
                CDOTransferSystem sourceSystem = this.transfer.getSourceSystem();
                this.sourceResourceSet = sourceSystem.provideResourceSet();
                if (this.sourceResourceSet == null) {
                    this.sourceResourceSet = this.createResourceSet(sourceSystem);
                }
            }
            return this.sourceResourceSet;
        }

        public final ResourceSet getTargetResourceSet() {
            if (this.targetResourceSet == null) {
                CDOTransferSystem targetSystem = this.transfer.getTargetSystem();
                this.targetResourceSet = targetSystem.provideResourceSet();
                if (this.targetResourceSet == null) {
                    this.targetResourceSet = this.createResourceSet(targetSystem);
                }
            }
            return this.targetResourceSet;
        }

        public void registerSourceExtension(String extension, Resource.Factory factory) {
            Map map = this.getSourceResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap();
            map.put(extension, factory);
        }

        public void registerSourceProtocol(String protocol, Resource.Factory factory) {
            Map map = this.getSourceResourceSet().getResourceFactoryRegistry().getProtocolToFactoryMap();
            map.put(protocol, factory);
        }

        public void registerSourceContentType(String contentType, Resource.Factory factory) {
            Map map = this.getSourceResourceSet().getResourceFactoryRegistry().getContentTypeToFactoryMap();
            map.put(contentType, factory);
        }

        public void registerTargetExtension(String extension, Resource.Factory factory) {
            Map map = this.getTargetResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap();
            map.put(extension, factory);
        }

        public void registerTargetProtocol(String protocol, Resource.Factory factory) {
            Map map = this.getTargetResourceSet().getResourceFactoryRegistry().getProtocolToFactoryMap();
            map.put(protocol, factory);
        }

        public void registerTargetContentType(String contentType, Resource.Factory factory) {
            Map map = this.getTargetResourceSet().getResourceFactoryRegistry().getContentTypeToFactoryMap();
            map.put(contentType, factory);
        }

        public Set<Resource> getUnmappedModels() {
            if (this.unmappedModels == null) {
                this.unmappedModels = this.resolve();
                this.fireUnmappedModelsEvent();
            }
            return this.unmappedModels;
        }

        public ModelTransferResolution getResolution(URI uri) {
            return this.resolutions.get(uri);
        }

        public ModelTransferResolution setResolution(URI uri, ModelTransferResolution resolution) {
            ModelTransferResolution old = this.resolutions.put(uri, resolution);
            if (resolution != old) {
                this.fireUnmappedModelsEvent();
            }
            return old;
        }

        protected Set<Resource> resolve() {
            Set<Resource> mappedModels = this.resourceElements.keySet();
            ResourceSet resourceSet = this.getSourceResourceSet();
            EList resources = resourceSet.getResources();
            HashSet<Resource> unmappedModels = new HashSet<Resource>((Collection<Resource>)resources);
            unmappedModels.removeAll(mappedModels);
            return unmappedModels;
        }

        protected void fireUnmappedModelsEvent() {
            this.transfer.notifier.fireEvent((IEvent)new UnmappedModelsEvent(this.transfer));
        }

        protected void addModelMapping(CDOTransferMapping mapping) {
            CDOTransferElement element = mapping.getSource();
            URI uri = element.getURI();
            ResourceSet resourceSet = this.getSourceResourceSet();
            Resource resource = resourceSet.getResource(uri, true);
            this.elementResources.put(element, resource);
            this.resourceElements.put(resource, element);
            this.unmappedModels = null;
            this.fireUnmappedModelsEvent();
        }

        protected void removeModelMapping(CDOTransferMapping mapping) {
            CDOTransferElement element = mapping.getSource();
            Resource resource = this.elementResources.remove(element);
            if (resource != null) {
                this.resourceElements.remove(resource);
                resource.unload();
                ResourceSet resourceSet = this.getSourceResourceSet();
                resourceSet.getResources().remove((Object)resource);
            }
            this.unmappedModels = null;
            this.fireUnmappedModelsEvent();
        }

        protected Resource getSourceResource(CDOTransferMapping mapping) {
            URI uri = mapping.getSource().getURI();
            ResourceSet sourceResourceSet = this.getSourceResourceSet();
            return sourceResourceSet.getResource(uri, true);
        }

        protected Resource getTargetResource(CDOTransferMapping mapping) {
            IPath path = mapping.getFullPath();
            ResourceSet targetResourceSet = this.getTargetResourceSet();
            CDOTransferSystem targetSystem = this.transfer.getTargetSystem();
            return targetSystem.createModel(targetResourceSet, path);
        }

        protected EcoreUtil.Copier createCopier() {
            return new EcoreUtil.Copier();
        }

        protected ResourceSet createResourceSet(CDOTransferSystem system) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistryWithoutDefaults());
            resourceSet.eAdapters().add((Object)this.resolveProxyAdapter);
            return resourceSet;
        }

        protected boolean hasResourceFactory(CDOTransferElement source) {
            URI uri = source.getURI();
            Resource.Factory.Registry registry = this.getSourceResourceSet().getResourceFactoryRegistry();
            return registry.getFactory(uri) != null;
        }

        protected void perform(CDOTransferMapping mapping, IProgressMonitor monitor) {
            try {
                monitor.beginTask("", 2);
                Resource sourceResource = this.getSourceResource(mapping);
                Resource targetResource = this.getTargetResource(mapping);
                EList sourceContents = sourceResource.getContents();
                Collection targetContents = this.copier.copyAll((Collection)sourceContents);
                monitor.worked(1);
                EList contents = targetResource.getContents();
                contents.addAll(targetContents);
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }

        protected void performFinish(IProgressMonitor monitor) {
            monitor.subTask("Copying model references");
            this.copier.copyReferences();
            CDOTransferSystem targetSystem = this.getTransfer().getTargetSystem();
            targetSystem.saveModels((EList<Resource>)this.getTargetResourceSet().getResources(), monitor);
        }

        public static class ResolveProxyAdapter
        extends AdapterImpl {
            private LoadResourceAdapter loadResourceAdapter = new LoadResourceAdapter();

            public void notifyChanged(Notification msg) {
                int eventType = msg.getEventType();
                switch (eventType) {
                    case 1: {
                        Resource newValue;
                        Resource oldValue = (Resource)msg.getOldValue();
                        if (oldValue != null) {
                            this.removeResource(oldValue);
                        }
                        if ((newValue = (Resource)msg.getNewValue()) == null) break;
                        this.addResource(newValue);
                        break;
                    }
                    case 3: {
                        Resource newValue = (Resource)msg.getNewValue();
                        if (newValue == null) break;
                        this.addResource(newValue);
                        break;
                    }
                    case 5: {
                        Collection newValues = (Collection)msg.getNewValue();
                        for (Resource newValue : newValues) {
                            this.addResource(newValue);
                        }
                        break;
                    }
                    case 4: {
                        Resource oldValue = (Resource)msg.getOldValue();
                        if (oldValue == null) break;
                        this.removeResource(oldValue);
                        break;
                    }
                    case 6: {
                        Collection oldValues = (Collection)msg.getOldValue();
                        for (Resource oldContentValue : oldValues) {
                            this.removeResource(oldContentValue);
                        }
                        break;
                    }
                }
            }

            private void addResource(Resource resource) {
                EcoreUtil.resolveAll((Resource)resource);
                resource.eAdapters().add((Object)this.loadResourceAdapter);
            }

            private void removeResource(Resource resource) {
            }

            public static class LoadResourceAdapter
            extends AdapterImpl {
                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(Resource.class) == 4) {
                        int eventType = msg.getEventType();
                        switch (eventType) {
                            case 1: {
                                boolean isLoaded = msg.getNewBooleanValue();
                                if (!isLoaded) break;
                                Resource resource = (Resource)msg.getNotifier();
                                EcoreUtil.resolveAll((Resource)resource);
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface ModelTransferResolution {
    }

    public static interface PathProvider {
        public static final PathProvider DEFAULT = new PathProvider(){

            public IPath getPath(CDOTransferElement element) {
                return new Path(element.getName());
            }
        };

        public IPath getPath(CDOTransferElement var1);
    }

    public static class RelativePathChangedEvent
    extends MappingEvent {
        private static final long serialVersionUID = 1L;
        private IPath oldPath;
        private IPath newPath;

        RelativePathChangedEvent(CDOTransferMapping mapping, IPath oldPath, IPath newPath) {
            super(mapping);
            this.oldPath = oldPath;
            this.newPath = newPath;
        }

        public boolean hasTreeImpact() {
            return true;
        }

        public IPath getOldPath() {
            return this.oldPath;
        }

        public IPath getNewPath() {
            return this.newPath;
        }
    }

    public static class TransferTypeChangedEvent
    extends MappingEvent {
        private static final long serialVersionUID = 1L;
        private CDOTransferType oldType;
        private CDOTransferType newType;

        TransferTypeChangedEvent(CDOTransferMapping mapping, CDOTransferType oldType, CDOTransferType newType) {
            super(mapping);
            this.oldType = oldType;
            this.newType = newType;
        }

        public boolean hasTreeImpact() {
            return false;
        }

        public CDOTransferType getOldType() {
            return this.oldType;
        }

        public CDOTransferType getNewType() {
            return this.newType;
        }
    }

    public static class UnmappedModelsEvent
    extends Event {
        private static final long serialVersionUID = 1L;

        private UnmappedModelsEvent(CDOTransfer transfer) {
            super((INotifier)transfer);
        }
    }
}

